/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.UUID;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.expressionevaluator.impl.expressionbuilder.formatters.DALFormatter;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.expressionevaluator.DALExpressionBuilder;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;

public class DefaultDALExpressionBuilder
implements DALExpressionBuilder {
    private final SQLBuilderBase sqlbuilder = new SQLBuilderBase();
    private GeometryExpressionBuilder expressionBuilder;

    public GeometryExpressionBuilder expression() {
        if (this.expressionBuilder == null) {
            this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
        }
        return this.expressionBuilder;
    }

    public Formatter<ExpressionBuilder.Value> formatter() {
        return this.formatter(null);
    }

    public Formatter<ExpressionBuilder.Value> formatter(Formatter<ExpressionBuilder.Value> formatter) {
        return new DALFormatter(formatter);
    }

    public SQLBuilder.SelectBuilder select() {
        return this.sqlbuilder.select();
    }

    public DALExpressionBuilder.SelectCountBuilder select_count() {
        return new DefaultSelectCountBuilder();
    }

    public ExpressionBuilder.Function exists(ExpressionBuilder.Value list) {
        return this.exists(list, null);
    }

    public ExpressionBuilder.Function exists(ExpressionBuilder.Value list, String exists_id) {
        if (exists_id == null) {
            exists_id = "EXISTS" + UUID.randomUUID().toString().replaceAll("-", "");
        }
        ExpressionBuilder.Function exists = this.expression().function("EXISTS", new ExpressionBuilder.Value[]{list, this.expression().constant((Object)exists_id)});
        return exists;
    }

    public ExpressionBuilder.Function foreing_value(String attrlocal, String attrforeing) {
        ExpressionBuilder.Function foreing_value = this.expression().function("FOREIGN_VALUE", new ExpressionBuilder.Value[]{this.expression().constant((Object)(attrlocal + "." + attrforeing))});
        return foreing_value;
    }

    public ExpressionBuilder.Function current_row() {
        return this.expression().function("CURRENT_ROW", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function current_table() {
        return this.expression().function("CURRENT_STORE", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function isselected_current_row() {
        return this.expression().function("ISSELECTED_CURRENT_ROW", new ExpressionBuilder.Value[0]);
    }

    private class DefaultSelectCountBuilder
    implements DALExpressionBuilder.SelectCountBuilder {
        private String tableName;
        private ExpressionBuilder.Value where;

        public DALExpressionBuilder.SelectCountBuilder table(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DALExpressionBuilder.SelectCountBuilder where(ExpressionBuilder.Value where) {
            this.where = where;
            return this;
        }

        public ExpressionBuilder.Value toValue() {
            ExpressionBuilder.Function select = DefaultDALExpressionBuilder.this.expression().function("SELECT_COUNT", new ExpressionBuilder.Value[0]);
            select.parameter((ExpressionBuilder.Value)DefaultDALExpressionBuilder.this.expression().variable(this.tableName));
            if (this.where != null) {
                select.parameter(this.where);
            }
            return select;
        }

        public String toString() {
            return this.toValue().toString();
        }
    }
}

