/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.expressionbuilder.formatters;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;

public class Select
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;
    private static final int COLUMNS = 0;
    private static final int TABLE = 1;
    private static final int WHERE = 2;
    private static final int ORDER = 3;
    private static final int ORDER_MODE = 4;
    private static final int LIMIT = 5;

    public Select(Formatter<ExpressionBuilder.Value> formatter) {
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Function) {
            return StringUtils.equalsIgnoreCase((CharSequence)"SELECT", (CharSequence)((ExpressionBuilder.Function)value).name());
        }
        return false;
    }

    public String format(ExpressionBuilder.Value function0) {
        ExpressionBuilder.Function function = (ExpressionBuilder.Function)function0;
        String tableName = ((ExpressionBuilder.Value)function.parameters().get(1)).toString(this.formatter);
        ExpressionBuilder.Value where = (ExpressionBuilder.Value)function.parameters().get(2);
        ExpressionBuilder.Value order = (ExpressionBuilder.Value)function.parameters().get(3);
        ExpressionBuilder.Value limit = (ExpressionBuilder.Value)function.parameters().get(5);
        ExpressionBuilder.Value order_mode = (ExpressionBuilder.Value)function.parameters().get(4);
        StringBuilder builder = new StringBuilder();
        builder.append("(SELECT ");
        try {
            ExpressionBuilder.Value c = (ExpressionBuilder.Value)function.parameters().get(0);
            if (c instanceof ExpressionBuilder.Variable) {
                builder.append('\"');
                builder.append(((ExpressionBuilder.Variable)c).name());
                builder.append("\" ");
            } else {
                ExpressionBuilder.Function columns = (ExpressionBuilder.Function)c;
                if (!StringUtils.equalsIgnoreCase((CharSequence)columns.name(), (CharSequence)"TUPLE")) {
                    throw new IllegalArgumentException();
                }
                if (columns.parameters().isEmpty()) {
                    builder.append("* ");
                } else {
                    boolean needcomma = false;
                    for (ExpressionBuilder.Value parameter : columns.parameters()) {
                        if (needcomma) {
                            builder.append(", ");
                        } else {
                            needcomma = true;
                        }
                        builder.append(parameter.toString(this.formatter));
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid columns, need a tuple function as columns.");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        if (where != null) {
            builder.append(" WHERE ");
            builder.append(where.toString(this.formatter));
        }
        if (limit != null) {
            builder.append(" LIMIT ");
            builder.append(limit.toString(this.formatter));
        }
        builder.append(")");
        return builder.toString();
    }
}

