/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.List;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.dataaccess.AbstractFeatureFunction;
import org.gvsig.tools.util.UnmodifiableBasicCollection;
import org.gvsig.tools.util.UnmodifiableBasicCollection64;

public class ExistsFunction
extends AbstractFeatureFunction {
    public static final String NAME = "EXISTS";

    public ExistsFunction() {
        super("Data access", NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), "Receive a list as an argument. Returns true if the list has some value and false if the list is empty.", "EXISTS({{list}})", new String[]{"list - a list of values or null"}, "Boolean", true);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        Object list;
        Object id;
        if (args.size() == 2 && (id = this.getObject(interpreter, args, 1)) instanceof CharSequence && interpreter.getSymbolTable().exists(id.toString())) {
            Object value = interpreter.getSymbolTable().value(id.toString());
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return value;
            }
        }
        if ((list = this.getObject(interpreter, args, 0)) == null) {
            return false;
        }
        boolean isEmpty = true;
        if (list instanceof Object[]) {
            isEmpty = ((Object[])list).length == 0;
        } else if (list instanceof List) {
            isEmpty = ((List)list).isEmpty();
        } else if (list instanceof UnmodifiableBasicCollection) {
            isEmpty = ((UnmodifiableBasicCollection)list).isEmpty();
        } else if (list instanceof UnmodifiableBasicCollection64) {
            isEmpty = ((UnmodifiableBasicCollection64)list).isEmpty();
        } else {
            throw new ExpressionRuntimeException("Invalid argument. List or null expected.");
        }
        return !isEmpty;
    }
}

