/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.dataaccess.AbstractSelectFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;

public class SelectCountFunction
extends AbstractSelectFunction {
    private static final int TABLE = 0;
    private static final int WHERE = 1;

    public SelectCountFunction() {
        super("Data access", "SELECT_COUNT", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), "Returns the number of features of the table by applying the filter indicated.\nThe syntax is:\n\nSELECT COUNT(*) FROM table WHERE boolean_expression;\n\nIndicate a filter expression with WHERE is optional.\nThe SELECT statement must always end with a semicolon.", "SELECT COUNT(*) FROM {{table}} WHERE filter ;", new String[]{"table - Name of the table", "filter - boolean expression with the filter to apply"}, "Long", true);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object call(Interpreter interpreter, Codes args) throws Exception {
        Object query;
        String storeName = this.getIdentifier(args, 0);
        Code where = this.getWhereCode(args, 1);
        FeatureStore featureStore = null;
        FeatureSet set = null;
        try {
            featureStore = this.getFeatureStore(storeName);
            if (featureStore == null) {
                throw new ExpressionRuntimeException("Cant locate the feature store '" + storeName + "' in function '" + this.name() + "'.");
            }
            if (where == null) {
                set = featureStore.getFeatureSet();
            } else {
                query = featureStore.createFeatureQuery();
                Code where2 = this.removeOuterTablesReferences(interpreter, where, featureStore.getDefaultFeatureTypeQuietly());
                DefaultFeatureExpressionEvaluator filter = new DefaultFeatureExpressionEvaluator(featureStore.getName(), where2.toString());
                filter.toSymbolTable().addSymbolTable(interpreter.getSymbolTable());
                query.addFilter((Evaluator)filter);
                query.retrievesAllAttributes();
                set = featureStore.getFeatureSet(query);
            }
            query = set.getSize();
        }
        catch (ExpressionRuntimeException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new ExpressionRuntimeException("Problems calling '" + this.name() + "' function", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(set);
                DisposeUtils.disposeQuietly((Disposable)featureStore);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)set);
        DisposeUtils.disposeQuietly((Disposable)featureStore);
        return query;
    }

    public ExpressionBuilder.Value toValue(ExpressionBuilder builder, Codes args) {
        try {
            SQLBuilder sqlBuilder = (SQLBuilder)builder.getProperty("SQLBUILDER");
            if (sqlBuilder == null) {
                return super.toValue(builder, args);
            }
            FeatureType featureType = null;
            SQLBuilder.SelectBuilder select = sqlBuilder.createSelectBuilder();
            String builderTableName = (String)builder.getProperty("TableName");
            Code tableCode = (Code)args.get(0);
            Code where = this.getWhereCode(args, 1);
            if (tableCode != null) {
                if (this.isHostExpression(tableCode)) {
                    select.from().custom(tableCode.toString());
                } else {
                    String tableName = this.getIdentifier(args, 0);
                    select.from().table().name(tableName);
                }
            }
            SQLBuilder.TableNameBuilder table = select.from().table();
            String tableName = table.getName();
            select.column().value((ExpressionBuilder.Value)builder.function("COUNT", new ExpressionBuilder.Value[]{builder.custom((Object)"*")}));
            if (where != null) {
                ExpressionBuilder.Value value = where.toValue(builder);
                select.where().value(value);
                sqlBuilder.setProperties((ExpressionBuilder.Visitable)value, null, new Object[]{"ADD_TABLE_NAME", true});
            }
            if (featureType == null) {
                if (StringUtils.equalsIgnoreCase((CharSequence)builderTableName, (CharSequence)tableName)) {
                    featureType = (FeatureType)builder.getProperty("FeatureType");
                } else {
                    DataManager dataManager = DALLocator.getDataManager();
                    featureType = dataManager.getStoresRepository().getFeatureType(tableName);
                }
            }
            sqlBuilder.setProperties((ExpressionBuilder.Visitable)select, null, new Object[]{"FeatureType", featureType, "Table", table});
            return builder.group((ExpressionBuilder.Value)select);
        }
        catch (Exception ex) {
            return super.toValue(builder, args);
        }
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        SQLBuilderBase sqlbuilder = new SQLBuilderBase();
        ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        ExpressionBuilder expressionBuilder = expressionManager.createExpressionBuilder();
        expressionBuilder.setProperty("SQLBUILDER", (Object)sqlbuilder);
        ExpressionBuilder.Value values = this.toValue(expressionBuilder, args);
        return values.toString();
    }
}

