/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.function.dataaccess.AbstractSelectFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureQueryOrder;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.util.FilteredIterator;
import org.gvsig.tools.util.LimitIterator;

public class SelectFunction
extends AbstractSelectFunction
implements Optimizer.FunctionOptimizer {
    public static final int MODE_FROM_STORE = 0;
    public static final int MODE_FROM_SELECTION = 1;
    public static final int MODE_FROM_SELECTION_IF_NOT_EMPTY = 2;
    public static final String PROP_FEATURETYPESUPPLIER = "FEATURETYPESUPPLIER";
    private static final int COLUMNS = 0;
    private static final int TABLE = 1;
    private static final int WHERE = 2;
    private static final int ORDER = 3;
    private static final int ORDER_MODE = 4;
    private static final int LIMIT = 5;
    private static final int INTOVAR = 6;
    private static final int MODE_FROM = 7;

    public SelectFunction() {
        super("Data access", "SELECT", Range.between((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)), "Returns a list of features of the table by applying the filter, order and limit indicated.\nThe syntax is:\n\nSELECT * FROM table WHERE boolean_expression ORDER BY order_column LIMIT limit;\n\nIndicate a filter expression with WHERE, an order or LIMIT is optional.\nYou can use an asterisk or enter the column names you want to retrieve separated by commas.\nThe SELECT statement must always end with a semicolon.", "SELECT * FROM table WHERE boolean_expression ORDER BY order_column LIMIT limit;", new String[]{"column_names/asterisk - Names of the columns table to retrieve.", "table_name - Name of the table", "filter - boolean expression to apply as filter", "order_column - the order used to retrieve the features. It is a list of column names separated by a comma. The column name can optionally be followed by ASC or DESC to indicate whether the order should be ascending or descending.", "limit - Maximum number of features to return"}, "List", true);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Code.Callable getColumnsCode(Codes args) {
        Code code = (Code)args.get(0);
        if (code == null) {
            return null;
        }
        switch (code.code()) {
            case 0: {
                if (((Code.Constant)code).value() != null) {
                    throw new ExpressionRuntimeException("Null expected in argument COLUMNS of function '" + this.name() + "'.");
                }
                return null;
            }
            case 1: {
                CodeBuilder builder = ExpressionUtils.createCodeBuilder();
                return builder.block(new Code[]{code});
            }
            case 2: {
                Code.Callable callable = (Code.Callable)code;
                if (callable.parameters().isEmpty()) {
                    return null;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)callable.name(), (CharSequence)"BLOCK")) {
                    return callable;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)callable.name(), (CharSequence)"TUPLE")) {
                    return callable;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)callable.name(), (CharSequence)"GETATTR")) {
                    CodeBuilder builder = ExpressionUtils.createCodeBuilder();
                    return builder.block(new Code[]{code});
                }
                throw new ExpressionRuntimeException("BLOCK, TUPLE expected in argument COLUMNS of function '" + this.name() + "'.");
            }
        }
        throw new ExpressionRuntimeException("BLOCK or NULL expected in argument COLUMNS of function '" + this.name() + "'.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        String storeName = this.getIdentifier(args, 1);
        Code.Callable columns = this.getColumnsCode(args);
        Code where = this.getWhereCode(args, 2);
        Number limit = (Number)this.getObject(interpreter, args, 5);
        int mode_from = 0;
        if (args.size() > 7) {
            mode_from = this.getInt(interpreter, args, 7);
        }
        Code.Callable order = this.getTupleOrNull(args, 3);
        Code.Callable order_mode = this.getTupleOrNull(args, 4);
        DefaultFeatureQueryOrder queryOrder = null;
        try {
            FeatureStore featureStore = this.getFeatureStore(storeName);
            if (featureStore == null) {
                throw new ExpressionRuntimeException("Cant locate the feature store '" + storeName + "' in function '" + this.name() + "'.");
            }
            FeatureType featureType = featureStore.getDefaultFeatureTypeQuietly();
            if (order != null && order_mode != null) {
                for (int n = 0; n < order.parameters().size(); ++n) {
                    if (queryOrder == null) {
                        queryOrder = new DefaultFeatureQueryOrder();
                    }
                    Boolean mode = (Boolean)((Code.Constant)order_mode.parameters().get(n)).value();
                    Code memberCode = (Code)order.parameters().get(n);
                    if (memberCode.code() == 1) {
                        queryOrder.add(((Code.Identifier)memberCode).name(), mode);
                        continue;
                    }
                    Iterator memberCode2 = this.replaceLocalVariables(interpreter, memberCode, featureType);
                    Expression exp = ExpressionUtils.createExpression((String)memberCode2.toString());
                    queryOrder.add(exp, mode);
                }
            }
            String intovar = null;
            if (args.size() > 6) {
                intovar = this.getIdentifier(args, 6);
            }
            FeatureQuery query = featureStore.createFeatureQuery();
            if (columns == null) {
                query.retrievesAllAttributes();
            } else {
                String pkname;
                int n = 1;
                for (Code column : columns.parameters()) {
                    if (column instanceof Code.Identifier) {
                        query.addAttributeName(((Code.Identifier)column).name());
                    } else {
                        Code exp;
                        String name = "exp" + n;
                        if (column instanceof Code.Callable && StringUtils.equals((CharSequence)((Code.Callable)column).name(), (CharSequence)"LET")) {
                            Code.Callable letfn = (Code.Callable)column;
                            name = Objects.toString(((Code.Constant)letfn.parameters().get(0)).value(), name);
                            exp = (Code)letfn.parameters().get(1);
                        } else {
                            exp = column;
                        }
                        query.addExtraColumn(name, 8, ExpressionUtils.createExpression((String)exp.toString()));
                    }
                    ++n;
                }
                Object[] pk = featureType.getPrimaryKey();
                if (!ArrayUtils.isEmpty((Object[])pk) && !query.hasAttributeName(pkname = pk[0].getName())) {
                    query.addAttributeName(pkname);
                }
            }
            if (where != null) {
                Code where2 = where;
                try {
                    ExpressionBuilder.Value x = ExpressionUtils.resolveHostExpressions((ExpressionBuilder.Value)where2.toValue(), (SymbolTable)interpreter.getSymbolTable());
                    where2 = ExpressionUtils.compile((String)x.toString());
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't resolve hosts expressions", (Throwable)ex);
                }
                where2 = this.removeOuterTablesReferences(interpreter, where2, featureType);
                DefaultFeatureExpressionEvaluator filter = new DefaultFeatureExpressionEvaluator(featureStore.getName(), where2.toString());
                filter.toSymbolTable().addSymbolTable(interpreter.getSymbolTable());
                query.addFilter((Evaluator)filter);
                if (columns == null) {
                    query.retrievesAllAttributes();
                }
            }
            if (queryOrder != null) {
                query.getOrder().copyFrom((FeatureQueryOrder)queryOrder);
            }
            if (limit != null) {
                query.setLimit(limit.longValue());
            }
            switch (mode_from) {
                case 1: {
                    return this.select_from_selection(interpreter, featureStore, query, intovar);
                }
                case 2: {
                    return this.select_from_selection_if_not_empty(interpreter, featureStore, query, intovar);
                }
            }
            return this.select_from_store(interpreter, featureStore, query, intovar);
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Problems calling '" + this.name() + "' function", (Throwable)ex);
        }
    }

    protected Object select_from_selection(Interpreter interpreter, FeatureStore store, FeatureQuery query, String intovar) {
        try {
            FeatureSelection baseSelection;
            if (store.isFeatureSelectionEmpty()) {
                return null;
            }
            Object features = store.getFeatureSelection();
            if (query.hasFilter()) {
                baseSelection = features;
                DefaultFeatureExpressionEvaluator evaluator = new DefaultFeatureExpressionEvaluator(store.getName(), query.getExpressionFilter().toString());
                evaluator.toSymbolTable().addSymbolTable(interpreter.getSymbolTable());
                Predicate<Object> filter = t -> {
                    try {
                        return (Boolean)evaluator.evaluate((EvaluatorData)t);
                    }
                    catch (EvaluatorException ex1) {
                        throw new ExpressionRuntimeException("Can't evaluate expression for row.", (Throwable)ex1);
                    }
                };
                features = () -> SelectFunction.lambda$select_from_selection$1((Iterable)baseSelection, filter);
            }
            if (query.hasLimit()) {
                baseSelection = features;
                features = () -> SelectFunction.lambda$select_from_selection$2((Iterable)baseSelection, query);
            }
            if (intovar != null) {
                Feature f = null;
                Iterator it = features.iterator();
                if (it.hasNext()) {
                    f = (Feature)it.next();
                }
                DisposeUtils.dispose(it);
                DisposeUtils.dispose((Object)features);
                ((MutableSymbolTable)interpreter.getSymbolTable()).setVar(intovar, (Object)f);
                return f;
            }
            return features;
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Problems calling '" + this.name() + "' function", (Throwable)ex);
        }
    }

    protected Object select_from_store(Interpreter interpreter, FeatureStore store, FeatureQuery query, String intovar) throws Exception {
        if (intovar != null) {
            Feature f = store.findFirst(query);
            ((MutableSymbolTable)interpreter.getSymbolTable()).setVar(intovar, (Object)f);
            return f;
        }
        List features = store.getFeatures(query);
        return features;
    }

    protected Object select_from_selection_if_not_empty(Interpreter interpreter, FeatureStore store, FeatureQuery query, String intovar) throws Exception {
        if (store.isFeatureSelectionEmpty()) {
            return this.select_from_store(interpreter, store, query, intovar);
        }
        return this.select_from_selection(interpreter, store, query, intovar);
    }

    public Code optimize(Optimizer optimizer, Code.Callable caller) {
        return caller;
    }

    public ExpressionBuilder.Value toValue(ExpressionBuilder builder, Codes args) {
        try {
            Object value;
            SQLBuilder.TableNameBuilder table;
            SQLBuilder sqlBuilder = (SQLBuilder)builder.getProperty("SQLBUILDER");
            if (sqlBuilder == null) {
                return super.toValue(builder, args);
            }
            SQLBuilder.TableNameBuilder builderTable = sqlBuilder.select().from().table();
            SQLBuilder.SelectBuilder select = sqlBuilder.createSelectBuilder();
            String builderTableName = (String)builder.getProperty("TableName");
            Code tableCode = (Code)args.get(1);
            Code.Callable columns = this.getColumnsCode(args);
            Code where = this.getWhereCode(args, 2);
            Code.Callable order = this.getTupleOrNull(args, 3);
            Code.Callable order_mode = this.getTupleOrNull(args, 4);
            Code limit = (Code)args.get(5);
            int mode_from = 0;
            if (args.size() > 7) {
                Code codeModeFrom = (Code)args.get(7);
                mode_from = (Integer)((Code.Constant)codeModeFrom).value();
            }
            String intovar = null;
            if (args.size() > 6 && args.get(6) != null) {
                intovar = this.getIdentifier(args, 6);
            }
            if (tableCode != null) {
                String tableName = null;
                String tableNameHE = null;
                if (this.isHostExpression(tableCode)) {
                    tableNameHE = tableCode.toString();
                } else {
                    tableName = this.getIdentifier(args, 1);
                }
                switch (mode_from) {
                    case 1: {
                        SQLBuilder.FromBuilder from = select.from();
                        if (tableNameHE == null) {
                            select.from().custom("SELECTION OF " + from.table().name(tableName).toString());
                            break;
                        }
                        select.from().custom("SELECTION OF " + tableNameHE);
                        break;
                    }
                    case 2: {
                        SQLBuilder.FromBuilder from = select.from();
                        if (tableNameHE == null) {
                            select.from().custom("SELECTION IF NOT EMPTY OF " + from.table().name(tableName).toString());
                            break;
                        }
                        select.from().custom("SELECTION IF NOT EMPTY OF " + tableNameHE);
                        break;
                    }
                    case 0: {
                        if (tableNameHE == null) {
                            select.from().table().name(tableName);
                            break;
                        }
                        select.from().custom(tableNameHE);
                    }
                }
            }
            if (!(table = select.from().table()).has_schema() && builderTable.has_schema()) {
                table.schema(builderTable.getSchema());
            }
            String tableName = table.getName();
            FeatureType featureType = null;
            if (StringUtils.equalsIgnoreCase((CharSequence)builderTableName, (CharSequence)tableName)) {
                featureType = (FeatureType)builder.getProperty("FeatureType");
            }
            if (featureType == null) {
                DataManager dataManager = DALLocator.getDataManager();
                featureType = dataManager.getStoresRepository().getFeatureType(tableName);
            }
            table.setFeatureType(featureType);
            if (columns == null || columns.parameters().isEmpty()) {
                if (intovar == null) {
                    select.column().all();
                } else {
                    select.column().value((ExpressionBuilder.Value)builder.custom((Object)("* INTO " + intovar)));
                }
            } else {
                for (Code column : columns.parameters()) {
                    if (column == null) {
                        select.column().value((ExpressionBuilder.Value)builder.constant(null));
                        continue;
                    }
                    if (column instanceof Code.Identifier) {
                        String columnName = ((Code.Identifier)column).name();
                        if (table.featureType() == null || table.featureType().get(columnName) != null) {
                            select.column().name(table, columnName);
                            continue;
                        }
                        select.column().name(null, columnName);
                        continue;
                    }
                    select.column().value(this.setTableName(table, column.toValue(builder)));
                }
            }
            if (where != null) {
                value = this.setTableName(table, where.toValue(builder));
                select.where().value((ExpressionBuilder.Value)value);
                sqlBuilder.setProperties((ExpressionBuilder.Visitable)value, null, new Object[]{"ADD_TABLE_NAME", true});
            }
            if (limit != null && (value = ((Code.Constant)limit).value()) != null) {
                select.limit(((Number)value).longValue());
            }
            if (order != null && order_mode != null) {
                for (int n = 0; n < order.parameters().size(); ++n) {
                    Code member = (Code)order.parameters().get(n);
                    Code.Constant mode = (Code.Constant)order_mode.parameters().get(n);
                    select.order_by().value(this.setTableName(table, member.toValue(builder))).ascending(((Boolean)mode.value()).booleanValue());
                }
            }
            sqlBuilder.setProperties((ExpressionBuilder.Visitable)select, null, new Object[]{"FeatureType", featureType, "Table", table});
            return builder.group((ExpressionBuilder.Value)select);
        }
        catch (Exception ex) {
            return super.toValue(builder, args);
        }
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        SQLBuilderBase sqlbuilder = new SQLBuilderBase();
        ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        ExpressionBuilder expressionBuilder = expressionManager.createExpressionBuilder();
        expressionBuilder.setProperty("SQLBUILDER", (Object)sqlbuilder);
        expressionBuilder.setProperty(PROP_FEATURETYPESUPPLIER, (Object)new Function<String, FeatureType>(){

            @Override
            public FeatureType apply(String t) {
                return null;
            }
        });
        ExpressionBuilder.Value values = this.toValue(expressionBuilder, args);
        return values.toString();
    }

    protected ExpressionBuilder.Value setTableName(final SQLBuilder.TableNameBuilder table, ExpressionBuilder.Value value) {
        value.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable value) {
                if (value instanceof SQLBuilder.Column) {
                    SQLBuilder.Column c = (SQLBuilder.Column)value;
                    SQLBuilder.TableNameBuilder t = c.table();
                    if (t == null) {
                        if (table.featureType() == null || table.featureType().get(c.name()) != null) {
                            c.table(table);
                        }
                        return;
                    }
                    if (t.equals(table)) {
                        t.setFeatureType(table.featureType());
                    }
                }
            }
        }, null);
        return value;
    }

    private static /* synthetic */ Iterator lambda$select_from_selection$2(Iterable baseSelection, FeatureQuery query) {
        return new LimitIterator(baseSelection.iterator(), query.getLimit());
    }

    private static /* synthetic */ Iterator lambda$select_from_selection$1(Iterable baseSelection, Predicate filter) {
        return new FilteredIterator(baseSelection.iterator(), filter);
    }
}

