/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.impl.DefaultDataManager;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultFeatureExtraColumns
implements FeatureExtraColumns {
    private List<EditableFeatureAttributeDescriptor> extraColumns = new ArrayList<EditableFeatureAttributeDescriptor>();

    public boolean isEmpty() {
        return this.extraColumns.isEmpty();
    }

    public EditableFeatureAttributeDescriptor get(String columnName) {
        for (EditableFeatureAttributeDescriptor extraColumn : this.extraColumns) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)extraColumn.getName(), (CharSequence)columnName)) continue;
            return extraColumn;
        }
        return null;
    }

    public EditableFeatureAttributeDescriptor add(String name, int type) {
        DefaultEditableFeatureAttributeDescriptor newAttr = DefaultDataManager.createEditableFeatureAttributeDescriptor(null, name, type);
        this.extraColumns.add(newAttr);
        return newAttr;
    }

    public List<EditableFeatureAttributeDescriptor> getColumns() {
        return this.extraColumns;
    }

    public void merge(FeatureExtraColumns other) {
        this.extraColumns.addAll(other.getColumns());
    }

    public int getIndexOf(String name) {
        for (int i = 0; i < this.extraColumns.size(); ++i) {
            EditableFeatureAttributeDescriptor extraColumn = this.extraColumns.get(i);
            if (!StringUtils.equalsIgnoreCase((CharSequence)extraColumn.getName(), (CharSequence)name)) continue;
            return i;
        }
        return -1;
    }

    public EditableFeatureAttributeDescriptor get(int index) {
        return this.extraColumns.get(index);
    }

    public int size() {
        return this.extraColumns.size();
    }

    public void copyFrom(FeatureExtraColumns extraColumn) {
        this.extraColumns.clear();
        for (EditableFeatureAttributeDescriptor col : extraColumn.getColumns()) {
            this.extraColumns.add(col);
        }
    }

    public void clear() {
        this.extraColumns.clear();
    }

    public FeatureExtraColumns getCopy() {
        DefaultFeatureExtraColumns other = new DefaultFeatureExtraColumns();
        ArrayList<EditableFeatureAttributeDescriptor> otherCols = new ArrayList<EditableFeatureAttributeDescriptor>();
        for (EditableFeatureAttributeDescriptor extraColumn : this.extraColumns) {
            DefaultEditableFeatureAttributeDescriptor newAttr = DefaultDataManager.createEditableFeatureAttributeDescriptor(null, extraColumn.getName(), extraColumn.getType());
            newAttr.copyFrom((DynField)extraColumn);
            otherCols.add(newAttr);
        }
        other.extraColumns = otherCols;
        return other;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("extraColumns", this.extraColumns);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List extraColumnsDescriptors = state.getList("extraColumns");
        ArrayList<EditableFeatureAttributeDescriptor> cols = new ArrayList<EditableFeatureAttributeDescriptor>();
        for (DefaultFeatureAttributeDescriptor extraColumnsDescriptor : extraColumnsDescriptors) {
            DefaultEditableFeatureAttributeDescriptor myEditableDescriptor = new DefaultEditableFeatureAttributeDescriptor(extraColumnsDescriptor);
            cols.add(myEditableDescriptor);
        }
        this.extraColumns = cols;
    }

    public static void registerPersistent() {
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureExtraColumns.class, "DefaultFeatureExtraColumn", "DefaultFeatureExtraColumn Persistent definition", null, null);
        definition.addDynFieldArray("extraColumns").setClassOfItems(FeatureAttributeDescriptor.class).setMandatory(false);
    }

    public void remove(String attribute) {
        Iterator<EditableFeatureAttributeDescriptor> iterator = this.extraColumns.iterator();
        while (iterator.hasNext()) {
            EditableFeatureAttributeDescriptor extraColumn = iterator.next();
            if (!extraColumn.getName().equalsIgnoreCase(attribute)) continue;
            iterator.remove();
            break;
        }
    }

    public void fromJson(JsonObject json) {
        this.clear();
        if (json.containsKey((Object)"extraColumns")) {
            for (JsonValue jsonValue : json.getJsonArray("extraColumns")) {
                JsonObject value = (JsonObject)jsonValue;
                DefaultEditableFeatureAttributeDescriptor newAttr = new DefaultEditableFeatureAttributeDescriptor(null, false);
                newAttr.fromJson(value);
                this.extraColumns.add(newAttr);
            }
        }
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("extraColumns", (JsonArrayBuilder)Json.createArrayBuilder().addAll(this.extraColumns));
        return builder;
    }

    public Iterator<EditableFeatureAttributeDescriptor> iterator() {
        return this.extraColumns.iterator();
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultFeatureExtraColumns.class;
        }

        public Object toObject(JsonObject json) {
            DefaultFeatureExtraColumns o = new DefaultFeatureExtraColumns();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }
}

