/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.indexes.jsir;

import com.infomatiq.jsi.IntProcedure;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.index.AbstractFeatureIndexProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;

public class JSIRSpatialIndexProvider
extends AbstractFeatureIndexProvider {
    private RTree rtree = null;

    public void initialize() {
        try {
            this.rtree = this.createRTree();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private RTree createRTree() {
        RTree theRtree = new RTree();
        Properties props = new Properties();
        theRtree.init(props);
        return theRtree;
    }

    public void insert(Object value, FeatureReferenceProviderServices fref) {
        Envelope env = this.getEnvelope(value);
        if (env == null) {
            throw new IllegalArgumentException("value is neither Geometry or Envelope");
        }
        Object oid = fref.getOID();
        if (!this.isCompatibleOID(oid)) {
            throw new IllegalArgumentException("OID type not compatible: " + oid.getClass().getName());
        }
        this.rtree.add(this.toJsiRect(env), ((Number)oid).intValue());
    }

    public void delete(Object value, FeatureReferenceProviderServices fref) {
        Envelope env = this.getEnvelope(value);
        if (env == null) {
            throw new IllegalArgumentException("value is neither Geometry or Envelope");
        }
        Object oid = fref.getOID();
        if (!this.isCompatibleOID(oid)) {
            throw new IllegalArgumentException("OID type not compatible: " + oid.getClass().getName());
        }
        this.rtree.delete(this.toJsiRect(env), ((Number)oid).intValue());
    }

    public List match(Object value) throws FeatureIndexException {
        Envelope env = this.getEnvelope(value);
        if (env == null) {
            throw new IllegalArgumentException("value is neither Geometry or Envelope");
        }
        ListIntProcedure solution = new ListIntProcedure();
        this.rtree.intersects(this.toJsiRect(env), (IntProcedure)solution);
        return new AbstractFeatureIndexProvider.LongList((AbstractFeatureIndexProvider)this, solution.getSolution());
    }

    public List match(Object min, Object max) {
        throw new UnsupportedOperationException("Can't perform this kind of search.");
    }

    public List nearest(int count, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (value instanceof Point) {
            Point p = (Point)value;
            com.infomatiq.jsi.Point jsiPoint = new com.infomatiq.jsi.Point((float)p.getDirectPosition().getOrdinate(0), (float)p.getDirectPosition().getOrdinate(1));
            return (List)this.rtree.nearest(jsiPoint, count);
        }
        Envelope env = this.getEnvelope(value);
        if (env == null) {
            throw new IllegalArgumentException("value is neither Geometry or Envelope");
        }
        return new AbstractFeatureIndexProvider.LongList((AbstractFeatureIndexProvider)this, (List)this.rtree.nearest(this.toJsiRect(env), count));
    }

    public boolean isMatchSupported() {
        return true;
    }

    public boolean isNearestSupported() {
        return true;
    }

    public boolean isNearestToleranceSupported() {
        return false;
    }

    public boolean isRangeSupported() {
        return false;
    }

    public List nearest(int count, Object value, Object tolerance) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public List range(Object value1, Object value2) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    private boolean isCompatibleOID(Object oid) {
        if (!(oid instanceof Number)) {
            return false;
        }
        long num = ((Number)oid).longValue();
        return num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE;
    }

    protected Envelope getEnvelope(Object value) {
        Envelope env = null;
        if (value instanceof Envelope) {
            env = (Envelope)value;
        } else if (value instanceof Geometry) {
            env = ((Geometry)value).getEnvelope();
        }
        return env;
    }

    protected Rectangle toJsiRect(Envelope env) {
        Point min = env.getLowerCorner();
        Point max = env.getUpperCorner();
        Rectangle jsiRect = new Rectangle((float)min.getX(), (float)min.getY(), (float)max.getX(), (float)max.getY());
        return jsiRect;
    }

    public void clear() throws DataException {
        this.rtree = this.createRTree();
    }

    class ListIntProcedure
    implements IntProcedure {
        List solution = new ArrayList();

        ListIntProcedure() {
        }

        public boolean execute(int arg0) {
            this.solution.add(arg0);
            return true;
        }

        public List getSolution() {
            return this.solution;
        }
    }
}

