/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.indexes.memorybasictypes;

import java.util.List;
import java.util.TreeMap;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.impl.indexes.memorybasictypes.ArrayListOfLong;
import org.gvsig.fmap.dal.feature.impl.indexes.memorybasictypes.ListOfLong;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.index.AbstractFeatureIndexProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;

public class MemoryBasicTypesIndexProvider<T>
extends AbstractFeatureIndexProvider {
    private TreeMap<T, ListOfLong> index = null;
    private final Class<T> classt;
    private final Coercion coercion;

    public MemoryBasicTypesIndexProvider(Class<T> classt) {
        this.classt = classt;
        this.coercion = ToolsLocator.getDataTypesManager().getDataType(classt).getCoercion();
    }

    public void initialize() {
        try {
            this.index = new TreeMap();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void delete(Object key_o, FeatureReferenceProviderServices fref) {
        Object key_s = key_o;
        long oid = (Long)fref.getOID();
        ListOfLong items = this.index.get(key_s);
        if (items == null) {
            return;
        }
        items.remove(oid);
        if (items.isEmpty()) {
            this.index.remove(key_s);
        }
    }

    public void insert(Object key_o, FeatureReferenceProviderServices fref) {
        if (key_o == null) {
            return;
        }
        Object key_s = key_o;
        long oid = (Long)fref.getOID();
        ListOfLong items = this.index.get(key_s);
        if (items == null) {
            items = new ArrayListOfLong();
            this.index.put(key_s, items);
        }
        items.add(oid);
    }

    public List match(Object key_o) throws FeatureIndexException {
        Object key_s;
        try {
            key_s = this.coercion.coerce(key_o);
        }
        catch (CoercionException ex) {
            return null;
        }
        if (key_s == null || !this.index.containsKey(key_s)) {
            return null;
        }
        ListOfLong items = this.index.get(key_s);
        if (items == null) {
            return null;
        }
        return items;
    }

    public List match(Object min, Object max) {
        throw new UnsupportedOperationException("Can't perform this kind of search.");
    }

    public List nearest(int count, Object value) throws FeatureIndexException {
        throw new UnsupportedOperationException("Can't perform this kind of search.");
    }

    public boolean isMatchSupported() {
        return true;
    }

    public boolean isNearestSupported() {
        return false;
    }

    public boolean isNearestToleranceSupported() {
        return false;
    }

    public boolean isRangeSupported() {
        return false;
    }

    public List nearest(int count, Object value, Object tolerance) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public List range(Object value1, Object value2) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public void clear() throws DataException {
        this.index.clear();
    }
}

