/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.undo.command;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureManager;
import org.gvsig.fmap.dal.feature.impl.undo.command.AbstractFeatureCommand;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.UndoRedoInfo;

public class FeatureDeleteCommand
extends AbstractFeatureCommand {
    public FeatureDeleteCommand(DefaultFeatureStore featureStore, Feature feature, String description) {
        super(featureStore, feature, description);
    }

    public void undo() throws UndoException {
        try {
            FeatureManager featureManager = this.featureStore.getFeatureManager();
            featureManager.restore(this.feature.getReference());
        }
        catch (Exception e) {
            throw new UndoException((UndoRedoInfo)this, (Throwable)e);
        }
    }

    @Override
    public void redo() throws RedoException {
        try {
            this.featureStore.doDelete(this.feature);
        }
        catch (Exception e) {
            throw new RedoException((UndoRedoInfo)this, (Throwable)e);
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void execute() throws DataException {
        this.featureStore.doDelete(this.feature);
    }
}

