/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.paging.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.impl.UnsupportedCreationOfFeatureSetWithChangesException;
import org.gvsig.fmap.dal.feature.impl.dynobjectutils.DynObjectFeatureFacade;
import org.gvsig.fmap.dal.feature.paging.FacadeOfAFeaturePagingHelper;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.feature.paging.impl.FeatureSetSizeableDelegate;
import org.gvsig.fmap.dal.feature.paging.impl.OneSubsetOneSetPagingCalculator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.impl.DefaultDynObjectPagingHelper;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.paging.PagingCalculator;
import org.gvsig.tools.util.UnmodifiableBasicList;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturePagingHelperImpl
extends DefaultDynObjectPagingHelper
implements FeaturePagingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FeaturePagingHelperImpl.class);
    private FeatureQuery query;
    private FeatureStore featureStore;
    private boolean selectionUp = false;
    private FeatureSet featSet = null;
    private Feature[] features = null;
    private PageCache cachedPages = new PageCache(3);
    private boolean initialization_completed = false;
    private FeatureSelection selection = null;
    private long lastSize = 0L;

    public FeaturePagingHelperImpl(FeatureStore featureStore) throws BaseException {
        this(featureStore, 100);
    }

    public FeaturePagingHelperImpl(FeatureStore featureStore, int pageSize) throws BaseException {
        this(featureStore, null, pageSize);
    }

    public FeaturePagingHelperImpl(FeatureStore featureStore, FeatureQuery featureQuery) throws BaseException {
        this(featureStore, featureQuery, 100);
    }

    public FeaturePagingHelperImpl(FeatureStore featureStore, FeatureQuery featureQuery, int pageSize) throws BaseException {
        FeatureQuery theQuery = featureQuery;
        if (featureQuery == null) {
            theQuery = featureStore.createFeatureQuery();
            theQuery.setFeatureType(featureStore.getDefaultFeatureType());
        }
        this.featureStore = featureStore;
        DisposeUtils.bind((Disposable)this.featureStore);
        this.query = theQuery;
        this.query.setPageSize((long)pageSize);
        this.setDefaultCalculator(() -> {
            FeatureSet featureSet = null;
            try {
                featureSet = this.getFeatureSet(false);
                this.lastSize = featureSet.getSize();
                return this.lastSize;
            }
            catch (UnsupportedCreationOfFeatureSetWithChangesException ex) {
                LOG.warn("Can't calculate size. " + ex.getLocalizedMessage());
                return this.lastSize;
            }
            catch (BaseException e) {
                LOG.warn("Error getting the size of the FeatureSet: " + featureSet, (Throwable)e);
                return 0L;
            }
        }, pageSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug("FeaturePagingHelperImpl created with {} pages, and a page size of {}", (Object)this.getCalculator().getNumPages(), (Object)pageSize);
        }
        this.initialization_completed = true;
    }

    public boolean isSelectionUp() {
        return this.selectionUp;
    }

    public FeatureSelection getSelection() {
        if (this.selection == null) {
            try {
                return this.getFeatureStore().getFeatureSelection();
            }
            catch (Exception e) {
                LOG.warn("Error getting the selection", (Throwable)e);
            }
        }
        return this.selection;
    }

    public void setSelection(FeatureSelection selection) {
        DisposeUtils.disposeQuietly((Disposable)this.selection);
        this.selection = selection;
        DisposeUtils.bind((Disposable)this.selection);
    }

    public void setSelectionUp(boolean selectionUp) {
        this.selectionUp = selectionUp;
        try {
            this.cachedPages.clear();
            FeatureSelection currentSelection = this.getSelection();
            if (selectionUp && !currentSelection.isEmpty()) {
                this.setCalculator((PagingCalculator)new OneSubsetOneSetPagingCalculator(new FeatureSetSizeableDelegate((FeatureSet)currentSelection), new FeatureSetSizeableDelegate(this.getFeatureSet(false)), this.getMaxPageSize()));
            } else {
                this.setDefaultCalculator(new FeatureSetSizeableDelegate(this.getFeatureSet(false)), this.getMaxPageSize());
            }
        }
        catch (BaseException e) {
            LOG.warn("Error setting the selection up setting to: " + selectionUp, (Throwable)e);
        }
    }

    public synchronized Feature getFeatureAt(long index) throws BaseException {
        int size;
        long positionForIndex;
        long currentPage;
        int maxPageSize = this.getMaxPageSize();
        long currentPage2 = currentPage = this.getCurrentPage();
        long pageForIndex = (long)Math.floor(index / (long)maxPageSize);
        if (pageForIndex != currentPage) {
            this.setCurrentPage(pageForIndex);
            currentPage2 = this.getCurrentPage();
        }
        if ((positionForIndex = index - currentPage2 * (long)maxPageSize) >= (long)(size = this.getCurrentPageFeatures().length)) {
            throw new FeatureIndexException((Exception)new IndexOutOfBoundsException("Index: " + index + ", Size: " + size));
        }
        Feature feature = this.getCurrentPageFeatures()[(int)positionForIndex];
        return feature;
    }

    public Feature[] getCurrentPageFeatures() {
        if (this.features == null) {
            try {
                this.loadCurrentPageData();
            }
            catch (BaseException baseException) {
                // empty catch block
            }
            if (this.features == null) {
                String msg = "Can't retrieve the features from current page.";
                LOG.warn(msg);
                throw new RuntimeException(msg);
            }
        }
        return this.features;
    }

    public FeatureSet getFeatureSet() {
        return this.getFeatureSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureSet getFeatureSet(boolean reset) {
        if (this.featSet == null || reset) {
            if (this.featSet != null) {
                try {
                    this.featSet.dispose();
                    this.featSet = null;
                }
                catch (Exception ex) {
                    LOG.info("Error while disposing featset.", (Throwable)ex);
                }
            }
            try {
                FeatureStore featureStore;
                FeatureStore featureStore2 = featureStore = this.getFeatureStore();
                synchronized (featureStore2) {
                    this.featSet = featureStore.getFeatureSet(this.getFeatureQuery());
                }
            }
            catch (DataException e) {
                throw new RuntimeException("Error getting a feature set with the query " + this.getFeatureQuery(), e);
            }
        }
        return this.featSet;
    }

    public DynObjectSet getDynObjectSet() {
        return this.getFeatureSet(false).getDynObjectSet();
    }

    public void reloadCurrentPage() throws BaseException {
        boolean sel_up = this.isSelectionUp();
        try {
            this.setSelectionUp(false);
            if (this.getCalculator().getCurrentPage() > -1L) {
                this.cachedPages.clear();
                this.loadCurrentPageData();
            }
        }
        finally {
            if (sel_up) {
                this.setSelectionUp(true);
            }
        }
    }

    public void reload() throws BaseException {
        this.cachedPages.clear();
        this.getFeatureSet(true);
        this.setDefaultCalculator(() -> {
            FeatureSet featureSet = this.getFeatureSet(false);
            try {
                return featureSet.getSize();
            }
            catch (BaseException e) {
                LOG.warn("Error getting the size of the FeatureSet: " + featureSet, (Throwable)e);
                return 0L;
            }
        }, this.getCalculator().getMaxPageSize());
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public FeatureQuery getFeatureQuery() {
        return this.query;
    }

    protected synchronized void loadCurrentPageData() throws BaseException {
        if (!this.initialization_completed) {
            return;
        }
        int currentPageSize = this.getCalculator().getCurrentPageSize();
        long currentPage = this.getCalculator().getCurrentPage();
        Page page = this.cachedPages.get(currentPage);
        if (page == null) {
            page = new Page(currentPage, currentPageSize);
            long t1 = 0L;
            if (LOG.isTraceEnabled()) {
                t1 = System.currentTimeMillis();
            }
            if (this.selectionUp) {
                this.loadCurrentPageDataWithSelectionUp(page);
            } else {
                this.loadCurrentPageDataNoSelection(page);
            }
            if (LOG.isTraceEnabled()) {
                long t2 = System.currentTimeMillis();
                LOG.trace("Time to load {} features: {} ms", (Object)currentPageSize, (Object)(t2 - t1));
            }
            this.cachedPages.add(page);
        }
        this.features = page.getFeatures();
    }

    private void loadCurrentPageDataWithSelectionUp(Page page) throws BaseException {
        FeatureSelection theSelection = this.getSelection();
        if (theSelection == null) {
            this.loadCurrentPageDataNoSelection(page);
        } else {
            FeatureSet set = this.getFeatureSet(false);
            OneSubsetOneSetPagingCalculator twoSetsCalculator = null;
            if (this.getCalculator() instanceof OneSubsetOneSetPagingCalculator) {
                twoSetsCalculator = (OneSubsetOneSetPagingCalculator)this.getCalculator();
            } else {
                twoSetsCalculator = new OneSubsetOneSetPagingCalculator(new FeatureSetSizeableDelegate((FeatureSet)theSelection), new FeatureSetSizeableDelegate(set), this.getMaxPageSize(), this.getCalculator().getCurrentPage());
                this.setCalculator((PagingCalculator)twoSetsCalculator);
            }
            if (twoSetsCalculator.hasCurrentPageAnyValuesInFirstSet()) {
                this.loadDataFromFeatureSet(page, 0, (FeatureSet)theSelection, twoSetsCalculator.getFirstSetInitialIndex(), twoSetsCalculator.getFirstSetHowMany(), null);
            }
            if (twoSetsCalculator.hasCurrentPageAnyValuesInSecondSet()) {
                this.loadDataFromFeatureSet(page, (int)twoSetsCalculator.getFirstSetHowMany(), set, twoSetsCalculator.getSecondSetInitialIndex(), twoSetsCalculator.getSecondSetHowMany(), theSelection);
            }
        }
    }

    private void loadCurrentPageDataNoSelection(Page page) throws BaseException {
        long firstPosition = this.getCalculator().getInitialIndex();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading {} Features starting at position {}", (Object)this.getCalculator().getCurrentPageSize(), (Object)firstPosition);
        }
        FeatureSet featureSet = this.getFeatureSet(false);
        this.loadDataFromFeatureSet(page, 0, featureSet, firstPosition, this.getCalculator().getCurrentPageSize(), null);
    }

    private void loadDataFromFeatureSet(final Page page, final int valuesPosition, FeatureSet set, long initialIndex, final long howMany, final FeatureSelection selectedFeaturesToSkip) throws DataException {
        try {
            final MutableBoolean errorReported = new MutableBoolean(false);
            set.accept(new Visitor(){
                private int i;
                {
                    this.i = valuesPosition;
                }

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    block4: {
                        if ((long)this.i >= (long)valuesPosition + howMany) {
                            throw new VisitCanceledException();
                        }
                        Feature current = (Feature)obj;
                        if (selectedFeaturesToSkip == null || !selectedFeaturesToSkip.isSelected(current)) {
                            try {
                                page.setFeature(this.i, current.getCopy());
                                ++this.i;
                            }
                            catch (Exception ex) {
                                if (errorReported.booleanValue()) break block4;
                                LOG.warn("Problemas recuperando feature.", (Throwable)ex);
                                errorReported.setTrue();
                            }
                        }
                    }
                }
            }, initialIndex, howMany);
        }
        catch (VisitCanceledException errorReported) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof DataException) {
                throw (DataException)((Object)e);
            }
            LOG.warn("Error loading the data starting at position {}", (Object)initialIndex, (Object)e);
        }
    }

    public void delete(Feature feature) throws BaseException {
        this.featureStore.delete(feature);
        this.getFeatureSet(true);
        this.reloadCurrentPage();
    }

    public void insert(EditableFeature feature) throws BaseException {
        this.featureStore.insert(feature);
        this.getFeatureSet(true);
        this.reloadCurrentPage();
    }

    public boolean isEmpty() {
        try {
            return this.getFeatureSet(false).isEmpty();
        }
        catch (ConcurrentDataModificationException ex) {
            LOG.warn("ConcurrentDataModification error asking about the emptiness of the list. Retrying reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()));
            try {
                this.reload();
            }
            catch (BaseException e) {
                LOG.warn("Error reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()), (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return this.getFeatureSet(false).isEmpty();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error asking about the emptiness of the list after reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void update(EditableFeature feature) throws BaseException {
        this.featureStore.update(feature);
        this.getFeatureSet(true);
        this.reloadCurrentPage();
    }

    public FeatureType getFeatureType() {
        FeatureType ft = null;
        try {
            ft = this.featureStore.getDefaultFeatureType();
        }
        catch (DataException e) {
            LOG.warn("Error while getting feature type: " + e.getMessage(), (Throwable)e);
        }
        return ft;
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.featSet);
        DisposeUtils.disposeQuietly((Disposable)this.featureStore);
        DisposeUtils.disposeQuietly((Disposable)this.selection);
    }

    public DynObject[] getCurrentPageDynObjects() {
        Feature[] theFeatures = this.getCurrentPageFeatures();
        DynObject[] dynobjects = new DynObject[theFeatures.length];
        for (int i = 0; i < dynobjects.length; ++i) {
            dynobjects[i] = new DynObjectFeatureFacade(theFeatures[i]);
        }
        return dynobjects;
    }

    public DynObject getDynObjectAt(long index) throws BaseException {
        return new DynObjectFeatureFacade(this.getFeatureAt(index));
    }

    public List asList() {
        return new FeaturePagingHelperList();
    }

    public List asListOfDynObjects() {
        return new DynObjectPagingHelperList();
    }

    public long size64() {
        try {
            return this.getTotalSize();
        }
        catch (ConcurrentDataModificationException ex) {
            LOG.warn("ConcurrentDataModification error getting size of the list. Retrying reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()));
            try {
                this.reload();
            }
            catch (BaseException e) {
                LOG.warn("Error reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()), (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return this.getTotalSize();
            }
            catch (Exception e) {
                LOG.warn("Error getting size of the list after reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Feature get64(long position) {
        try {
            return this.getFeatureAt(position);
        }
        catch (FeatureIndexException e) {
            throw e.getIndexOutOfBoundsException();
        }
        catch (ConcurrentDataModificationException ex) {
            LOG.warn("ConcurrentDataModification error getting element " + position + " of the list. Retrying reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()));
            try {
                this.reload();
            }
            catch (BaseException e) {
                LOG.warn("Error reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()), (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return this.getFeatureAt(position);
            }
            catch (FeatureIndexException e) {
                throw e.getIndexOutOfBoundsException();
            }
            catch (Exception e) {
                LOG.warn("Error getting element " + position + " of the list after reloading data. " + (this.featSet == null ? 0 : this.featSet.hashCode()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (BaseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Iterator<Feature> iterator() {
        try {
            return this.getFeatureSet(false).fastIterator();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("evaluators", (Object)this.featureStore, true);
            builder.append("query", (Object)this.query, true);
            builder.append("selectionUp", this.selectionUp);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private abstract class PagingHelperList
    implements List,
    FacadeOfAFeaturePagingHelper,
    UnmodifiableBasicList,
    UnmodifiableBasicList64,
    Disposable {
        private PagingHelperList() {
        }

        public void dispose() {
            FeaturePagingHelperImpl.this.dispose();
        }

        public FeaturePagingHelper getFeaturePagingHelper() {
            return FeaturePagingHelperImpl.this;
        }

        public String toString() {
            return String.format("..(%d %ss)...", this.size(), FeaturePagingHelperImpl.this.featureStore.getName());
        }

        public long size64() {
            FeatureSet fset = null;
            try {
                return FeaturePagingHelperImpl.this.getTotalSize();
            }
            catch (ConcurrentDataModificationException ex) {
                LOG.info("ConcurrentDataModification error asking the size of the list. Retrying reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()));
                try {
                    FeaturePagingHelperImpl.this.reload();
                }
                catch (BaseException e) {
                    LOG.warn("Error reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
                try {
                    fset = FeaturePagingHelperImpl.this.getFeatureSet(false);
                    return fset.getSize();
                }
                catch (DataException e) {
                    LOG.warn("Error asking the size of the list after reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public int size() {
            long sz = this.size64();
            if (sz > Integer.MAX_VALUE) {
                sz = Integer.MAX_VALUE;
            }
            return (int)sz;
        }

        @Override
        public boolean isEmpty() {
            try {
                return FeaturePagingHelperImpl.this.getFeatureSet(false).isEmpty();
            }
            catch (ConcurrentDataModificationException ex) {
                LOG.warn("ConcurrentDataModification error asking about the emptiness of the list. Retrying reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()));
                try {
                    FeaturePagingHelperImpl.this.reload();
                }
                catch (BaseException e) {
                    LOG.warn("Error reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
                try {
                    return FeaturePagingHelperImpl.this.getFeatureSet(false).isEmpty();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Error asking about the emptiness of the list after reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Iterator iterator() {
            try {
                return FeaturePagingHelperImpl.this.getFeatureSet(false).fastIterator();
            }
            catch (ConcurrentDataModificationException ex) {
                LOG.warn("ConcurrentDataModification error getting iterator of the list. Retrying reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()));
                try {
                    FeaturePagingHelperImpl.this.reload();
                }
                catch (BaseException e) {
                    LOG.warn("Error reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
                try {
                    return FeaturePagingHelperImpl.this.getFeatureSet(false).fastIterator();
                }
                catch (DataException e) {
                    LOG.warn("Error getting iterator of the list after reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            catch (DataException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object[] toArray(Object[] ts) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean addAll(int i, Collection clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean removeAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean retainAll(Collection clctn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object set(int i, Object e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void add(int i, Object e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ListIterator listIterator(int i) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List subList(int i, int i1) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List toList() {
            return this;
        }
    }

    private class DynObjectPagingHelperList
    extends PagingHelperList {
        private DynObjectPagingHelperList() {
        }

        public Object get(int i) {
            return this.get64(i);
        }

        public Object get64(long position) {
            try {
                return FeaturePagingHelperImpl.this.getDynObjectAt(position);
            }
            catch (ConcurrentDataModificationException ex) {
                LOG.warn("ConcurrentDataModification error getting element " + position + " of the list. Retrying reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()));
                try {
                    FeaturePagingHelperImpl.this.reload();
                }
                catch (BaseException e) {
                    LOG.warn("Error reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
                try {
                    return FeaturePagingHelperImpl.this.getDynObjectAt(position);
                }
                catch (Exception e) {
                    LOG.warn("Error getting element " + position + " of the list after reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            catch (FeatureIndexException ex) {
                IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException("");
                ioobe.initCause(ex);
                throw ioobe;
            }
            catch (BaseException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class FeaturePagingHelperList
    extends PagingHelperList {
        private FeaturePagingHelperList() {
        }

        public Object get(int i) {
            return this.get64(i);
        }

        public Object get64(long i) {
            try {
                return FeaturePagingHelperImpl.this.getFeatureAt(i);
            }
            catch (ConcurrentDataModificationException ex) {
                LOG.info("ConcurrentDataModification error getting feature " + i + " of the list. Retrying reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()));
                try {
                    FeaturePagingHelperImpl.this.reload();
                }
                catch (BaseException e) {
                    LOG.warn("Error reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
                try {
                    return FeaturePagingHelperImpl.this.getFeatureAt(i);
                }
                catch (Exception e) {
                    LOG.warn("Error getting feature " + i + " of the list after reloading data. " + (FeaturePagingHelperImpl.this.featSet == null ? 0 : FeaturePagingHelperImpl.this.featSet.hashCode()), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            catch (BaseException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Object set(int i, Object e) {
            return super.set(i, e);
        }

        @Override
        public Object remove(int i) {
            return super.remove(i);
        }

        @Override
        public boolean add(Object e) {
            return super.add(e);
        }
    }

    private static class PageCache {
        private final int maxpages;
        private List<Page> pages;

        public PageCache(int maxpages) {
            this.maxpages = maxpages;
            this.pages = new ArrayList<Page>();
        }

        public void clear() {
            this.pages.forEach(page -> page.dispose());
            this.pages = new ArrayList<Page>();
        }

        public Page get(long pageNumber) {
            for (Page page : this.pages) {
                if (page.getPageNumber() != pageNumber) continue;
                return page;
            }
            return null;
        }

        public void add(Page page) {
            if (this.pages.size() < this.maxpages) {
                this.pages.add(page);
                return;
            }
            int toDrop = 0;
            for (int i = 0; i < this.pages.size(); ++i) {
                if (this.pages.get(i).getLastAccess() >= this.pages.get(toDrop).getLastAccess()) continue;
                toDrop = i;
            }
            this.pages.set(toDrop, page);
        }
    }

    private static class Page {
        private Feature[] features;
        private final long number;
        private final int size;
        private long lastaccess;

        public Page(long number, int size) {
            this.size = size;
            this.number = number;
            this.features = new Feature[size];
            this.lastaccess = 0L;
        }

        public void setFeature(int i, Feature copy) {
            this.features[i] = copy;
        }

        public Feature[] getFeatures() {
            this.lastaccess = new Date().getTime();
            return this.features;
        }

        public long getPageNumber() {
            return this.number;
        }

        public long getLastAccess() {
            return this.lastaccess;
        }

        public int size() {
            return this.size;
        }

        public void dispose() {
            for (int i = 0; i < this.features.length; ++i) {
                this.features[i] = null;
            }
            this.features = null;
            this.lastaccess = 0L;
        }
    }
}

