/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.impl.DefaultDALExpressionBuilder;
import org.gvsig.expressionevaluator.impl.DefaultFeatureRuleExpression;
import org.gvsig.expressionevaluator.impl.symboltable.FeatureSymbolTableImpl;
import org.gvsig.fmap.dal.BaseStoresRepository;
import org.gvsig.fmap.dal.DataFactory;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerFactory;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreFactory_v2_4;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.DatabaseStoresRepository;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenErrorHandler;
import org.gvsig.fmap.dal.Register;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.CreateFileStoreException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.expressionevaluator.DALExpressionBuilder;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.fmap.dal.feature.DataTypeDetector;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.FeatureRuleExpression;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.LabelsCacheForFieldValues;
import org.gvsig.fmap.dal.feature.exception.UnsupportedDataTypeException;
import org.gvsig.fmap.dal.feature.impl.DALFile;
import org.gvsig.fmap.dal.feature.impl.DataTypeDetectorImpl;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureIndex;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.FeatureStoreFactory;
import org.gvsig.fmap.dal.feature.impl.LabelsCacheForFieldValuesImpl;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.fmap.dal.feature.paging.impl.FeaturePagingHelperImpl;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.LocalTransaction;
import org.gvsig.fmap.dal.feature.spi.cache.FeatureCacheProvider;
import org.gvsig.fmap.dal.feature.spi.cache.FeatureCacheProviderFactory;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProvider;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProviderServices;
import org.gvsig.fmap.dal.impl.DataServerExplorerToDataExplorerFactoryWrapper;
import org.gvsig.fmap.dal.impl.DataStoreProviderToCoverageProviderFactoryWrapper;
import org.gvsig.fmap.dal.impl.DataStoreProviderToFeatureStoreProviderFactoryWrapper;
import org.gvsig.fmap.dal.impl.DefaultDataServerExplorerProviderServices;
import org.gvsig.fmap.dal.impl.DefaultDatabaseWorkspaceManager;
import org.gvsig.fmap.dal.impl.DefaultTransaction;
import org.gvsig.fmap.dal.impl.RegisterImpl;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.fmap.dal.raster.impl.RasterStoreFactory;
import org.gvsig.fmap.dal.raster.impl.RasterStoreOldFactory;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.spi.AbstractDataParameters;
import org.gvsig.fmap.dal.spi.DALSPILocator;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataServerExplorerPoolImpl;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.DynStruct_v2;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionSingleton;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.identitymanagement.UnauthorizedException;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.resourcesstorage.BytesResource;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.script.ScriptManager;
import org.gvsig.tools.service.spi.Services;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.util.Invocable;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataManager
implements DataManager,
DataManagerProviderServices,
Services {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDataManager.class);
    private static final String DATA_MANAGER_CACHE = "Data.manager.caches";
    private static final String DATA_MANAGER_CACHE_DESCRIPTION = "DAL cache providers";
    public static final String FILESYSTEM_EXPLORER_NAME = "FilesystemExplorer";
    public static final long DEFAULT_MAX_SIZE_FOR_SMALL_FEATURE_SELECTION = 2000000000L;
    private static final String TAG_DAL_OPENSTORE = "dal.openstore.";
    private final Registers registers;
    private final Map<Integer, String> defaultDataIndexProviders;
    private OpenErrorHandler openErrorHandler = null;
    private DataServerExplorerPool dataServerExplorerPool = null;
    private List<DataType> dataTypes = null;
    private ClassLoader resourcesLoader = null;
    private Map<String, DataProfile> dataProfiles;
    private final Map<String, DatabaseWorkspaceManager> databaseWorkspaces = new HashMap<String, DatabaseWorkspaceManager>();
    private final Map<String, DatabaseWorkspaceManager.DatabaseWorkspaceListener> addDatabaseWorkspaceListeners = new HashMap<String, DatabaseWorkspaceManager.DatabaseWorkspaceListener>();
    private final Set<Observer> storeObservers = new HashSet<Observer>();
    private long maxSizeForSmallFeatureSelection = 2000000000L;
    private Factory largeMapFactory;
    private Factory largeSetFactory;
    private boolean oldRasterRegistered = false;
    private StoresRepository storesRepository;
    private PropertiesSupportHelper propertiesSupportHelper;
    private File localResourcesFolder;

    public DefaultDataManager() {
        this.registers = new Registers();
        this.defaultDataIndexProviders = new HashMap<Integer, String>();
        this.largeMapFactory = new Factory(){

            public String getName() {
                return "HashMapFactory";
            }

            public Object create(Object ... parameters) {
                return new HashMap();
            }
        };
        this.largeSetFactory = new Factory(){

            public String getName() {
                return "HashSetFactory";
            }

            public Object create(Object ... parameters) {
                return new HashSet();
            }
        };
    }

    public Register getStoreRegister() {
        return this.registers.store;
    }

    public Register getStoreProviderRegister() {
        return this.registers.storeProvider;
    }

    public Register getServerExplorerRegister() {
        return this.registers.serverExplorer;
    }

    public Register getFeatureIndexRegister() {
        return this.registers.featureIndexProvider;
    }

    private String getStoreName(DataStoreParameters parameters) {
        for (DataFactory factory : this.getStoreRegister()) {
            DataStoreFactory_v2_4 storeFactory = (DataStoreFactory_v2_4)factory;
            if (!storeFactory.canUse((DataParameters)parameters)) continue;
            return storeFactory.getName();
        }
        return null;
    }

    public void registerDefaultRasterStore(Class rasterStoreClass) {
        this.getStoreRegister().register((DataFactory)new RasterStoreFactory(rasterStoreClass));
    }

    public void registerStoreFactory(String name, Class storeFactoryClass) {
        this.getStoreRegister().register((DataFactory)new RasterStoreOldFactory(name, storeFactoryClass));
        this.oldRasterRegistered = true;
    }

    public boolean isTheOldRasterRegistered() {
        return this.oldRasterRegistered;
    }

    public void registerStoreProvider(String name, Class storeProviderClass, Class parametersClass) {
        if (name == null || storeProviderClass == null || parametersClass == null) {
            throw new IllegalArgumentException("Any parameters can be null");
        }
        if (!DataStoreParameters.class.isAssignableFrom(parametersClass)) {
            throw new IllegalArgumentException(parametersClass.getName() + " must implement org.gvsig.fmap.dal.DataStoreParameters");
        }
        if (CoverageStoreProvider.class.isAssignableFrom(storeProviderClass)) {
            this.registerStoreProviderFactory((DataStoreProviderFactory)new DataStoreProviderToCoverageProviderFactoryWrapper(name, "", storeProviderClass, parametersClass));
            return;
        }
        if (FeatureStoreProvider.class.isAssignableFrom(storeProviderClass)) {
            this.registerStoreProviderFactory((DataStoreProviderFactory)new DataStoreProviderToFeatureStoreProviderFactoryWrapper(name, "", storeProviderClass, parametersClass));
            return;
        }
        throw new IllegalArgumentException("Not supported implemtation: name=" + name + " provider class=" + storeProviderClass.getName());
    }

    public void registerExplorerProvider(String name, Class explorerClass, Class parametersClass) {
        if (name == null || explorerClass == null || parametersClass == null) {
            throw new IllegalArgumentException("Any parameters can be null");
        }
        if (!DataServerExplorerParameters.class.isAssignableFrom(parametersClass)) {
            throw new IllegalArgumentException(parametersClass.getName() + " must implement org.gvsig.fmap.dal.DataServerExplorerParameters");
        }
        if (!DataServerExplorer.class.isAssignableFrom(explorerClass)) {
            throw new IllegalArgumentException(explorerClass.getName() + " must implement org.gvsig.fmap.dal.DataServerExplorer");
        }
        this.registerServerExplorerFactory((DataServerExplorerFactory)new DataServerExplorerToDataExplorerFactoryWrapper(name, "", explorerClass, parametersClass));
    }

    public void registerStoreFactory(DataStoreFactory_v2_4 factory) {
        this.getStoreRegister().register((DataFactory)factory);
    }

    public void registerStoreProviderFactory(DataStoreProviderFactory factory) {
        this.getStoreProviderRegister().register((DataFactory)factory);
    }

    public void registerServerExplorerFactory(DataServerExplorerFactory factory) {
        this.getServerExplorerRegister().register((DataFactory)factory);
    }

    public DataStoreParameters createStoreParameters(byte[] data) {
        DataStoreParameters parameters = (DataStoreParameters)AbstractDataParameters.fromByteArray((byte[])data);
        return parameters;
    }

    public DataStoreParameters createStoreParameters(String providerName) throws InitializeException, ProviderNotRegisteredException {
        return this.createStoreParameters(providerName, null);
    }

    public DataStoreParameters createStoreParameters(String providerName, Object ... arguments) throws InitializeException, ProviderNotRegisteredException {
        if (providerName == null) {
            String msg = "Provider name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (arguments != null && arguments.length > 0) {
            if (arguments.length == 1) {
                if (arguments[0] instanceof DataStoreParameters) {
                    return this.createStoreParameters(providerName, (DataStoreParameters)arguments[0]);
                }
                if (arguments[0] instanceof DynObject) {
                    return this.createStoreParameters(providerName, (DynObject)arguments[0]);
                }
            }
            if (arguments.length % 2 != 0) {
                throw new IllegalArgumentException("The number of arguments must be even.");
            }
        }
        if (providerName == null) {
            String msg = "Provider name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataFactory providerFactory = this.getStoreProviderRegister().getFactory(providerName);
        if (providerFactory == null) {
            String msg = "Can't locate provider factory for '" + providerName + "'.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataStoreParameters parameters = (DataStoreParameters)providerFactory.createParameters();
        if (arguments != null && arguments.length > 0) {
            for (int i = 0; i < arguments.length; i += 2) {
                String name = (String)arguments[i];
                if (name.endsWith("=")) {
                    name = name.substring(0, name.length() - 1);
                }
                Object value = arguments[i + 1];
                parameters.setDynValue(name, value);
            }
        }
        return parameters;
    }

    public NewDataStoreParameters createNewStoreParameters(String providerName) throws InitializeException, ProviderNotRegisteredException {
        String explorerName = this.getServerExplorerFromStore(providerName);
        return this.createNewStoreParameters(explorerName, providerName);
    }

    public NewDataStoreParameters createNewStoreParameters(String explorerName, String providerName) throws InitializeException, ProviderNotRegisteredException {
        try {
            DataServerExplorer explorer = this.openServerExplorer(explorerName, null);
            return explorer.getAddParameters(providerName);
        }
        catch (Exception ex) {
            throw new InitializeException((Throwable)ex);
        }
    }

    public DataServerExplorerParameters createServerExplorerParameters(String explorerName) throws InitializeException, ProviderNotRegisteredException {
        if (explorerName == null) {
            String msg = "Explorer name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        JsonObject parameters_json = null;
        DataFactory explorerFactory = this.getServerExplorerRegister().getFactory(explorerName);
        if (explorerFactory == null) {
            parameters_json = Json.createObject((String)explorerName);
            if (parameters_json == null || !parameters_json.containsKey((Object)"ProviderName")) {
                String msg = "Can't locate server explorer factory for '" + explorerName + "'.";
                LOGGER.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            explorerName = parameters_json.getString("ProviderName");
            explorerFactory = this.getServerExplorerRegister().getFactory(explorerName);
            if (explorerFactory == null) {
                String msg = "Can't locate server explorer factory for '" + explorerName + "'.";
                LOGGER.warn(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        DataServerExplorerParameters params = (DataServerExplorerParameters)explorerFactory.createParameters();
        if (parameters_json != null) {
            Json.addAll((DynObject)params, (JsonObject)parameters_json);
        }
        return params;
    }

    public DataStoreParameters createMemoryStoreParameters(String autoOrderAttributeName) throws InitializeException {
        try {
            DataStoreParameters parameters = this.createStoreParameters("Memory");
            if (autoOrderAttributeName != null) {
                parameters.setDynValue("autoOrderAttributeName", (Object)autoOrderAttributeName);
            }
            return parameters;
        }
        catch (Exception ex) {
            throw new InitializeException((Throwable)ex);
        }
    }

    public DataServerExplorer openServerExplorer(String explorerName, DataServerExplorerParameters parameters) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        if (explorerName == null) {
            String msg = "Explorer name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataFactory explorerFactory = this.getServerExplorerRegister().getFactory(explorerName);
        if (explorerFactory == null) {
            String msg = "Can't locate server explorer factory for '" + explorerName + "'.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (parameters == null) {
            parameters = (DataServerExplorerParameters)explorerFactory.createParameters();
        }
        DataServerExplorer explorer = (DataServerExplorer)explorerFactory.create((DynObject)parameters, (Services)new DefaultDataServerExplorerProviderServices());
        return explorer;
    }

    public DataServerExplorer openServerExplorer(String explorerName, Object ... arguments) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        if (arguments.length == 1 && arguments[0] instanceof DataServerExplorerParameters) {
            return this.openServerExplorer(explorerName, (DataServerExplorerParameters)arguments[0]);
        }
        if (explorerName == null) {
            String msg = "Explorer name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (arguments.length % 2 != 0) {
            throw new ValidateDataParametersException();
        }
        DataFactory explorerFactory = this.getServerExplorerRegister().getFactory(explorerName);
        DataServerExplorerParameters parameters = (DataServerExplorerParameters)explorerFactory.createParameters();
        for (int i = 0; i < arguments.length; i += 2) {
            String name = (String)arguments[i];
            if (name.endsWith("=")) {
                name = name.substring(0, name.length() - 1);
            }
            Object value = arguments[i + 1];
            parameters.setDynValue(name, value);
        }
        return this.openServerExplorer(explorerName, parameters);
    }

    public DataServerExplorer createServerExplorer(DataServerExplorerParameters parameters) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        return this.openServerExplorer(parameters.getExplorerName(), parameters);
    }

    public DataStore createStore(DataStoreParameters parameters) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        return this.openStore(parameters.getDataStoreName(), parameters);
    }

    public DataStore openStore(DataTransaction transaction, String providerName, DataStoreParameters parameters) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        return this.openStore(transaction, providerName, parameters, false);
    }

    public DataStore openStore(String providerName, DataStoreParameters parameters) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        return this.openStore((DataTransaction)null, providerName, parameters, false);
    }

    public DataStore openStore(String providerName, DataStoreParameters parameters, boolean ignoreDALResource) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        return this.openStore((DataTransaction)null, providerName, parameters, ignoreDALResource);
    }

    public DataStore openStore(DataTransaction transaction, String providerName, DataStoreParameters parameters, boolean ignoreDALResource) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        org.gvsig.fmap.dal.spi.DataStoreProvider provider;
        if (providerName == null) {
            String msg = "Provider name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("dal-read-store", (Object)parameters, providerName)) {
            throw new UnauthorizedException("dal-read-store", (Object)parameters, providerName);
        }
        parameters.validate();
        String storeName = this.getStoreName(parameters);
        if (StringUtils.isEmpty((CharSequence)storeName)) {
            String msg = "Can't locate the store name from the parameters. parameters=" + parameters.toString();
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataStoreFactory_v2_4 storeFactory = (DataStoreFactory_v2_4)this.getStoreRegister().getFactory(storeName);
        if (storeFactory == null) {
            String msg = "Can't locate store factory for '" + storeName + "'.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataFactory providerFactory = this.getStoreProviderRegister().getFactory(providerName);
        if (providerFactory == null) {
            String msg = "Can't locate provider factory for '" + providerName + "'.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataStore store = (DataStore)storeFactory.create((DynObject)parameters, (Services)this);
        if (store instanceof DefaultFeatureStore) {
            ((DefaultFeatureStore)store).setIgnoreDALResource(ignoreDALResource);
            try {
                DataTransaction.add((DataTransaction)transaction, (FeatureStore)((FeatureStore)store), (boolean)false);
            }
            catch (Exception ex) {
                throw new InitializeException(store.getFullName(), (Throwable)ex);
            }
        }
        if ((provider = (org.gvsig.fmap.dal.spi.DataStoreProvider)providerFactory.create((DynObject)parameters, (Services)store)) == null) {
            String msg = "Can't create provider for '" + providerName + "'.";
            LOGGER.trace(msg);
            throw new IllegalArgumentException(msg);
        }
        storeFactory.setProvider(store, (DataStoreProvider)provider);
        this.addObservers(store);
        if (store instanceof FeatureStoreProviderServices) {
            ((FeatureStoreProviderServices)store).notifyChange("after_Open_DataStore");
        }
        return store;
    }

    public DataFactory getStoreFactory(DataStoreParameters parameters) {
        String storeName = this.getStoreName(parameters);
        if (StringUtils.isEmpty((CharSequence)storeName)) {
            return null;
        }
        DataFactory storeFactory = this.getStoreRegister().getFactory(storeName);
        return storeFactory;
    }

    public void addObservers(DataStore store) {
        for (Observer storeObserver : this.storeObservers) {
            if (storeObserver == null) continue;
            store.addObserver(storeObserver);
        }
    }

    public DataStore openStore(DataStoreParameters parameters, org.gvsig.fmap.dal.spi.DataStoreProvider provider) {
        String storeName = this.getStoreName(parameters);
        if (StringUtils.isEmpty((CharSequence)storeName)) {
            String msg = "Can't locate the store name from the parameters. parameters=" + parameters.toString();
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataStoreFactory_v2_4 storeFactory = (DataStoreFactory_v2_4)this.getStoreRegister().getFactory(storeName);
        if (storeFactory == null) {
            String msg = "Can't locate store factory for '" + storeName + "'.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataStore store = (DataStore)storeFactory.create((DynObject)parameters, (Services)this);
        storeFactory.setProvider(store, (DataStoreProvider)provider);
        for (Observer storeObserver : this.storeObservers) {
            if (storeObserver == null) continue;
            store.addObserver(storeObserver);
        }
        if (store instanceof FeatureStoreProviderServices) {
            ((FeatureStoreProviderServices)store).notifyChange("after_Open_DataStore");
        }
        return store;
    }

    public DataStore openStore(String provider, DynObject parameters) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        DataStoreParameters params = this.toDataStoreParameters(provider, parameters);
        DataStore store = this.openStore(params.getDataStoreName(), params);
        return store;
    }

    public DataStore openStore(String providerName, Object ... arguments) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        if (arguments.length == 1) {
            if (arguments[0] instanceof DataStoreParameters) {
                return this.openStore(providerName, (DataStoreParameters)arguments[0]);
            }
            if (arguments[0] instanceof DynObject) {
                return this.openStore(providerName, (DynObject)arguments[0]);
            }
        }
        if (arguments.length == 2 && arguments[0] instanceof DataStoreParameters && arguments[1] instanceof Boolean) {
            return this.openStore(providerName, (DataStoreParameters)arguments[0], (Boolean)arguments[1]);
        }
        if (arguments.length % 2 != 0) {
            throw new ValidateDataParametersException();
        }
        if (providerName == null) {
            String msg = "Provider name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataFactory providerFactory = this.getStoreProviderRegister().getFactory(providerName);
        DataStoreParameters parameters = (DataStoreParameters)providerFactory.createParameters();
        for (int i = 0; i < arguments.length; i += 2) {
            String name = (String)arguments[i];
            if (name.endsWith("=")) {
                name = name.substring(0, name.length() - 1);
            }
            Object value = arguments[i + 1];
            parameters.setDynValue(name, value);
        }
        return this.openStore(providerName, parameters);
    }

    public FeatureStore createMemoryStore(String autoOrderAttributeName) throws InitializeException {
        try {
            DataStoreParameters parameters = this.createMemoryStoreParameters(autoOrderAttributeName);
            DataStore store = this.openStore("Memory", parameters);
            return (FeatureStore)store;
        }
        catch (Exception ex) {
            throw new InitializeException((Throwable)ex);
        }
    }

    public DataStoreProviderFactory getStoreProviderFactory(String providerName) {
        if (providerName == null) {
            String msg = "Provider name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        DataFactory providerFactory = this.getStoreProviderRegister().getFactory(providerName);
        return (DataStoreProviderFactory)providerFactory;
    }

    public List<String> getStoreProviders() {
        return this.getStoreProviderRegister().getFactoryNames();
    }

    public List<String> getStoreProviders(String explorerName) {
        if (explorerName == null) {
            String msg = "Explorer name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            DataServerExplorer explorer = this.openServerExplorer(explorerName, null);
            List names = explorer.getDataStoreProviderNames();
            return names;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get stores availables for explorer '" + explorerName + "'.", ex);
        }
    }

    public List<String> getExplorerProviders() {
        List names = this.getServerExplorerRegister().getFactoryNames();
        return names;
    }

    public org.gvsig.fmap.dal.spi.DataStoreProvider createProvider(DataStoreProviderServices providerServices, DataStoreParameters parameters) throws InitializeException, ProviderNotRegisteredException {
        String providerName = parameters.getDataStoreName();
        DataFactory providerFactory = this.getStoreProviderRegister().getFactory(providerName);
        if (providerFactory == null) {
            throw new ProviderNotRegisteredException(providerName);
        }
        while (true) {
            try {
                org.gvsig.fmap.dal.spi.DataStoreProvider provider = (org.gvsig.fmap.dal.spi.DataStoreProvider)providerFactory.create((DynObject)parameters, (Services)providerServices);
                return provider;
            }
            catch (Exception e) {
                boolean retry;
                if (this.openErrorHandler != null) continue;
                throw new InitializeException(providerName, (Throwable)e);
                if (retry = this.openErrorHandler.canRetryOpen(e, (DataParameters)parameters)) continue;
                throw new InitializeException(providerName, (Throwable)e);
            }
            break;
        }
    }

    public List<String> getFeatureIndexProviders() {
        List names = this.getFeatureIndexRegister().getFactoryNames();
        return names;
    }

    public void setDefaultFeatureIndexProviderName(int dataType, String name) {
        this.defaultDataIndexProviders.put(dataType, name);
    }

    public String getDefaultFeatureIndexProviderName(int dataType) {
        return this.defaultDataIndexProviders.get(dataType);
    }

    public FeatureIndexProviderServices createFeatureIndexProvider(String name, FeatureStore store, FeatureType type, String indexName, FeatureAttributeDescriptor attr) throws InitializeException, ProviderNotRegisteredException {
        if (name == null) {
            name = this.getDefaultFeatureIndexProviderName(attr.getType());
        }
        if (name == null) {
            throw new InitializeException("There not any index provider registered.", null);
        }
        DataFactory indexfactory = this.getFeatureIndexRegister().getFactory(name);
        if (indexfactory == null) {
            throw new InitializeException("There not any index provider registered with name '" + name + "'.", null);
        }
        FeatureIndexProvider provider = (FeatureIndexProvider)indexfactory.create(null, null);
        DefaultFeatureIndex services = new DefaultFeatureIndex((FeatureStoreProviderServices)store, type, provider, attr.getName(), indexName);
        services.initialize();
        return services;
    }

    public String getTemporaryDirectory() {
        FoldersManager manager = ToolsLocator.getFoldersManager();
        File folder = manager.getUniqueTemporaryFile(new String[]{"_daltmp_"});
        return folder.getAbsolutePath();
    }

    public DataStoreParameters createStoreParameters(DynStruct struct) throws InitializeException, ProviderNotRegisteredException {
        if (!(struct instanceof DynStruct_v2)) {
            throw new IllegalArgumentException("A DynStruct_v2 is required.");
        }
        Tags tags = ((DynStruct_v2)struct).getTags();
        return this.createStoreParameters(tags);
    }

    public DataStoreParameters createStoreParameters(Tags tags) throws InitializeException, ProviderNotRegisteredException {
        String providerName = (String)tags.get("dal.openstore.provider");
        if (providerName == null) {
            throw new IllegalArgumentException("Tag DAL.OpenStore.provider is missing in struct.");
        }
        int prefixlen = TAG_DAL_OPENSTORE.length();
        DataStoreParameters parameters = this.createStoreParameters(providerName);
        for (String key : tags) {
            if (!key.startsWith(TAG_DAL_OPENSTORE)) continue;
            parameters.setDynValue(key.substring(prefixlen), tags.get(key));
        }
        return parameters;
    }

    public DataStore openStore(DynStruct struct) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        DataStoreParameters paramters = this.createStoreParameters(struct);
        DataStore store = this.openStore(paramters.getDataStoreName(), paramters);
        return store;
    }

    public void newStore(String providerName, NewDataStoreParameters parameters, boolean overwrite) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        String explorerName = this.getServerExplorerFromStore(providerName);
        this.newStore(explorerName, providerName, parameters, overwrite);
    }

    public void newStore(String explorerName, String providerName, NewDataStoreParameters parameters, boolean overwrite) throws InitializeException, ProviderNotRegisteredException, ValidateDataParametersException {
        if (explorerName == null) {
            String msg = "Explorer name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (providerName == null) {
            String msg = "Provider name can't be null.";
            LOGGER.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        if (!identityManager.getCurrentIdentity().isAuthorized("dal-create-store", (Object)parameters, providerName)) {
            throw new UnauthorizedException("dal-create-store", (Object)parameters, providerName);
        }
        parameters.validate();
        try {
            DataServerExplorerParameters explorerParameters = this.createServerExplorerParameters(explorerName);
            DataServerExplorer server = this.openServerExplorer(explorerName, explorerParameters);
            server.add(providerName, parameters, overwrite);
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
    }

    @Deprecated
    public Evaluator createExpresion(String expression) throws InitializeException {
        Expression exp = ExpressionEvaluatorLocator.getManager().createExpression();
        exp.setPhrase(expression);
        return this.createExpresion(exp);
    }

    @Deprecated
    public Evaluator createExpresion(Expression expression) throws InitializeException {
        DefaultFeatureExpressionEvaluator exp = new DefaultFeatureExpressionEvaluator(expression);
        return exp;
    }

    public Evaluator createFilter(String expression) throws InitializeException {
        Expression exp = ExpressionEvaluatorLocator.getManager().createExpression();
        exp.setPhrase(expression);
        return this.createFilter(exp);
    }

    public Evaluator createFilter(Expression expression) throws InitializeException {
        DefaultFeatureExpressionEvaluator exp = new DefaultFeatureExpressionEvaluator(expression);
        return exp;
    }

    public FeaturePagingHelper createFeaturePagingHelper(FeatureStore featureStore, int pageSize) throws BaseException {
        return new FeaturePagingHelperImpl(featureStore, pageSize);
    }

    public FeaturePagingHelper createFeaturePagingHelper(FeatureStore featureStore, FeatureQuery featureQuery, int pageSize) throws BaseException {
        return new FeaturePagingHelperImpl(featureStore, featureQuery, pageSize);
    }

    public void setOpenErrorHandler(OpenErrorHandler handler) {
        this.openErrorHandler = handler;
    }

    public OpenErrorHandler getOpenErrorHandler() {
        return this.openErrorHandler;
    }

    public EditableFeatureType createFeatureType() {
        return new DefaultEditableFeatureType(null);
    }

    public EditableFeatureType createFeatureType(JsonObject json) {
        EditableFeatureType featureType = this.createFeatureType();
        featureType.fromJson(json);
        return featureType;
    }

    public DataServerExplorerPool getDataServerExplorerPool() {
        if (this.dataServerExplorerPool == null) {
            this.dataServerExplorerPool = new DataServerExplorerPoolImpl();
        }
        return this.dataServerExplorerPool;
    }

    public void setDataServerExplorerPool(DataServerExplorerPool pool) {
        this.dataServerExplorerPool = pool;
    }

    public DataStoreParameters toDataStoreParameters(String provider, DynObject params) throws InitializeException, ProviderNotRegisteredException {
        String providerName;
        if (params instanceof DataStoreParameters) {
            return (DataStoreParameters)params;
        }
        try {
            providerName = (String)params.getDynValue("ProviderName");
        }
        catch (Exception ex) {
            providerName = provider;
        }
        DataStoreParameters parameters = this.createStoreParameters(providerName);
        ToolsLocator.getDynObjectManager().copy(params, (DynObject)parameters);
        return parameters;
    }

    public List<DataType> getDataTypes() {
        if (this.dataTypes == null) {
            DataTypesManager manager = ToolsLocator.getDataTypesManager();
            this.dataTypes = new ArrayList<DataType>();
            this.dataTypes.add(manager.get(8));
            this.dataTypes.add(manager.get(1));
            this.dataTypes.add(manager.get(4));
            this.dataTypes.add(manager.get(7));
            this.dataTypes.add(manager.get(9));
            this.dataTypes.add(manager.get(66));
        }
        return this.dataTypes;
    }

    public void setResourcesLoader(ClassLoader loader) {
        this.resourcesLoader = loader;
    }

    public void setResourcesLoader(File folder) {
        if (folder == null) {
            this.resourcesLoader = null;
            return;
        }
        try {
            URL[] urls = new URL[]{folder.toURI().toURL()};
            this.resourcesLoader = new URLClassLoader(urls);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't create a ClassLoader from '" + folder.toString() + "'.", ex);
        }
    }

    public URL getResource(Object reourceLoader, String name) {
        URL x;
        if (this.resourcesLoader != null && (x = this.resourcesLoader.getResource(name)) != null) {
            return x;
        }
        x = reourceLoader.getClass().getResource(name);
        return x;
    }

    public InputStream getResourceAsStream(Object reourceLoader, String name) {
        InputStream x;
        if (this.resourcesLoader != null && (x = this.resourcesLoader.getResourceAsStream(name)) != null) {
            return x;
        }
        x = reourceLoader.getClass().getResourceAsStream(name);
        return x;
    }

    public ExpressionBuilder createExpressionBuilder() {
        return ExpressionEvaluatorLocator.getManager().createExpressionBuilder();
    }

    public void registerFeatureCacheProvider(FeatureCacheProviderFactory providerFactory) {
        ToolsLocator.getExtensionPointManager().add(DATA_MANAGER_CACHE, DATA_MANAGER_CACHE_DESCRIPTION).append(providerFactory.getName(), "", (ExtensionSingleton)providerFactory);
    }

    public FeatureCacheProvider createFeatureCacheProvider(String name, DynObject parameters) throws DataException {
        if (name == null) {
            throw new InitializeException("It is necessary to provide a cache name", null);
        }
        if (parameters == null) {
            throw new InitializeException("It is necessary to provide parameters to create the explorer", null);
        }
        try {
            FeatureCacheProviderFactory featureCacheProviderFactory = (FeatureCacheProviderFactory)ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_CACHE).create(name);
            if (featureCacheProviderFactory == null) {
                throw new ProviderNotRegisteredException(name);
            }
            return featureCacheProviderFactory.createCacheProvider(parameters);
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public List getFeatureCacheProviders() {
        ExtensionPoint extensionPoint = ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_CACHE);
        if (extensionPoint != null) {
            return ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_CACHE).getNames();
        }
        return new ArrayList();
    }

    public DynObject createCacheParameters(String name) throws InitializeException, ProviderNotRegisteredException {
        if (name == null) {
            throw new InitializeException("It is necessary to provide a cache name", null);
        }
        try {
            FeatureCacheProviderFactory featureCacheProviderFactory = (FeatureCacheProviderFactory)ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_CACHE).create(name);
            if (featureCacheProviderFactory == null) {
                throw new ProviderNotRegisteredException(name);
            }
            return featureCacheProviderFactory.createParameters();
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void createFileStore(String providerName, NewDataStoreParameters params, boolean overwrite) throws DataException {
        DataServerExplorer serverExplorer;
        DataManagerProviderServices dataManager = DALSPILocator.getDataManagerProviderServices();
        DataServerExplorerParameters eparams = null;
        try {
            serverExplorer = dataManager.openServerExplorer(FILESYSTEM_EXPLORER_NAME, eparams);
        }
        catch (InitializeException | ProviderNotRegisteredException | ValidateDataParametersException e) {
            throw new OpenException(FILESYSTEM_EXPLORER_NAME, e);
        }
        try {
            serverExplorer.add(providerName, params, overwrite);
        }
        catch (DataException e) {
            throw new CreateFileStoreException((Throwable)e, providerName);
        }
    }

    public FeatureSymbolTable createFeatureSymbolTable() {
        FeatureSymbolTableImpl symbolTable = new FeatureSymbolTableImpl();
        return symbolTable;
    }

    public FeatureSymbolTable createFeatureSymbolTable(String name) {
        FeatureSymbolTableImpl symbolTable = new FeatureSymbolTableImpl(name);
        return symbolTable;
    }

    public FeatureAttributeEmulatorExpression createFeatureAttributeEmulatorExpression(FeatureType type, Expression expression) {
        DefaultFeatureAttributeEmulatorExpression emulator = new DefaultFeatureAttributeEmulatorExpression(type, expression);
        return emulator;
    }

    public void registerDataProfile(DataProfile profile) {
        if (profile == null) {
            return;
        }
        if (this.dataProfiles == null) {
            this.dataProfiles = new HashMap<String, DataProfile>();
        }
        this.dataProfiles.put(profile.getID().toLowerCase(), profile);
    }

    public List<DataProfile> getDataProfiles() {
        if (this.dataProfiles == null) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<DataProfile>(this.dataProfiles.values()));
    }

    public DataProfile getDataProfile(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (this.dataProfiles == null) {
            return null;
        }
        return this.dataProfiles.get(name.toLowerCase());
    }

    public StoresRepository getStoresRepository() {
        if (this.storesRepository == null) {
            this.storesRepository = new BaseStoresRepository("DAL");
        }
        return this.storesRepository;
    }

    public DatabaseWorkspaceManager createDatabaseWorkspaceManager(DataServerExplorerParameters connection) {
        DefaultDatabaseWorkspaceManager workspace = new DefaultDatabaseWorkspaceManager(connection);
        return workspace;
    }

    public void removeDatabaseWorkspace(DatabaseWorkspaceManager databaseWorkspace) {
        this.databaseWorkspaces.remove(databaseWorkspace.getId(), databaseWorkspace);
        StoresRepository repo = databaseWorkspace.getStoresRepository();
        this.getStoresRepository().removeRepository(repo.getID());
        for (DatabaseWorkspaceManager.DatabaseWorkspaceListener listener : this.addDatabaseWorkspaceListeners.values()) {
            if (listener == null) continue;
            try {
                listener.onRemoveDatabaseWorkspace(databaseWorkspace);
            }
            catch (Throwable th) {
                LOGGER.warn("Problems calling databaseworkspace listener '" + listener.getName() + "'.", th);
            }
        }
        try {
            ResourcesStorage resources = databaseWorkspace.getResourcesStorage();
            ScriptManager scriptManager = ToolsLocator.getScriptManager();
            Script script = scriptManager.loadScript(resources, "OnDisconnectToWorkspace.script");
            if (script != null) {
                script.invokeFunction("main", new Object[]{databaseWorkspace});
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Problems executing 'OnDisconnectToWorkspace.script' from workspace '" + databaseWorkspace.getId() + "'.", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatabaseWorkspace(DatabaseWorkspaceManager databaseWorkspace) {
        this.databaseWorkspaces.put(databaseWorkspace.getId(), databaseWorkspace);
        StoresRepository repo = databaseWorkspace.getStoresRepository();
        this.getStoresRepository().addRepository(repo);
        for (DatabaseWorkspaceManager.DatabaseWorkspaceListener listener : this.addDatabaseWorkspaceListeners.values()) {
            if (listener == null) continue;
            try {
                listener.onAddDatabaseWorkspace(databaseWorkspace);
            }
            catch (Throwable th) {
                LOGGER.warn("Problems calling databaseworkspace listener '" + listener.getName() + "'.", th);
            }
        }
        LocalTransaction trans = new LocalTransaction((DataManager)this, null);
        try {
            trans.begin();
            trans.add((Object)databaseWorkspace);
            ResourcesStorage resources = databaseWorkspace.getResourcesStorage();
            ScriptManager scriptManager = ToolsLocator.getScriptManager();
            Script script = scriptManager.loadScript(resources, "OnConnectToWorkspace.script");
            if (script != null) {
                script.invokeFunction("main", new Object[]{databaseWorkspace});
            }
            trans.commit();
        }
        catch (Throwable th) {
            LOGGER.warn("Problems executing 'OnConnectToWorkspace.script' from workspace '" + databaseWorkspace.getId() + "'.", th);
            trans.abortQuietly();
        }
        finally {
            trans.closeQuietly();
        }
    }

    public void addDatabaseWorkspaceListener(DatabaseWorkspaceManager.DatabaseWorkspaceListener listener) {
        this.addDatabaseWorkspaceListeners.put(listener.getName(), listener);
    }

    public DatabaseWorkspaceManager getDatabaseWorkspace(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.databaseWorkspaces.get(name);
    }

    public DatabaseWorkspaceManager getDatabaseWorkspace(DataStoreParameters params) {
        for (DatabaseWorkspaceManager databaseWorkspace : this.databaseWorkspaces.values()) {
            if (!databaseWorkspace.getStoresRepository().contains(params)) continue;
            return databaseWorkspace;
        }
        return null;
    }

    public DatabaseWorkspaceManager getDatabaseWorkspace(DataServerExplorerParameters params) {
        for (DatabaseWorkspaceManager databaseWorkspace : this.databaseWorkspaces.values()) {
            DataServerExplorerParameters p = databaseWorkspace.getServerExplorerParameters();
            if (!p.isTheSameServerExplorer(params)) continue;
            return databaseWorkspace;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDALResource(ResourcesStorage resources, DataStore store) {
        block10: {
            ResourcesStorage.Resource resource;
            block9: {
                block8: {
                    block7: {
                        resource = null;
                        if (resources != null && !resources.isReadOnly()) break block7;
                        IOUtils.closeQuietly(resource);
                        return;
                    }
                    resource = resources.getResource("dal");
                    if (resource != null && !resource.isReadOnly()) break block8;
                    IOUtils.closeQuietly((Closeable)resource);
                    return;
                }
                try {
                    DALFile dalFile = DALFile.getDALFile();
                    dalFile.setStore((DefaultFeatureStore)store);
                    if (dalFile.isEmpty()) break block9;
                    dalFile.write(resource);
                }
                catch (Throwable ex) {
                    try {
                        LOGGER.warn("Can't save DAL resource", ex);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly(resource);
                    }
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDALResource(ResourcesStorage resources, FeatureType featureType) {
        block10: {
            ResourcesStorage.Resource resource;
            block9: {
                block8: {
                    block7: {
                        resource = null;
                        if (resources != null && !resources.isReadOnly()) break block7;
                        IOUtils.closeQuietly(resource);
                        return;
                    }
                    resource = resources.getResource("dal");
                    if (resource != null && !resource.isReadOnly()) break block8;
                    IOUtils.closeQuietly((Closeable)resource);
                    return;
                }
                try {
                    DALFile dalFile = DALFile.getDALFile();
                    dalFile.setFeatureType(featureType);
                    if (dalFile.isEmpty()) break block9;
                    dalFile.write(resource);
                }
                catch (Throwable ex) {
                    try {
                        LOGGER.warn("Can't save DAL resource", ex);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly(resource);
                    }
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    public void clearAvailableValuesCache() {
    }

    public String createUniqueID() {
        UUID x = UUID.randomUUID();
        String s = x.toString();
        return s;
    }

    public EditableFeatureAttributeDescriptor createFeatureAttributeDescriptor(String name, int type) {
        return DefaultDataManager.createEditableFeatureAttributeDescriptor(null, name, type, false);
    }

    public static DefaultEditableFeatureAttributeDescriptor createEditableFeatureAttributeDescriptor(FeatureType ftype, String name, int type) {
        return DefaultDataManager.createEditableFeatureAttributeDescriptor(ftype, name, type, false);
    }

    public static DefaultEditableFeatureAttributeDescriptor createEditableFeatureAttributeDescriptor(FeatureType ftype, String name, int type, boolean strongChanges) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 34: 
            case 64: 
            case 66: {
                break;
            }
            default: {
                throw new UnsupportedDataTypeException(name, type);
            }
        }
        DefaultEditableFeatureAttributeDescriptor edi = new DefaultEditableFeatureAttributeDescriptor(ftype, strongChanges);
        edi.setName(name);
        edi.setDataType(type);
        if (edi.getDataType().supportSize()) {
            edi.setSize(edi.getDataType().getDefaultSize());
        }
        return edi;
    }

    public DALExpressionBuilder createDALExpressionBuilder() {
        return new DefaultDALExpressionBuilder();
    }

    public void addStoreObserver(Observer observer) {
        this.storeObservers.add(observer);
    }

    public void removeStoreObserver(Observer observer) {
        this.storeObservers.remove(observer);
    }

    public String getServerExplorerFromStore(String name) {
        Register r = this.getServerExplorerRegister();
        for (DataFactory factory0 : r) {
            DataServerExplorerFactory factory = (DataServerExplorerFactory)factory0;
            if (!factory.isStoreSupported(name)) continue;
            return factory.getName();
        }
        return null;
    }

    public void setMaxSizeForSmallFeatureSelection(long size) {
        this.maxSizeForSmallFeatureSelection = size;
    }

    public long getMaxSizeForSmallFeatureSelection() {
        return this.maxSizeForSmallFeatureSelection;
    }

    public void registerLargeMap(Factory factory) {
        this.largeMapFactory = factory;
    }

    public void registerLargeSet(Factory factory) {
        this.largeSetFactory = factory;
    }

    public Map createLargeMap() {
        return (Map)this.largeMapFactory.create(new Object[0]);
    }

    public Set createLargeSet() {
        return (Set)this.largeSetFactory.create(new Object[0]);
    }

    public DataTransaction createTransaction() {
        DefaultTransaction transaction = new DefaultTransaction();
        return transaction;
    }

    public void putFeaturesInClipboard(FeatureSet set) {
        if (set == null) {
            return;
        }
        String s = set.toJson().toString();
        ToolsSwingLocator.getToolsSwingManager().putInClipboard(s);
    }

    public List<EditableFeature> getFeaturesFromClipboard(FeatureStore store, Predicate<FeatureAttributeDescriptor> attrFilter) throws DataException {
        if (store == null) {
            return Collections.EMPTY_LIST;
        }
        String clipboard = ToolsSwingLocator.getToolsSwingManager().getFromClipboard();
        if (StringUtils.isBlank((CharSequence)clipboard)) {
            return Collections.EMPTY_LIST;
        }
        JsonArray array = Json.createArray((String)clipboard);
        if (array == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EditableFeature> features = new ArrayList<EditableFeature>();
        for (JsonValue jsonValue : array) {
            EditableFeature f = store.createNewFeature();
            f.copyFrom((JsonObject)jsonValue, attrFilter);
            features.add(f);
        }
        return features;
    }

    public FeatureRuleExpression createFeatureRuleExpression() {
        DefaultFeatureRuleExpression rule = new DefaultFeatureRuleExpression();
        return rule;
    }

    public File getCacheResourcesFolder() {
        FoldersManager fm = ToolsLocator.getFoldersManager();
        File f = fm.getTemporaryFile(new String[]{"resources-storage"});
        return f;
    }

    public void clearAllCachedResources() {
        try {
            File f = this.getCacheResourcesFolder();
            FileUtils.deleteDirectory((File)f);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't remove local cache for of resources.", (Throwable)ex);
        }
    }

    public LabelsCacheForFieldValues createLabelsCacheForFieldValues(Invocable labelFormulaProvider, SimpleTaskStatus status) {
        LabelsCacheForFieldValuesImpl x = new LabelsCacheForFieldValuesImpl(labelFormulaProvider, status);
        return x;
    }

    public List<FeatureType> getFeatureTypesFromDAL(byte[] daldata) {
        try {
            BytesResource res = ResourcesStorage.createBytesResource((byte[])daldata);
            DALFile dalfile = DALFile.getDALFile((ResourcesStorage.Resource)res);
            return dalfile.getFeatureTypes();
        }
        catch (DataException ex) {
            return null;
        }
    }

    public byte[] getDALBytesFromFeatureType(FeatureType ftype) {
        try {
            DALFile dalfile = DALFile.getDALFile();
            dalfile.setFeatureType(ftype);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            dalfile.write(bos);
            IOUtils.closeQuietly((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (DataException ex) {
            return null;
        }
    }

    public Object getProperty(String name) {
        if (this.propertiesSupportHelper == null) {
            return null;
        }
        return this.propertiesSupportHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        if (this.propertiesSupportHelper == null) {
            this.propertiesSupportHelper = new PropertiesSupportHelper();
        }
        this.propertiesSupportHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        if (this.propertiesSupportHelper == null) {
            return Collections.EMPTY_MAP;
        }
        return this.propertiesSupportHelper.getProperties();
    }

    public DataTypeDetector createDataTypeDetector(Locale locale) {
        DataTypeDetectorImpl x = new DataTypeDetectorImpl(locale);
        return x;
    }

    public File getLocalResourcesFolder() {
        if (this.localResourcesFolder == null) {
            FoldersManager fm = ToolsLocator.getFoldersManager();
            this.localResourcesFolder = FileUtils.getFile((File)fm.getTemporaryFolder(), (String[])new String[]{"localresources"});
        }
        return this.localResourcesFolder;
    }

    public File getLocalResourcesFolder(DataServerExplorerParameters params) {
        if (!(params instanceof JDBCServerExplorerParameters)) {
            return null;
        }
        try {
            JDBCServerExplorerParameters parameters = (JDBCServerExplorerParameters)params;
            StringBuilder s = new StringBuilder();
            s.append("r");
            if (StringUtils.isNotBlank((CharSequence)parameters.getProviderName())) {
                s.append("-");
                s.append(parameters.getProviderName());
            }
            if (StringUtils.isNotBlank((CharSequence)parameters.getHost())) {
                s.append("-");
                s.append(parameters.getHost());
                s.append("-");
                s.append(parameters.getPort());
            }
            if (StringUtils.isNotBlank((CharSequence)parameters.getDBName())) {
                s.append("-");
                s.append(parameters.getDBName());
            }
            s.append("-");
            s.append(DigestUtils.md5Hex((String)parameters.getUrl()));
            File f = FileUtils.getFile((File)this.getLocalResourcesFolder(), (String[])new String[]{s.toString()});
            return f;
        }
        catch (Throwable ex) {
            LOGGER.debug("Can't get local resources folder.", ex);
            return null;
        }
    }

    public void setLocalResourcesFolder(File resourcesFolder) {
        this.localResourcesFolder = resourcesFolder;
    }

    public FeatureReferenceSelection createSelectionFromPks(FeatureStore store, Iterator pks) {
        FeatureReferenceSelection selection = FeatureReferenceFactory.createSelection(store, pks);
        return selection;
    }

    public DatabaseStoresRepository createDatabaseStoresRepository(String name, String label, DataServerExplorerParameters serverParams) {
        return new DatabaseStoresRepositoryImpl(name, label, serverParams);
    }

    private static class DatabaseStoresRepositoryImpl
    extends BaseStoresRepository
    implements DatabaseStoresRepository {
        public DatabaseStoresRepositoryImpl(String name, String label, DataServerExplorerParameters serverParameters) {
            super(name, label, serverParameters);
        }
    }

    private class Registers {
        private final Register store = new RegisterImpl("Data.manager.stores.factory", "DAL store factories");
        private final Register storeProvider = new RegisterImpl("Data.manager.providers.factory", "DAL store provider factories");
        private final Register serverExplorer = new RegisterImpl("Data.manager.servereexplorer.factory", "DAL server explorer factories");
        private final Register featureIndexProvider = new RegisterImpl("Data.manager.feature.index.factory", "DAL feature index factories");

        public Registers() {
            this.store.register((DataFactory)new FeatureStoreFactory());
        }
    }
}

