/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.memory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.memory.MemoryFeatureProviderAttributeMapper;
import org.gvsig.fmap.dal.feature.spi.memory.MemoryFeatureSet;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractMemoryStoreProvider
extends AbstractFeatureStoreProvider {
    protected List data;

    protected AbstractMemoryStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        super(params, storeServices, metadata);
    }

    protected AbstractMemoryStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices) {
        super(params, storeServices);
    }

    @Override
    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        throw new UnsupportedOperationException();
    }

    public void addFeatureProvider(FeatureProvider data) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        data.setOID(this.createNewOID());
        this.data.add(data);
    }

    public long getDataSize() throws DataException {
        this.open();
        return this.data.size();
    }

    @Override
    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference) throws DataException {
        int oid = ((Number)reference.getOID()).intValue();
        return (FeatureProvider)this.data.get(oid);
    }

    @Override
    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference, FeatureType featureType) throws DataException {
        return new MemoryFeatureProviderAttributeMapper((DefaultFeatureProvider)this.internalGetFeatureProviderByReference(reference), featureType);
    }

    @Override
    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        this.open();
        return new MemoryFeatureSet((AbstractFeatureStoreProvider)this, query, featureType, this.data);
    }

    @Override
    public FeatureProvider createFeatureProvider(FeatureType featureType) throws DataException {
        this.open();
        return new MemoryFeatureProvider(featureType);
    }

    @Override
    public long getFeatureCount() throws DataException {
        return this.data.size();
    }

    protected AbstractMemoryStoreProvider getMemoryProvider() {
        return this;
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.data = null;
    }

    public class MemoryFeatureProvider
    extends DefaultFeatureProvider {
        public MemoryFeatureProvider(FeatureType type) {
            super(type);
        }

        public MemoryFeatureProvider(FeatureType featureType, Object createNewOID) {
            super(featureType, createNewOID);
        }

        @Override
        public FeatureType getType() {
            try {
                if (AbstractMemoryStoreProvider.this.getStoreServices().getFeatureTypes().size() == 1) {
                    return AbstractMemoryStoreProvider.this.getStoreServices().getDefaultFeatureType();
                }
                return super.getType();
            }
            catch (DataException ex) {
                return super.getType();
            }
        }
    }
}

