/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.spi;

import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.raster.BandQuery;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.spi.AbstractOpenRasterStoreParameters;
import org.gvsig.fmap.dal.raster.spi.AbstractRasterStoreProvider;
import org.gvsig.fmap.dal.raster.spi.BandDescriptorServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.PageManager;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.spi.DefaultTileStruct;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAwtRasterStoreProvider
extends AbstractRasterStoreProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAwtRasterStoreProvider.class);
    protected Envelope envelope = null;
    private IProjection projection = null;
    private Raster raster;
    private List<PageManager> pageManagers;
    private TileStruct tileStruct;

    public AbstractAwtRasterStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        super(params, storeServices, metadata);
    }

    protected void init(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        if (params == null) {
            throw new InitializeException((Throwable)new NullPointerException("params is null"));
        }
        this.projection = (IProjection)params.getDynValue("CRS");
    }

    protected void open(Raster raster) throws CreateEnvelopeException {
        BufferManager bufferManager = BufferLocator.getBufferManager();
        this.raster = raster;
        this.pageManagers = new ArrayList<PageManager>();
        for (int band = 0; band < this.raster.getNumBands(); ++band) {
            BandDescriptorServices bandDescriptor = this.getBandDescriptor(band);
            bandDescriptor.setDataType(bufferManager.getBufferTypeFromAwtRaster(this.getRaster()));
            bandDescriptor.setName(String.valueOf(band));
            try {
                bandDescriptor.setDescription(this.getName() + "- band " + band);
            }
            catch (Exception e) {
                bandDescriptor.setDescription("band " + band);
            }
            bandDescriptor.add("X size", this.raster.getWidth());
            bandDescriptor.add("Y size", this.raster.getHeight());
            this.pageManagers.add((PageManager)bufferManager.createAwtRasterBandPageManager(raster, band));
        }
        this.envelope = this.getParameters().getWldParams() != null ? this.createWLDEnvelope(this.getParameters().getWldParams()) : GeometryLocator.getGeometryManager().createEnvelope(0.0, 0.0, (double)this.getRaster().getWidth(), (double)this.getRaster().getHeight(), 0);
    }

    @Override
    public AbstractOpenRasterStoreParameters getParameters() {
        return (AbstractOpenRasterStoreParameters)super.getParameters();
    }

    protected boolean isOpen() {
        return this.raster != null;
    }

    @Override
    public int getBands() {
        return this.getRaster().getNumBands();
    }

    @Override
    public Buffer createBuffer(RasterQuery rasterQuery) throws BufferException {
        NoData[] bandNoData;
        int[] bandDataTypes;
        BufferManager bufferManager = BufferLocator.getBufferManager();
        List<Object> pageManagers = new ArrayList();
        if (rasterQuery != null && !rasterQuery.getBands().isEmpty()) {
            List bands = rasterQuery.getBands();
            bandDataTypes = new int[bands.size()];
            bandNoData = new NoData[bands.size()];
            for (BandQuery bandQuery : bands) {
                int band = bandQuery.getBand();
                bandDataTypes[band] = this.getBandDescriptor(band).getDataType();
                bandNoData[band] = this.getNoData(rasterQuery, band);
                pageManagers.add(this.pageManagers.get(band));
            }
        } else {
            bandDataTypes = this.getDataTypes();
            bandNoData = this.getNoDatas();
            pageManagers = this.pageManagers;
        }
        Buffer buffer = bufferManager.createBuffer(this.getRaster().getHeight(), this.getRaster().getWidth(), bandDataTypes, bandNoData, this.projection, this.envelope, pageManagers);
        return buffer;
    }

    protected Envelope createWLDEnvelope(List<String> wldParams) {
        double pixelSizeX = Double.valueOf(wldParams.get(0));
        double rotationAxisY = Double.valueOf(wldParams.get(1));
        double rotationAxisX = Double.valueOf(wldParams.get(2));
        double pixelSizeY = Double.valueOf(wldParams.get(3));
        double upperLeftPixelCenterCoordX = Double.valueOf(wldParams.get(4));
        double upperLeftPixelCenterCoordY = Double.valueOf(wldParams.get(5));
        if (0.0 != rotationAxisX || 0.0 != rotationAxisY) {
            logger.warn("Rotation in wld file not implemented yet. It will be ignored");
        }
        double leftMostX = upperLeftPixelCenterCoordX - pixelSizeX * 0.5;
        double upperMostY = upperLeftPixelCenterCoordY - pixelSizeY * 0.5;
        double height = (double)this.getRaster().getHeight() * pixelSizeY;
        double width = (double)this.getRaster().getWidth() * pixelSizeX;
        try {
            this.envelope = GeometryLocator.getGeometryManager().createEnvelope(Math.min(leftMostX, leftMostX + width), Math.min(upperMostY, upperMostY + height), Math.max(leftMostX, leftMostX + width), Math.max(upperMostY, upperMostY + height), 0);
        }
        catch (CreateEnvelopeException | LocatorException e) {
            logger.warn("Failed to create envelope from wld file with coords: minx:" + leftMostX + ", miny:" + upperMostY + ", maxX: " + leftMostX + width + ", maxY: " + upperMostY + height);
            e.printStackTrace();
        }
        return this.envelope;
    }

    @Override
    public Object getDynValue(String name) throws DynFieldNotFoundException {
        IProjection pro;
        if ("Envelope".equalsIgnoreCase(name)) {
            return this.envelope;
        }
        if ("CRS".equalsIgnoreCase(name) && (pro = (IProjection)this.getParameters().getDynValue("CRS")) != null) {
            return pro;
        }
        return super.getDynValue(name);
    }

    @Override
    public void close() throws CloseException {
        this.raster = null;
    }

    protected Raster getRaster() {
        this.autoOpen();
        return this.raster;
    }

    @Override
    public TileStruct getTileStruct() {
        ArrayList<Double> pixelSizes = new ArrayList<Double>();
        HashMap zoomLevels = new HashMap();
        if (this.tileStruct == null) {
            this.tileStruct = new DefaultTileStruct();
            int completeRows = this.getRaster().getHeight();
            int completeColumns = this.getRaster().getWidth();
            double completePixelSizeX = this.envelope.getLength(0) / (double)completeColumns;
            double completePixelSizeY = this.envelope.getLength(1) / (double)completeRows;
            int maximumLength = completeColumns;
            int tileMaximumLength = this.tileStruct.getColumnsPerTile();
            double maximumPixelSize = completePixelSizeX;
            if (completeRows * this.tileStruct.getRowsPerTile() > completeColumns * this.tileStruct.getColumnsPerTile()) {
                maximumLength = completeRows;
                tileMaximumLength = this.tileStruct.getRowsPerTile();
                maximumPixelSize = completePixelSizeY;
            }
            double pixelSize = maximumPixelSize;
            while ((double)maximumLength * maximumPixelSize / pixelSize > (double)tileMaximumLength) {
                pixelSizes.add(pixelSize);
                pixelSize *= 2.0;
            }
            pixelSizes.add(pixelSize);
            int i = 0;
            for (int zoomLevel = pixelSizes.size() - 1; zoomLevel >= 0; --zoomLevel) {
                zoomLevels.put(i, pixelSizes.get(zoomLevel));
                ++i;
            }
        }
        return this.tileStruct;
    }

    @Override
    public BufferDimensions getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = BufferLocator.getBufferManager().createBufferDimensions(this.getRaster().getHeight(), this.getRaster().getWidth(), this.envelope);
        }
        return this.dimensions;
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        if (this.pageManagers != null) {
            Iterator<PageManager> iterator = this.pageManagers.iterator();
            while (iterator.hasNext()) {
                PageManager pageManager = iterator.next();
                DisposeUtils.dispose((Disposable)pageManager);
                iterator.remove();
            }
            this.pageManagers = null;
        }
        if (this.tileStruct != null) {
            DisposeUtils.dispose((Disposable)((Disposable)this.tileStruct));
            this.tileStruct = null;
        }
        this.raster = null;
    }
}

