/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.spi;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.raster.OpenRasterStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenRasterStoreParameters
extends AbstractDataStoreParameters
implements OpenRasterStoreParameters {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOpenRasterStoreParameters.class);
    public static final String WLD_PARAMS_NAME = "wldParams";

    public void setCRS(String crsCode) {
        IProjection crs = CRSFactory.getCRS((String)crsCode);
        this.setDynValue("CRS", crs);
    }

    public void setCRS(IProjection crs) {
        this.setDynValue("CRS", crs);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue("CRS");
    }

    public List<String> getWldParams() {
        return (List)this.getDynValue(WLD_PARAMS_NAME);
    }

    public void setWldParams(List<String> wldParams) {
        this.setDynValue(WLD_PARAMS_NAME, wldParams);
    }

    protected void loadPRJ(File file) {
        File prjFile = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + ".prj");
        if (prjFile.exists()) {
            try {
                String contentFile = FileUtils.readFileToString((File)prjFile);
                if (StringUtils.isNotEmpty((CharSequence)contentFile)) {
                    IProjection crs = CRSFactory.getCRSFactory().get("wkt_esri", contentFile);
                    this.setCRS(crs);
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't read wld file");
            }
        }
    }

    protected void loadWLD(File file) {
        File wldFile = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + ".wld");
        if (wldFile.exists()) {
            try {
                List lines = FileUtils.readLines((File)wldFile);
                if (lines != null && lines.size() == 6) {
                    this.setWldParams(lines);
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't read wld file");
            }
        }
    }
}

