/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;

public abstract class AbstractDataProviderIterator
extends AbstractDisposable
implements DisposableIterator {
    private final DataStoreProvider dataStoreProvider;
    private final ResourceAction nextResourceAction = new ResourceAction(){

        public Object run() throws Exception {
            AbstractDataProviderIterator.this.dataStoreProvider.open();
            return AbstractDataProviderIterator.this.internalNext();
        }
    };
    private final ResourceAction hasNextResourceAction = new ResourceAction(){

        public Object run() throws Exception {
            boolean value = AbstractDataProviderIterator.this.internalHasNext();
            return value ? Boolean.TRUE : Boolean.FALSE;
        }
    };

    public AbstractDataProviderIterator(DataStoreProvider dataStoreProvider) {
        this.dataStoreProvider = dataStoreProvider;
    }

    public Object next() {
        return this.getResource().execute(this.nextResourceAction);
    }

    public boolean hasNext() {
        Object hasNext = this.getResource().execute(this.hasNextResourceAction);
        return (Boolean)hasNext;
    }

    protected final Resource getResource() {
        return this.getDataStoreProvider().getResource();
    }

    protected DataStoreProvider getDataStoreProvider() {
        return this.dataStoreProvider;
    }

    protected abstract Object internalNext();

    protected abstract boolean internalHasNext();
}

