/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DataServerExplorerPoolEntryImpl
implements DataServerExplorerPoolEntry {
    private static final String PERSISTENCE_DEFINITION_NAME = "DataServerExplorerPoolEntry";
    protected String name;
    protected String description;
    protected DataServerExplorerParameters explorer;

    public DataServerExplorerPoolEntryImpl() {
    }

    public DataServerExplorerPoolEntryImpl(String name, String description, DataServerExplorerParameters explorer) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name can't be null");
        }
        this.name = name;
        this.description = description;
        this.explorer = explorer;
    }

    public String getName() {
        return this.name;
    }

    public void copyTo(DataServerExplorerPoolEntry target) {
        DataServerExplorerPoolEntryImpl other = (DataServerExplorerPoolEntryImpl)target;
        if (StringUtils.isBlank((CharSequence)other.name)) {
            throw new IllegalArgumentException("Name can't be null");
        }
        other.name = this.name;
        other.description = this.description;
        other.explorer = this.explorer;
    }

    public DataServerExplorerParameters getExplorerParameters() {
        return this.explorer;
    }

    public String getDescription() {
        return this.description;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("name", this.name);
        state.set("description", this.description);
        state.set("explorer", (Persistent)this.explorer);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.description = state.getString("description");
        this.name = state.getString("name");
        this.explorer = (DataServerExplorerParameters)state.get("explorer");
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DataServerExplorerPoolEntryImpl.class, PERSISTENCE_DEFINITION_NAME, "DataServerExplorerPoolEntry Persistent definition", null, null);
            definition.addDynFieldString("name").setMandatory(true).setPersistent(true);
            definition.addDynFieldString("description").setMandatory(false).setPersistent(true);
            definition.addDynFieldObject("explorer").setClassOfValue(DataServerExplorerParameters.class).setMandatory(true).setPersistent(true);
        }
    }

    public String getLabel() {
        return this.getName();
    }

    public DataServerExplorerPoolEntry getValue() {
        return this;
    }
}

