/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.util.UnmodifiableBasicSetAdapter;

class JDBCServerExplorerParametersAdapterToStoresRepository
extends AbstractStoresRepository {
    private final DataServerExplorerParameters explorerParams;
    private Map<String, DataStoreParameters> tables;

    public JDBCServerExplorerParametersAdapterToStoresRepository(String name, DataServerExplorerParameters explorerParams) {
        super(name);
        this.explorerParams = explorerParams;
        this.tables = null;
    }

    protected DataStoreParameters getMyParameters(String name) {
        if (this.tables == null) {
            this.loadTablesInfo();
        }
        return this.tables.get(name);
    }

    protected boolean isEmptyMyRepository() {
        if (this.tables == null) {
            this.loadTablesInfo();
        }
        return this.tables.isEmpty();
    }

    protected int getMySize() {
        if (this.tables == null) {
            this.loadTablesInfo();
        }
        return this.tables.size();
    }

    protected UnmodifiableBasicSet<String> getMyKeySet() {
        if (this.tables == null) {
            this.loadTablesInfo();
        }
        return new UnmodifiableBasicSetAdapter(this.tables.keySet());
    }

    private void loadTablesInfo() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            ArrayList<ImmutablePair> theTables = new ArrayList<ImmutablePair>();
            DataServerExplorer explorer = dataManager.openServerExplorer(this.explorerParams.getProviderName(), this.explorerParams);
            for (DataStoreParameters dataStoreParameters : explorer.list()) {
                JDBCStoreParameters dsp = (JDBCStoreParameters)dataStoreParameters;
                theTables.add(new ImmutablePair((Object)dsp.getTable(), (Object)dsp));
            }
            theTables.sort((o1, o2) -> StringUtils.compare((String)((String)o1.getKey()), (String)((String)o2.getKey())));
            this.tables = new LinkedHashMap<String, DataStoreParameters>();
            for (Pair pair : theTables) {
                this.tables.put((String)pair.getKey(), (DataStoreParameters)pair.getValue());
            }
        }
        catch (Exception ex) {
            this.tables = Collections.EMPTY_MAP;
        }
    }
}

