/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl;

import org.gvsig.fmap.dal.coverage.BufferFactory;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.exception.BufferCreationException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.impl.buffer.BufferParamImpl;
import org.gvsig.raster.impl.buffer.RasterBuffer;
import org.gvsig.raster.impl.buffer.RasterMemoryBuffer;
import org.gvsig.raster.impl.buffer.cache.RasterCache;
import org.gvsig.raster.impl.buffer.cache.RasterReadOnlyBuffer;
import org.gvsig.raster.impl.store.QueryableRaster;
import org.gvsig.raster.util.DefaultRasterUtils;

public class BufferFactoryImpl
implements BufferFactory {
    public Buffer createBuffer(BufferParam param) throws BufferCreationException {
        if (param.getAccessType() == 0) {
            if (RasterBuffer.cacheOn) {
                long ms1;
                long sizeDataType = new DefaultRasterUtils().getBytesFromRasterBufType(param.getDataType());
                long size = sizeDataType * (long)param.getWidth() * (long)param.getHeight() * (long)param.getBandCount() / 1024L;
                if (size <= (ms1 = RasterLibrary.cacheSize * 1024L)) {
                    return this.createMemoryBuffer(param);
                }
                return new RasterCache(param.getDataType(), param.getWidth(), param.getHeight(), param.getBandCount());
            }
            return this.createMemoryBuffer(param);
        }
        if (param.getAccessType() == 2) {
            return this.createMemoryBuffer(param);
        }
        if (param.getAccessType() == 1) {
            RasterReadOnlyBuffer rb = new RasterReadOnlyBuffer(param.getDataType(), param.getWidth(), param.getHeight(), param.getBandCount());
            RasterDataStore store = param.getDataStore();
            int[] window = param.getRoWindow();
            this.checkROWindow(window, store);
            try {
                rb.setBufferParams((QueryableRaster)param.getDataStore(), window[0], window[1], window[2], window[3], param.getBandList());
                return rb;
            }
            catch (Exception e) {
                throw new BufferCreationException("error_creating_ro_buffer", (Throwable)e);
            }
        }
        return null;
    }

    private void checkROWindow(int[] window, RasterDataStore store) throws BufferCreationException {
        if (window[0] < 0 || window[1] < 0 || (double)window[2] >= store.getWidth() || (double)window[3] >= store.getHeight() || window[0] >= window[2] || window[1] >= window[3]) {
            throw new BufferCreationException("window_not_valid");
        }
    }

    private Buffer createMemoryBuffer(BufferParam param) {
        return new RasterMemoryBuffer(param.getDataType(), param.getWidth(), param.getHeight(), param.getBandCount(), param.isMalloc());
    }

    public BufferParam createBufferParams(int w, int h, int bandCount, int dataType, boolean malloc) {
        return new BufferParamImpl(w, h, bandCount, dataType, malloc, 0);
    }

    public BufferParam createMemoryBufferParams(int w, int h, int bandCount, int dataType, boolean malloc) {
        return new BufferParamImpl(w, h, bandCount, dataType, malloc, 2);
    }

    public BufferParam createReadOnlyBufferParams(RasterDataStore store, int minx, int miny, int maxx, int maxy, BandList bandList) {
        return new BufferParamImpl(store, new int[]{minx, miny, maxx, maxy}, bandList);
    }
}

