/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;

public class BufferHistogramComputer
implements HistogramComputer {
    private BufferHistogram histogram = null;
    private Buffer buffer = null;
    protected int progressHistogram = 0;
    private double[] limits = null;
    private boolean refresh = false;
    private double scale = 1.0;

    public BufferHistogramComputer(Buffer buffer) {
        this.buffer = buffer;
    }

    public void setScaleHistogram(double scale) {
        this.scale = scale;
    }

    public BufferHistogram getBufferHistogram() throws ProcessInterruptedException, HistogramException {
        if (this.histogram == null || this.refresh) {
            RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
            this.progressHistogram = 0;
            double[][] limits = this.buffer.getAllBandsLimits();
            BufferHistogramImpl hist = new BufferHistogramImpl(this.buffer.getBandCount(), limits[0], limits[1], this.buffer.getDataType());
            for (int iBand = 0; iBand < this.buffer.getBandCount(); ++iBand) {
                for (int row = 0; row < this.buffer.getHeight(); ++row) {
                    switch (this.buffer.getDataType()) {
                        case 0: {
                            int col;
                            for (col = 0; col < this.buffer.getWidth(); ++col) {
                                hist.incrementPxValue(iBand, this.buffer.getElemByte(row, col, iBand));
                            }
                            break;
                        }
                        case 2: {
                            int col;
                            for (col = 0; col < this.buffer.getWidth(); ++col) {
                                hist.incrementPxValue(iBand, this.buffer.getElemShort(row, col, iBand));
                            }
                            break;
                        }
                        case 3: {
                            int col;
                            for (col = 0; col < this.buffer.getWidth(); ++col) {
                                hist.incrementPxValue(iBand, this.buffer.getElemInt(row, col, iBand));
                            }
                            break;
                        }
                        case 4: {
                            int col;
                            for (col = 0; col < this.buffer.getWidth(); ++col) {
                                hist.incrementPxValue(iBand, this.buffer.getElemFloat(row, col, iBand));
                            }
                            break;
                        }
                        case 5: {
                            int col;
                            for (col = 0; col < this.buffer.getWidth(); ++col) {
                                hist.incrementPxValue(iBand, this.buffer.getElemDouble(row, col, iBand));
                            }
                            break;
                        }
                    }
                    if (task.getEvent() != null) {
                        task.manageEvent(task.getEvent());
                    }
                    this.progressHistogram = (iBand * this.buffer.getHeight() + row) * 100 / (this.buffer.getHeight() * this.buffer.getBandCount());
                }
            }
            this.progressHistogram = 100;
            this.histogram = hist;
        }
        return this.histogram;
    }

    public void resetPercent() {
        this.progressHistogram = 0;
    }

    public int getPercent() {
        return this.progressHistogram;
    }

    public double getMinimum() {
        if (this.limits == null) {
            try {
                this.limits = this.buffer.getLimits();
            }
            catch (ProcessInterruptedException e) {
                return 0.0;
            }
        }
        return this.limits[0];
    }

    public double getMaximum() {
        if (this.limits == null) {
            try {
                this.limits = this.buffer.getLimits();
            }
            catch (ProcessInterruptedException e) {
                return 0.0;
            }
        }
        return this.limits[1];
    }

    public void refreshHistogram() {
        this.refresh = true;
    }

    public String getLog() {
        return null;
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean isPausable() {
        return false;
    }

    public void setPercent(int value) {
        this.progressHistogram = value;
    }
}

