/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.AbstractBuffer;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.process.IncrementableTask;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.impl.buffer.BufferHistogramComputer;
import org.gvsig.raster.impl.buffer.BufferInterpolation;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.Visitor;

public abstract class RasterBuffer
extends AbstractBuffer
implements Buffer {
    public static final int INTERPOLATION_PROCESS = 0;
    protected boolean[] cancel = new boolean[1];
    public NoData noDataValue = null;
    protected int progressInterpolation = 0;
    protected boolean canceled = false;
    protected int width;
    protected int height;
    protected int nBands;
    protected int dataType;
    private Rectangle2D dataExtent = null;
    private RasterDataStore store = null;
    public static boolean cacheOn = true;
    public static boolean forceToLoadInCache = false;
    public static boolean forceToLoadInReadOnlyCache = false;
    protected double notValidValue = 0.0;
    private int process = 0;
    private HistogramComputer histogramComputer = null;
    private BufferInterpolation interp = null;

    public RasterDataStore getStore() {
        return this.store;
    }

    public void setStore(RasterDataStore store) {
        this.store = store;
    }

    public abstract void malloc(int var1, int var2, int var3, int var4);

    public int getWidth() {
        return this.width;
    }

    public Rectangle2D getDataExtent() {
        return this.dataExtent;
    }

    public void setDataExtent(Rectangle2D r) {
        this.dataExtent = r;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBandCount() {
        return this.nBands;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDataSize() {
        if (this.dataType == 0) {
            return 1;
        }
        if (this.dataType == 2 | this.dataType == 1) {
            return 2;
        }
        if (this.dataType == 3) {
            return 4;
        }
        if (this.dataType == 4) {
            return 8;
        }
        if (this.dataType == 5) {
            return 16;
        }
        return 0;
    }

    public long sizeof() {
        return this.getDataSize() * this.width * this.height * this.nBands;
    }

    public abstract void replicateBand(int var1, int var2);

    public abstract void switchBands(int[] var1);

    public static String typesToString(int type) {
        switch (type) {
            case -1: {
                return new String("Image");
            }
            case 0: {
                return new String("Byte");
            }
            case 5: {
                return new String("Double");
            }
            case 4: {
                return new String("Float");
            }
            case 3: {
                return new String("Integer");
            }
            case 1: 
            case 2: {
                return new String("Short");
            }
        }
        return null;
    }

    public boolean isInside(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight();
    }

    public NoData getNoDataValue() {
        return this.noDataValue;
    }

    public int getBlockHeight() {
        return RasterLibrary.blockHeight;
    }

    public void setNoDataValue(NoData nd) {
        this.noDataValue = nd;
    }

    public double getNotValidValue() {
        return this.notValidValue;
    }

    public void setNotValidValue(double value) {
        this.notValidValue = value;
    }

    public abstract Buffer cloneBuffer();

    public Buffer getAdjustedWindow(int w, int h, int interpolationMethod) throws ProcessInterruptedException {
        this.getBufferInterpolation();
        if (w == this.getWidth() && h == this.getHeight()) {
            return this;
        }
        Buffer rasterBuf = null;
        switch (interpolationMethod) {
            case 1: {
                rasterBuf = this.interp.adjustRasterNearestNeighbourInterpolation(w, h);
                break;
            }
            case 2: {
                rasterBuf = this.interp.adjustRasterBilinearInterpolation(w, h);
                break;
            }
            case 3: {
                rasterBuf = this.interp.adjustRasterInverseDistanceInterpolation(w, h);
                break;
            }
            case 4: {
                rasterBuf = this.interp.adjustRasterBicubicSplineInterpolation(w, h);
                break;
            }
            case 5: {
                rasterBuf = this.interp.adjustRasterBSplineInterpolation(w, h);
            }
        }
        if (rasterBuf != null) {
            return rasterBuf;
        }
        return this;
    }

    public IncrementableTask getIncrementableTask(int type) {
        switch (type) {
            case 0: {
                return this.getBufferInterpolation();
            }
            case 1: {
                return this.getHistogramComputer();
            }
        }
        return null;
    }

    private BufferInterpolation getBufferInterpolation() {
        if (this.interp == null) {
            this.interp = new BufferInterpolation(this);
        }
        return this.interp;
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogramComputer == null) {
            this.histogramComputer = new BufferHistogramComputer(this);
        }
        return this.histogramComputer;
    }

    public double[] getLimits() throws ProcessInterruptedException {
        double min;
        double max;
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double secondMax = max = Double.NEGATIVE_INFINITY;
        double secondMin = min = Double.MAX_VALUE;
        double value = 0.0;
        switch (this.getDataType()) {
            case 0: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemByte(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemShort(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemInt(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 4: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemFloat(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 5: {
                int i;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemDouble(r, c, i);
                            if (value > max) {
                                if (max != value) {
                                    secondMax = max;
                                }
                                max = value;
                            }
                            if (!(value < min)) continue;
                            if (min != value) {
                                secondMin = min;
                            }
                            min = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
        }
        if (secondMax == Double.NEGATIVE_INFINITY) {
            secondMax = max;
        }
        if (secondMin == Double.MAX_VALUE) {
            secondMin = min;
        }
        double[] values = new double[]{min, max, secondMin, secondMax};
        return values;
    }

    public double[][] getAllBandsLimits() throws ProcessInterruptedException {
        int i;
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        double[] max = new double[this.getBandCount()];
        double[] min = new double[this.getBandCount()];
        double value = 0.0;
        for (i = 0; i < this.getBandCount(); ++i) {
            max[i] = Double.NEGATIVE_INFINITY;
            min[i] = Double.MAX_VALUE;
        }
        switch (this.getDataType()) {
            case 0: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemByte(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 2: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemShort(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 3: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemInt(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 4: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemFloat(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 5: {
                int c;
                int r;
                for (i = 0; i < this.getBandCount(); ++i) {
                    for (r = 0; r < this.getHeight(); ++r) {
                        for (c = 0; c < this.getWidth(); ++c) {
                            value = this.getElemDouble(r, c, i);
                            if (value > max[i]) {
                                max[i] = value;
                            }
                            if (!(value < min[i])) continue;
                            min[i] = value;
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
        }
        double[][] values = new double[2][this.getBandCount()];
        for (int i2 = 0; i2 < this.getBandCount(); ++i2) {
            values[0][i2] = min[i2];
            values[1][i2] = max[i2];
        }
        return values;
    }

    public void addDrawableBands(int[] db) {
    }

    public void resetPercent() {
        switch (this.process) {
            case 0: {
                this.progressInterpolation = 0;
            }
        }
    }

    public int getPercent() {
        switch (this.process) {
            case 0: {
                return this.progressInterpolation;
            }
        }
        return 0;
    }

    public void setProcess(int process) {
        this.process = process;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isFromStore(DataStore store) {
        return store == this.store;
    }

    public void accept(Visitor visitor) throws BaseException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        switch (this.getDataType()) {
            case 0: {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            visitor.visit((Object)this.getElemByte(r, c, i));
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            visitor.visit((Object)this.getElemShort(r, c, i));
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            visitor.visit((Object)this.getElemInt(r, c, i));
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            visitor.visit((Object)Float.valueOf(this.getElemFloat(r, c, i)));
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.getBandCount(); ++i) {
                    for (int r = 0; r < this.getHeight(); ++r) {
                        for (int c = 0; c < this.getWidth(); ++c) {
                            visitor.visit((Object)this.getElemDouble(r, c, i));
                        }
                        if (task.getEvent() == null) continue;
                        task.manageEvent(task.getEvent());
                    }
                }
                break;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.histogramComputer = null;
        this.store = null;
        this.dataExtent = null;
        this.cancel = null;
        this.noDataValue = null;
        super.finalize();
    }
}

