/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Band;
import org.gvsig.raster.impl.buffer.RasterBand;
import org.gvsig.raster.impl.buffer.RasterBuffer;

public class RasterMemoryBuffer
extends RasterBuffer {
    private ByteBand[] byteBuf = null;
    private ShortBand[] shortBuf = null;
    private IntBand[] intBuf = null;
    private FloatBand[] floatBuf = null;
    private DoubleBand[] doubleBuf = null;
    private ByteBand byteNotValid;
    private ShortBand shortNotValid;
    private IntBand intNotValid;
    private FloatBand floatNotValid;
    private DoubleBand doubleNotValid;

    public RasterMemoryBuffer() {
    }

    public boolean isBandSwitchable() {
        return true;
    }

    public RasterMemoryBuffer(int dataType, int width, int height, int bandNr, boolean malloc) {
        if (malloc) {
            this.malloc(dataType, width, height, bandNr);
        } else {
            this.loadVariables(dataType, width, height, bandNr);
        }
    }

    @Override
    public void malloc(int dataType, int width, int height, int bandNr) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            this.dataType = dataType;
                            this.width = width;
                            this.height = height;
                            this.nBands = bandNr;
                            if (dataType != 0) break block5;
                            this.byteBuf = new ByteBand[bandNr];
                            for (int i = 0; i < bandNr; ++i) {
                                this.byteBuf[i] = new ByteBand(height, width, true);
                            }
                            break block6;
                        }
                        if (!(dataType == 2 | dataType == 1)) break block7;
                        this.shortBuf = new ShortBand[bandNr];
                        for (int i = 0; i < bandNr; ++i) {
                            this.shortBuf[i] = new ShortBand(height, width, true);
                        }
                        break block6;
                    }
                    if (dataType != 3) break block8;
                    this.intBuf = new IntBand[bandNr];
                    for (int i = 0; i < bandNr; ++i) {
                        this.intBuf[i] = new IntBand(height, width, true);
                    }
                    break block6;
                }
                if (dataType != 4) break block9;
                this.floatBuf = new FloatBand[bandNr];
                for (int i = 0; i < bandNr; ++i) {
                    this.floatBuf[i] = new FloatBand(height, width, true);
                }
                break block6;
            }
            if (dataType != 5) break block6;
            this.doubleBuf = new DoubleBand[bandNr];
            for (int i = 0; i < bandNr; ++i) {
                this.doubleBuf[i] = new DoubleBand(height, width, true);
            }
        }
    }

    public void mallocOneBand(int dataType, int width, int height, int band) {
        this.dataType = dataType;
        this.width = width;
        this.height = height;
        if (dataType == 0) {
            if (this.byteBuf == null) {
                this.byteBuf = new ByteBand[this.nBands];
            }
            this.byteBuf[band] = new ByteBand(height, width, true);
        } else if (dataType == 2 | dataType == 1) {
            if (this.shortBuf == null) {
                this.shortBuf = new ShortBand[this.nBands];
            }
            this.shortBuf[band] = new ShortBand(height, width, true);
        } else if (dataType == 3) {
            if (this.intBuf == null) {
                this.intBuf = new IntBand[this.nBands];
            }
            this.intBuf[band] = new IntBand(height, width, true);
        } else if (dataType == 4) {
            if (this.floatBuf == null) {
                this.floatBuf = new FloatBand[this.nBands];
            }
            this.floatBuf[band] = new FloatBand(height, width, true);
        } else if (dataType == 5) {
            if (this.doubleBuf == null) {
                this.doubleBuf = new DoubleBand[this.nBands];
            }
            this.doubleBuf[band] = new DoubleBand(height, width, true);
        }
    }

    private void loadVariables(int dataType, int width, int height, int bandNr) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            this.dataType = dataType;
                            this.width = width;
                            this.height = height;
                            this.nBands = bandNr;
                            if (dataType != 0) break block5;
                            this.byteBuf = new ByteBand[bandNr];
                            for (int i = 0; i < bandNr; ++i) {
                                this.byteBuf[i] = new ByteBand(height, 0, true);
                            }
                            break block6;
                        }
                        if (!(dataType == 2 | dataType == 1)) break block7;
                        this.shortBuf = new ShortBand[bandNr];
                        for (int i = 0; i < bandNr; ++i) {
                            this.shortBuf[i] = new ShortBand(height, 0, true);
                        }
                        break block6;
                    }
                    if (dataType != 3) break block8;
                    this.intBuf = new IntBand[bandNr];
                    for (int i = 0; i < bandNr; ++i) {
                        this.intBuf[i] = new IntBand(height, 0, true);
                    }
                    break block6;
                }
                if (dataType != 4) break block9;
                this.floatBuf = new FloatBand[bandNr];
                for (int i = 0; i < bandNr; ++i) {
                    this.floatBuf[i] = new FloatBand(height, 0, true);
                }
                break block6;
            }
            if (dataType != 5) break block6;
            this.doubleBuf = new DoubleBand[bandNr];
            for (int i = 0; i < bandNr; ++i) {
                this.doubleBuf[i] = new DoubleBand(height, 0, true);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getBandCount() {
        return this.nBands;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    @Override
    public int getDataSize() {
        if (this.dataType == 0) {
            return 1;
        }
        if (this.dataType == 2 | this.dataType == 1) {
            return 2;
        }
        if (this.dataType == 3) {
            return 4;
        }
        if (this.dataType == 4) {
            return 8;
        }
        if (this.dataType == 5) {
            return 16;
        }
        return 0;
    }

    @Override
    public long sizeof() {
        return this.getDataSize() * this.width * this.height * this.nBands;
    }

    public byte[][] getLineByte(int line) {
        byte[][] r = new byte[this.nBands][];
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            r[Band2] = (byte[])this.byteBuf[Band2].getLine(line);
        }
        return r;
    }

    public short[][] getLineShort(int line) {
        short[][] r = new short[this.nBands][];
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            r[Band2] = (short[])this.shortBuf[Band2].getLine(line);
        }
        return r;
    }

    public int[][] getLineInt(int line) {
        int[][] r = new int[this.nBands][];
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            r[Band2] = (int[])this.intBuf[Band2].getLine(line);
        }
        return r;
    }

    public float[][] getLineFloat(int line) {
        float[][] r = new float[this.nBands][];
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            r[Band2] = (float[])this.floatBuf[Band2].getLine(line);
        }
        return r;
    }

    public double[][] getLineDouble(int line) {
        double[][] r = new double[this.nBands][];
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            r[Band2] = (double[])this.doubleBuf[Band2].getLine(line);
        }
        return r;
    }

    public void setLineByte(byte[][] data, int line) {
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            this.byteBuf[Band2].setLine(line, data[Band2]);
        }
    }

    public void setLineShort(short[][] data, int line) {
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            this.shortBuf[Band2].setLine(line, data[Band2]);
        }
    }

    public void setLineInt(int[][] data, int line) {
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            this.intBuf[Band2].setLine(line, data[Band2]);
        }
    }

    public void setLineFloat(float[][] data, int line) {
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            this.floatBuf[Band2].setLine(line, data[Band2]);
        }
    }

    public void setLineDouble(double[][] data, int line) {
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            this.doubleBuf[Band2].setLine(line, data[Band2]);
        }
    }

    public byte[] getLineFromBandByte(int line, int band) {
        return (byte[])this.byteBuf[band].getLine(line);
    }

    public short[] getLineFromBandShort(int line, int band) {
        return (short[])this.shortBuf[band].getLine(line);
    }

    public int[] getLineFromBandInt(int line, int band) {
        return (int[])this.intBuf[band].getLine(line);
    }

    public float[] getLineFromBandFloat(int line, int band) {
        return (float[])this.floatBuf[band].getLine(line);
    }

    public double[] getLineFromBandDouble(int line, int band) {
        return (double[])this.doubleBuf[band].getLine(line);
    }

    public void setLineInBandByte(byte[] data, int line, int band) {
        this.byteBuf[band].setLine(line, data);
    }

    public void setLineInBandShort(short[] data, int line, int band) {
        this.shortBuf[band].setLine(line, data);
    }

    public void setLineInBandInt(int[] data, int line, int band) {
        this.intBuf[band].setLine(line, data);
    }

    public void setLineInBandFloat(float[] data, int line, int band) {
        this.floatBuf[band].setLine(line, data);
    }

    public void setLineInBandDouble(double[] data, int line, int band) {
        this.doubleBuf[band].setLine(line, data);
    }

    public byte getElemByte(int line, int col, int band) {
        return this.byteBuf[band].buf[line][col];
    }

    public short getElemShort(int line, int col, int band) {
        return this.shortBuf[band].buf[line][col];
    }

    public int getElemInt(int line, int col, int band) {
        return this.intBuf[band].buf[line][col];
    }

    public float getElemFloat(int line, int col, int band) {
        return this.floatBuf[band].buf[line][col];
    }

    public double getElemDouble(int line, int col, int band) {
        return this.doubleBuf[band].buf[line][col];
    }

    public void setElem(int line, int col, int band, byte data) {
        this.byteBuf[band].buf[line][col] = data;
    }

    public void setElem(int line, int col, int band, short data) {
        this.shortBuf[band].buf[line][col] = data;
    }

    public void setElem(int line, int col, int band, int data) {
        this.intBuf[band].buf[line][col] = data;
    }

    public void setElem(int line, int col, int band, float data) {
        this.floatBuf[band].buf[line][col] = data;
    }

    public void setElem(int line, int col, int band, double data) {
        this.doubleBuf[band].buf[line][col] = data;
    }

    public void getElemByte(int line, int col, byte[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            data[Band2] = this.byteBuf[Band2].buf[line][col];
        }
    }

    public void getElemShort(int line, int col, short[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            data[Band2] = this.shortBuf[Band2].buf[line][col];
        }
    }

    public void getElemInt(int line, int col, int[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            data[Band2] = this.intBuf[Band2].buf[line][col];
        }
    }

    public void getElemFloat(int line, int col, float[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            data[Band2] = this.floatBuf[Band2].buf[line][col];
        }
    }

    public void getElemDouble(int line, int col, double[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            data[Band2] = this.doubleBuf[Band2].buf[line][col];
        }
    }

    public void setElemByte(int line, int col, byte[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            this.byteBuf[Band2].buf[line][col] = data[Band2];
        }
    }

    public void setElemShort(int line, int col, short[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            this.shortBuf[Band2].buf[line][col] = data[Band2];
        }
    }

    public void setElemInt(int line, int col, int[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            this.intBuf[Band2].buf[line][col] = data[Band2];
        }
    }

    public void setElemFloat(int line, int col, float[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            this.floatBuf[Band2].buf[line][col] = data[Band2];
        }
    }

    public void setElemDouble(int line, int col, double[] data) {
        for (int Band2 = 0; Band2 < this.nBands && Band2 < data.length; ++Band2) {
            this.doubleBuf[Band2].buf[line][col] = data[Band2];
        }
    }

    public Band getBand(int band) {
        if (this.dataType == 0) {
            return this.byteBuf[band];
        }
        if (this.dataType == 2 | this.dataType == 1) {
            return this.shortBuf[band];
        }
        if (this.dataType == 3) {
            return this.intBuf[band];
        }
        if (this.dataType == 4) {
            return this.floatBuf[band];
        }
        if (this.dataType == 5) {
            return this.doubleBuf[band];
        }
        return null;
    }

    public Buffer getBandBuffer(int Band2) {
        RasterMemoryBuffer rmb = new RasterMemoryBuffer(this.dataType, this.width, this.height, 1, false);
        if (this.dataType == 0) {
            rmb.byteBuf[0].buf = this.byteBuf[Band2].buf;
        } else if (this.dataType == 2 | this.dataType == 1) {
            rmb.shortBuf[0].buf = this.shortBuf[Band2].buf;
        } else if (this.dataType == 3) {
            rmb.intBuf[0].buf = this.intBuf[Band2].buf;
        } else if (this.dataType == 4) {
            rmb.floatBuf[0].buf = this.floatBuf[Band2].buf;
        } else if (this.dataType == 5) {
            rmb.doubleBuf[0].buf = this.doubleBuf[Band2].buf;
        }
        return rmb;
    }

    public void assign(int band, byte value) {
        for (int line = 0; line < this.height; ++line) {
            for (int col = 0; col < this.width; ++col) {
                this.byteBuf[band].buf[line][col] = value;
            }
        }
    }

    public void assign(int band, short value) {
        for (int line = 0; line < this.height; ++line) {
            for (int col = 0; col < this.width; ++col) {
                this.shortBuf[band].buf[line][col] = value;
            }
        }
    }

    public void assign(int band, int value) {
        for (int line = 0; line < this.height; ++line) {
            for (int col = 0; col < this.width; ++col) {
                this.intBuf[band].buf[line][col] = value;
            }
        }
    }

    public void assign(int band, float value) {
        for (int line = 0; line < this.height; ++line) {
            for (int col = 0; col < this.width; ++col) {
                this.floatBuf[band].buf[line][col] = value;
            }
        }
    }

    public void assign(int band, double value) {
        for (int line = 0; line < this.height; ++line) {
            for (int col = 0; col < this.width; ++col) {
                this.doubleBuf[band].buf[line][col] = value;
            }
        }
    }

    public Band createBand(byte defaultValue) {
        switch (this.getDataType()) {
            case 0: {
                ByteBand bb = new ByteBand(this.width, this.height, false);
                bb.buf = this.createByteBand(this.width, this.height, defaultValue);
                return bb;
            }
            case 2: {
                ShortBand sb = new ShortBand(this.width, this.height, false);
                sb.buf = this.createShortBand(this.width, this.height, defaultValue);
                return sb;
            }
            case 3: {
                IntBand ib = new IntBand(this.width, this.height, false);
                ib.buf = this.createIntBand(this.width, this.height, defaultValue);
                return ib;
            }
            case 4: {
                FloatBand fb = new FloatBand(this.width, this.height, false);
                fb.buf = this.createFloatBand(this.width, this.height, defaultValue);
                return fb;
            }
            case 5: {
                DoubleBand db = new DoubleBand(this.width, this.height, false);
                db.buf = this.createDoubleBand(this.width, this.height, defaultValue);
                return db;
            }
        }
        return null;
    }

    public byte[][] createByteBand(int width, int height, byte defaultValue) {
        byte[][] band = new byte[height][width];
        if (defaultValue != 0) {
            for (int line = 0; line < height; ++line) {
                for (int col = 0; col < width; ++col) {
                    band[line][col] = defaultValue;
                }
            }
        }
        return band;
    }

    public short[][] createShortBand(int width, int height, short defaultValue) {
        short[][] band = new short[height][width];
        if (defaultValue != 0) {
            for (int line = 0; line < height; ++line) {
                for (int col = 0; col < width; ++col) {
                    band[line][col] = defaultValue;
                }
            }
        }
        return band;
    }

    public int[][] createIntBand(int width, int height, int defaultValue) {
        int[][] band = new int[height][width];
        if (defaultValue != 0) {
            for (int line = 0; line < height; ++line) {
                for (int col = 0; col < width; ++col) {
                    band[line][col] = defaultValue;
                }
            }
        }
        return band;
    }

    public float[][] createFloatBand(int width, int height, float defaultValue) {
        float[][] band = new float[height][width];
        if (defaultValue != 0.0f) {
            for (int line = 0; line < height; ++line) {
                for (int col = 0; col < width; ++col) {
                    band[line][col] = defaultValue;
                }
            }
        }
        return band;
    }

    public double[][] createDoubleBand(int width, int height, double defaultValue) {
        double[][] band = new double[height][width];
        if (defaultValue != 0.0) {
            for (int line = 0; line < height; ++line) {
                for (int col = 0; col < width; ++col) {
                    band[line][col] = defaultValue;
                }
            }
        }
        return band;
    }

    private void addBandByte(int pos, Band data) {
        if (pos < 0) {
            return;
        }
        ByteBand[] tmp = null;
        if (pos >= this.byteBuf.length) {
            tmp = new ByteBand[pos + 1];
            for (int Band2 = 0; Band2 < this.byteBuf.length; ++Band2) {
                tmp[Band2] = this.byteBuf[Band2];
            }
            tmp[pos] = (ByteBand)data;
        } else {
            int Band3;
            tmp = new ByteBand[this.byteBuf.length + 1];
            for (Band3 = 0; Band3 < pos; ++Band3) {
                tmp[Band3] = this.byteBuf[Band3];
            }
            tmp[pos] = (ByteBand)data;
            for (Band3 = pos + 1; Band3 <= this.byteBuf.length; ++Band3) {
                tmp[Band3] = this.byteBuf[Band3 - 1];
            }
        }
        this.nBands = tmp.length;
        this.byteBuf = tmp;
    }

    private void addBandShort(int pos, Band data) {
        if (pos < 0) {
            return;
        }
        ShortBand[] tmp = null;
        if (pos >= this.shortBuf.length) {
            tmp = new ShortBand[pos + 1];
            for (int Band2 = 0; Band2 < this.shortBuf.length; ++Band2) {
                tmp[Band2] = this.shortBuf[Band2];
            }
            tmp[pos] = (ShortBand)data;
        } else {
            int Band3;
            tmp = new ShortBand[this.shortBuf.length + 1];
            for (Band3 = 0; Band3 < pos; ++Band3) {
                tmp[Band3] = this.shortBuf[Band3];
            }
            tmp[pos] = (ShortBand)data;
            for (Band3 = pos + 1; Band3 < this.shortBuf.length; ++Band3) {
                tmp[Band3] = this.shortBuf[Band3 - 1];
            }
        }
        this.nBands = tmp.length;
        this.shortBuf = tmp;
    }

    private void addBandInt(int pos, Band data) {
        if (pos < 0) {
            return;
        }
        IntBand[] tmp = null;
        if (pos >= this.intBuf.length) {
            tmp = new IntBand[pos + 1];
            for (int Band2 = 0; Band2 < this.intBuf.length; ++Band2) {
                tmp[Band2] = this.intBuf[Band2];
            }
            tmp[pos] = (IntBand)data;
        } else {
            int Band3;
            tmp = new IntBand[this.intBuf.length + 1];
            for (Band3 = 0; Band3 < pos; ++Band3) {
                tmp[Band3] = this.intBuf[Band3];
            }
            tmp[pos] = (IntBand)data;
            for (Band3 = pos + 1; Band3 < this.intBuf.length; ++Band3) {
                tmp[Band3] = this.intBuf[Band3 - 1];
            }
        }
        this.nBands = tmp.length;
        this.intBuf = tmp;
    }

    private void addBandFloat(int pos, Band data) {
        if (pos < 0) {
            return;
        }
        FloatBand[] tmp = null;
        if (pos >= this.floatBuf.length) {
            tmp = new FloatBand[pos + 1];
            for (int Band2 = 0; Band2 < this.floatBuf.length; ++Band2) {
                tmp[Band2] = this.floatBuf[Band2];
            }
            tmp[pos] = (FloatBand)data;
        } else {
            int Band3;
            tmp = new FloatBand[this.floatBuf.length + 1];
            for (Band3 = 0; Band3 < pos; ++Band3) {
                tmp[Band3] = this.floatBuf[Band3];
            }
            tmp[pos] = (FloatBand)data;
            for (Band3 = pos + 1; Band3 < this.floatBuf.length; ++Band3) {
                tmp[Band3] = this.floatBuf[Band3 - 1];
            }
        }
        this.nBands = tmp.length;
        this.floatBuf = tmp;
    }

    private void addBandDouble(int pos, Band data) {
        if (pos < 0) {
            return;
        }
        DoubleBand[] tmp = null;
        if (pos >= this.doubleBuf.length) {
            tmp = new DoubleBand[pos + 1];
            for (int Band2 = 0; Band2 < this.doubleBuf.length; ++Band2) {
                tmp[Band2] = this.doubleBuf[Band2];
            }
            tmp[pos] = (DoubleBand)data;
        } else {
            int Band3;
            tmp = new DoubleBand[this.doubleBuf.length + 1];
            for (Band3 = 0; Band3 < pos; ++Band3) {
                tmp[Band3] = this.doubleBuf[Band3];
            }
            tmp[pos] = (DoubleBand)data;
            for (Band3 = pos + 1; Band3 < this.doubleBuf.length; ++Band3) {
                tmp[Band3] = this.doubleBuf[Band3 - 1];
            }
        }
        this.nBands = tmp.length;
        this.doubleBuf = tmp;
    }

    @Override
    public void replicateBand(int orig, int dest) {
        switch (this.getDataType()) {
            case 0: {
                if (orig >= this.byteBuf.length) {
                    return;
                }
                this.addBandByte(dest, this.getBand(orig));
                break;
            }
            case 2: {
                if (orig >= this.shortBuf.length) {
                    return;
                }
                this.addBandShort(dest, this.getBand(orig));
                break;
            }
            case 3: {
                if (orig >= this.intBuf.length) {
                    return;
                }
                this.addBandInt(dest, this.getBand(orig));
                break;
            }
            case 4: {
                if (orig >= this.floatBuf.length) {
                    return;
                }
                this.addBandFloat(dest, this.getBand(orig));
                break;
            }
            case 5: {
                if (orig >= this.doubleBuf.length) {
                    return;
                }
                this.addBandDouble(dest, this.getBand(orig));
            }
        }
    }

    @Override
    public void switchBands(int[] bandPosition) {
        if (bandPosition.length != this.getBandCount()) {
            return;
        }
        for (int i = 0; i < bandPosition.length; ++i) {
            if (bandPosition[i] < bandPosition.length && bandPosition[i] >= 0) continue;
            return;
        }
        switch (this.getDataType()) {
            case 0: {
                ByteBand[] bufB = new ByteBand[this.getBandCount()];
                for (int i = 0; i < bandPosition.length; ++i) {
                    bufB[i] = this.byteBuf[bandPosition[i]];
                }
                this.byteBuf = bufB;
                break;
            }
            case 5: {
                DoubleBand[] bufD = new DoubleBand[this.getBandCount()];
                for (int i = 0; i < bandPosition.length; ++i) {
                    bufD[i] = this.doubleBuf[bandPosition[i]];
                }
                this.doubleBuf = bufD;
                break;
            }
            case 4: {
                FloatBand[] bufF = new FloatBand[this.getBandCount()];
                for (int i = 0; i < bandPosition.length; ++i) {
                    bufF[i] = this.floatBuf[bandPosition[i]];
                }
                this.floatBuf = bufF;
                break;
            }
            case 3: {
                IntBand[] bufI = new IntBand[this.getBandCount()];
                for (int i = 0; i < bandPosition.length; ++i) {
                    bufI[i] = this.intBuf[bandPosition[i]];
                }
                this.intBuf = bufI;
                break;
            }
            case 1: 
            case 2: {
                ShortBand[] bufS = new ShortBand[this.getBandCount()];
                for (int i = 0; i < bandPosition.length; ++i) {
                    bufS[i] = this.shortBuf[bandPosition[i]];
                }
                this.shortBuf = bufS;
            }
        }
    }

    public void copyBand(int nBand, Band band) {
        switch (band.getDataType()) {
            case 0: {
                this.byteBuf[nBand] = new ByteBand(band.getHeight(), band.getWidth(), true);
                byte[][] bb = ((ByteBand)band).buf;
                for (int i = 0; i < bb.length; ++i) {
                    for (int j = 0; j < bb[i].length; ++j) {
                        this.byteBuf[nBand].buf[i][j] = bb[i][j];
                    }
                }
                break;
            }
            case 5: {
                this.doubleBuf[nBand] = new DoubleBand(band.getHeight(), band.getWidth(), true);
                double[][] db = ((DoubleBand)band).buf;
                for (int i = 0; i < db.length; ++i) {
                    for (int j = 0; j < db[i].length; ++j) {
                        this.doubleBuf[nBand].buf[i][j] = db[i][j];
                    }
                }
                break;
            }
            case 4: {
                this.floatBuf[nBand] = new FloatBand(band.getHeight(), band.getWidth(), true);
                float[][] fb = ((FloatBand)band).buf;
                for (int i = 0; i < fb.length; ++i) {
                    for (int j = 0; j < fb[i].length; ++j) {
                        this.floatBuf[nBand].buf[i][j] = fb[i][j];
                    }
                }
                break;
            }
            case 3: {
                this.intBuf[nBand] = new IntBand(band.getHeight(), band.getWidth(), true);
                int[][] ib = ((IntBand)band).buf;
                for (int i = 0; i < ib.length; ++i) {
                    for (int j = 0; j < ib[i].length; ++j) {
                        this.intBuf[nBand].buf[i][j] = ib[i][j];
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                this.shortBuf[nBand] = new ShortBand(band.getHeight(), band.getWidth(), true);
                short[][] sb = ((ShortBand)band).buf;
                for (int i = 0; i < sb.length; ++i) {
                    for (int j = 0; j < sb[i].length; ++j) {
                        this.shortBuf[nBand].buf[i][j] = sb[i][j];
                    }
                }
                break;
            }
        }
    }

    public void assignBand(int nBand, Band band) {
        switch (this.getDataType()) {
            case 0: {
                this.byteBuf[nBand] = (ByteBand)band;
                break;
            }
            case 5: {
                this.doubleBuf[nBand] = (DoubleBand)band;
                break;
            }
            case 4: {
                this.floatBuf[nBand] = (FloatBand)band;
                break;
            }
            case 3: {
                this.intBuf[nBand] = (IntBand)band;
                break;
            }
            case 1: 
            case 2: {
                this.shortBuf[nBand] = (ShortBand)band;
            }
        }
    }

    @Override
    public Buffer cloneBuffer() {
        boolean malloc = false;
        if (this.byteBuf != null || this.shortBuf != null || this.intBuf != null || this.floatBuf != null || this.doubleBuf != null) {
            malloc = true;
        }
        RasterMemoryBuffer rmb = new RasterMemoryBuffer(this.dataType, this.width, this.height, this.nBands, malloc);
        for (int Band2 = 0; Band2 < this.nBands; ++Band2) {
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    if (this.byteBuf != null) {
                        rmb.setElem(row, col, Band2, this.getElemByte(row, col, Band2));
                    }
                    if (this.shortBuf != null) {
                        rmb.setElem(row, col, Band2, this.getElemShort(row, col, Band2));
                    }
                    if (this.intBuf != null) {
                        rmb.setElem(row, col, Band2, this.getElemInt(row, col, Band2));
                    }
                    if (this.floatBuf != null) {
                        rmb.setElem(row, col, Band2, this.getElemFloat(row, col, Band2));
                    }
                    if (this.doubleBuf == null) continue;
                    rmb.setElem(row, col, Band2, this.getElemDouble(row, col, Band2));
                }
            }
        }
        return rmb;
    }

    public void interchangeBands(int band1, int band2) {
        switch (this.getDataType()) {
            case 0: {
                ByteBand auxByte = this.byteBuf[band1];
                this.byteBuf[band1] = this.byteBuf[band2];
                this.byteBuf[band2] = auxByte;
                break;
            }
            case 5: {
                DoubleBand auxDouble = this.doubleBuf[band1];
                this.doubleBuf[band1] = this.doubleBuf[band2];
                this.doubleBuf[band2] = auxDouble;
                break;
            }
            case 4: {
                FloatBand auxFloat = this.floatBuf[band1];
                this.floatBuf[band1] = this.floatBuf[band2];
                this.floatBuf[band2] = auxFloat;
                break;
            }
            case 3: {
                IntBand auxInt = this.intBuf[band1];
                this.intBuf[band1] = this.intBuf[band2];
                this.intBuf[band2] = auxInt;
                break;
            }
            case 1: 
            case 2: {
                ShortBand auxShort = this.shortBuf[band1];
                this.shortBuf[band1] = this.shortBuf[band2];
                this.shortBuf[band2] = auxShort;
            }
        }
    }

    public static String typesToString(int type) {
        switch (type) {
            case -1: {
                return new String("Image");
            }
            case 0: {
                return new String("Byte");
            }
            case 5: {
                return new String("Double");
            }
            case 4: {
                return new String("Float");
            }
            case 3: {
                return new String("Integer");
            }
            case 1: 
            case 2: {
                return new String("Short");
            }
        }
        return null;
    }

    public void assignBandToNotValid(int Band2) {
        switch (this.getDataType()) {
            case 0: {
                if (this.byteNotValid == null) {
                    this.byteNotValid = new ByteBand(this.getHeight(), this.getWidth(), true);
                    for (int i = 0; i < this.getWidth(); ++i) {
                        for (int j = 0; j < this.getHeight(); ++j) {
                            this.byteNotValid.buf[j][i] = (byte)this.getNotValidValue();
                        }
                    }
                }
                this.byteBuf[Band2] = this.byteNotValid;
                break;
            }
            case 2: {
                if (this.shortNotValid == null) {
                    this.shortNotValid = new ShortBand(this.getHeight(), this.getWidth(), true);
                    for (int i = 0; i < this.getWidth(); ++i) {
                        for (int j = 0; j < this.getHeight(); ++j) {
                            this.shortNotValid.buf[j][i] = (short)this.getNotValidValue();
                        }
                    }
                }
                this.shortBuf[Band2] = this.shortNotValid;
                break;
            }
            case 3: {
                if (this.intNotValid == null) {
                    this.intNotValid = new IntBand(this.getHeight(), this.getWidth(), true);
                    for (int i = 0; i < this.getWidth(); ++i) {
                        for (int j = 0; j < this.getHeight(); ++j) {
                            this.intNotValid.buf[j][i] = (int)this.getNotValidValue();
                        }
                    }
                }
                this.intBuf[Band2] = this.intNotValid;
                break;
            }
            case 4: {
                if (this.floatNotValid == null) {
                    this.floatNotValid = new FloatBand(this.getHeight(), this.getWidth(), true);
                    for (int i = 0; i < this.getWidth(); ++i) {
                        for (int j = 0; j < this.getHeight(); ++j) {
                            this.floatNotValid.buf[j][i] = (float)this.getNotValidValue();
                        }
                    }
                }
                this.floatBuf[Band2] = this.floatNotValid;
                break;
            }
            case 5: {
                if (this.doubleNotValid == null) {
                    this.doubleNotValid = new DoubleBand(this.getHeight(), this.getWidth(), true);
                    for (int i = 0; i < this.getWidth(); ++i) {
                        for (int j = 0; j < this.getHeight(); ++j) {
                            this.doubleNotValid.buf[j][i] = this.getNotValidValue();
                        }
                    }
                }
                this.doubleBuf[Band2] = this.doubleNotValid;
            }
        }
    }

    public boolean isReadOnlyBuffer() {
        return false;
    }

    public void dispose() {
        int i;
        if (this.byteBuf != null) {
            for (i = 0; i < this.byteBuf.length; ++i) {
                this.byteBuf[i].dispose();
                this.byteBuf[i] = null;
            }
            this.byteBuf = null;
        }
        if (this.shortBuf != null) {
            for (i = 0; i < this.shortBuf.length; ++i) {
                this.shortBuf[i].dispose();
                this.shortBuf[i] = null;
            }
            this.shortBuf = null;
        }
        if (this.intBuf != null) {
            for (i = 0; i < this.intBuf.length; ++i) {
                this.intBuf[i].dispose();
                this.intBuf[i] = null;
            }
            this.intBuf = null;
        }
        if (this.floatBuf != null) {
            for (i = 0; i < this.floatBuf.length; ++i) {
                this.floatBuf[i].dispose();
                this.floatBuf[i] = null;
            }
            this.floatBuf = null;
        }
        if (this.doubleBuf != null) {
            for (i = 0; i < this.doubleBuf.length; ++i) {
                this.doubleBuf[i].dispose();
                this.doubleBuf[i] = null;
            }
            this.doubleBuf = null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        int i;
        if (this.byteBuf != null) {
            for (i = 0; i < this.byteBuf.length; ++i) {
                this.byteBuf[i] = null;
            }
            this.byteBuf = null;
        }
        if (this.shortBuf != null) {
            for (i = 0; i < this.shortBuf.length; ++i) {
                this.shortBuf[i] = null;
            }
            this.shortBuf = null;
        }
        if (this.intBuf != null) {
            for (i = 0; i < this.intBuf.length; ++i) {
                this.intBuf[i] = null;
            }
            this.intBuf = null;
        }
        if (this.floatBuf != null) {
            for (i = 0; i < this.floatBuf.length; ++i) {
                this.floatBuf[i] = null;
            }
            this.floatBuf = null;
        }
        if (this.doubleBuf != null) {
            for (i = 0; i < this.doubleBuf.length; ++i) {
                this.doubleBuf[i] = null;
            }
            this.doubleBuf = null;
        }
        super.finalize();
    }

    public class DoubleBand
    extends RasterBand {
        public double[][] buf;

        public DoubleBand(int height, int width, boolean malloc) {
            super(height, width);
            this.buf = null;
            if (malloc) {
                this.buf = new double[height][width];
            }
        }

        public Object getLine(int line) {
            return this.buf[line];
        }

        public void setLine(int line, Object value) {
            this.buf[line] = (double[])value;
        }

        public Object getBuf() {
            return this.buf;
        }

        public void dispose() {
            this.buf = null;
        }

        protected void finalize() throws Throwable {
            this.buf = null;
            super.finalize();
        }
    }

    public class FloatBand
    extends RasterBand {
        public float[][] buf;

        public FloatBand(int height, int width, boolean malloc) {
            super(height, width);
            this.buf = null;
            if (malloc) {
                this.buf = new float[height][width];
            }
        }

        public Object getLine(int line) {
            return this.buf[line];
        }

        public void setLine(int line, Object value) {
            this.buf[line] = (float[])value;
        }

        public Object getBuf() {
            return this.buf;
        }

        public void dispose() {
            this.buf = null;
        }

        protected void finalize() throws Throwable {
            this.buf = null;
            super.finalize();
        }
    }

    public class IntBand
    extends RasterBand {
        public int[][] buf;

        public IntBand(int height, int width, boolean malloc) {
            super(height, width);
            this.buf = null;
            if (malloc) {
                this.buf = new int[height][width];
            }
        }

        public Object getLine(int line) {
            return this.buf[line];
        }

        public void setLine(int line, Object value) {
            this.buf[line] = (int[])value;
        }

        public Object getBuf() {
            return this.buf;
        }

        public void dispose() {
            this.buf = null;
        }

        protected void finalize() throws Throwable {
            this.buf = null;
            super.finalize();
        }
    }

    public class ShortBand
    extends RasterBand {
        public short[][] buf;

        public ShortBand(int height, int width, boolean malloc) {
            super(height, width);
            this.buf = null;
            if (malloc) {
                this.buf = new short[height][width];
            }
        }

        public Object getLine(int line) {
            return this.buf[line];
        }

        public void setLine(int line, Object value) {
            this.buf[line] = (short[])value;
        }

        public Object getBuf() {
            return this.buf;
        }

        public void dispose() {
            this.buf = null;
        }

        protected void finalize() throws Throwable {
            this.buf = null;
            super.finalize();
        }
    }

    public class ByteBand
    extends RasterBand {
        public byte[][] buf;

        public ByteBand(int height, int width, boolean malloc) {
            super(height, width);
            this.buf = null;
            if (malloc) {
                this.buf = new byte[height][width];
            }
        }

        public Object getLine(int line) {
            return this.buf[line];
        }

        public void setLine(int line, Object value) {
            this.buf[line] = (byte[])value;
        }

        public Object getBuf() {
            return this.buf;
        }

        public void dispose() {
            this.buf = null;
        }

        protected void finalize() throws Throwable {
            this.buf = null;
            super.finalize();
        }
    }
}

