/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.raster.impl.buffer.cache.CacheStruct;
import org.gvsig.raster.impl.buffer.cache.HddPage;
import org.gvsig.raster.impl.buffer.cache.ICacheDataSource;
import org.gvsig.raster.impl.buffer.cache.PageBuffer;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;

public class Cache {
    private boolean[] cacheada = null;
    private int numberInAccessPage = -1;
    private PageBuffer accessPage = null;
    private PageBuffer[] page = null;
    private int[] pageNumberInCache = null;
    private CacheStruct cacheStruct = null;
    private int[][] lastAccess = null;
    private boolean[] modified = null;
    private HddPage[] hddPage = null;

    public Cache(int nBands, int dataType, int dataSourceWidth, int dataSourceHeight, Object driverParam) throws FileNotFoundException, NotSupportedExtensionException, RasterDriverException {
        if (driverParam instanceof String) {
            File file = new File((String)driverParam);
            if (!file.exists()) {
                throw new FileNotFoundException("I can't make read only cache structure.");
            }
        } else {
            return;
        }
        this.init(nBands, dataType, dataSourceWidth, dataSourceHeight);
        this.hddPage = new HddPage[this.cacheStruct.getNTotalPags()];
        AbstractRasterProvider provider = AbstractRasterProvider.singleDatasetInstance(null, (String)driverParam);
        Extent[] extentList = this.calcExtentPages(provider, this.hddPage.length);
        for (int iPage = 0; iPage < this.hddPage.length; ++iPage) {
            this.hddPage[iPage] = new HddPage(iPage, provider, extentList[iPage]);
        }
        for (int i = 0; i < this.cacheStruct.getNPags(); ++i) {
            this.page[i] = new PageBuffer(dataType, dataSourceWidth, this.cacheStruct.getHPag(), nBands, true, i);
            this.page[i].setHddPages(this.hddPage);
        }
    }

    private Extent[] calcExtentPages(RasterProvider provider, int nPages) {
        Extent datasetExtent = provider.getExtent();
        double h = (double)this.cacheStruct.getHPag() * (provider.getExtent().height() / provider.getHeight());
        Extent[] ext = new Extent[nPages];
        double minX = datasetExtent.getMin().getX();
        double maxX = datasetExtent.getMax().getX();
        double maxY = datasetExtent.getMax().getY();
        double minY = maxY - h;
        for (int i = 0; i < ext.length; ++i) {
            ext[0] = new ExtentImpl(minX, maxY, maxX, minY);
            maxY = minY;
            minY -= h;
        }
        return ext;
    }

    public Cache(int nBands, int dataType, int dataSourceWidth, int dataSourceHeight) {
        this.init(nBands, dataType, dataSourceWidth, dataSourceHeight);
        this.hddPage = new HddPage[this.cacheStruct.getNTotalPags()];
        for (int iPage = 0; iPage < this.hddPage.length; ++iPage) {
            this.hddPage[iPage] = new HddPage(iPage, this.getNBands());
        }
        for (int i = 0; i < this.cacheStruct.getNPags(); ++i) {
            this.page[i] = new PageBuffer(dataType, dataSourceWidth, this.cacheStruct.getHPag(), nBands, true, i);
            this.page[i].setHddPages(this.hddPage);
        }
    }

    public Cache(CacheStruct cacheStruct, int dataSourceWidth) {
        this.cacheStruct = cacheStruct;
        this.lastAccess = new int[cacheStruct.getNGroups()][cacheStruct.getPagsPerGroup()];
        this.page = new PageBuffer[cacheStruct.getNPags()];
        this.pageNumberInCache = new int[cacheStruct.getNPags()];
        this.modified = new boolean[cacheStruct.getNPags()];
        this.cacheada = new boolean[cacheStruct.getNTotalPags()];
        this.hddPage = new HddPage[cacheStruct.getNTotalPags()];
        for (int iPage = 0; iPage < this.hddPage.length; ++iPage) {
            this.hddPage[iPage] = new HddPage(iPage, this.getNBands());
        }
        for (int i = 0; i < cacheStruct.getNPags(); ++i) {
            this.page[i] = new PageBuffer(cacheStruct.getDataType(), dataSourceWidth, cacheStruct.getHPag(), cacheStruct.getNBands(), true, i);
            this.page[i].setHddPages(this.hddPage);
        }
        this.initStructs();
    }

    private void init(int nBands, int dataType, int dataSourceWidth, int dataSourceHeight) {
        this.cacheStruct = new CacheStruct(nBands, dataType, dataSourceWidth, dataSourceHeight);
        this.lastAccess = new int[this.cacheStruct.getNGroups()][this.cacheStruct.getPagsPerGroup()];
        this.page = new PageBuffer[this.cacheStruct.getNPags()];
        this.pageNumberInCache = new int[this.cacheStruct.getNPags()];
        this.modified = new boolean[this.cacheStruct.getNPags()];
        this.cacheada = new boolean[this.cacheStruct.getNTotalPags()];
        this.initStructs();
    }

    private void initStructs() {
        int i;
        for (i = 0; i < this.cacheStruct.getNGroups(); ++i) {
            for (int j = 0; j < this.cacheStruct.getPagsPerGroup(); ++j) {
                this.lastAccess[i][j] = -1;
            }
        }
        for (i = 0; i < this.cacheada.length; ++i) {
            this.cacheada[i] = false;
        }
        for (i = 0; i < this.cacheStruct.getNPags(); ++i) {
            this.pageNumberInCache[i] = -1;
            this.modified[i] = false;
        }
    }

    public void clearCache(int nBands) throws IOException {
        if (this.hddPage == null) {
            return;
        }
        for (int i = 0; i < this.hddPage.length; ++i) {
            this.hddPage[i].deletePage(nBands);
        }
    }

    public int getBitsPag() {
        return this.cacheStruct.getBitsPag();
    }

    public int getHPag() {
        return this.cacheStruct.getHPag();
    }

    public boolean isInCache(int nPag) {
        if (nPag < 0 || nPag >= this.cacheada.length) {
            return false;
        }
        return this.cacheada[nPag];
    }

    public void setPageAsLoadInCache(int nPag) {
        if (nPag < 0 || nPag >= this.cacheada.length) {
            return;
        }
        this.cacheada[nPag] = true;
    }

    public void setPageAsNotLoadInCache(int nPag) {
        if (nPag < 0 || nPag >= this.cacheada.length) {
            return;
        }
        this.cacheada[nPag] = false;
    }

    public int getRasterPageNumberInPosition(int nCachePage) {
        return this.pageNumberInCache[nCachePage];
    }

    public int getRasterPageNumberInPosition(int group, int posInGroup) {
        return this.pageNumberInCache[group * this.getPagsPerGroup() + posInGroup];
    }

    public void setRasterPageNumberInPosition(int nCachePage, int nRasterPage) {
        this.pageNumberInCache[nCachePage] = nRasterPage;
    }

    public void setRasterPageNumberInPosition(int group, int posInGroup, int nRasterPage) {
        this.pageNumberInCache[group * this.getPagsPerGroup() + posInGroup] = nRasterPage;
    }

    public int getNumberCachePageFromNumberRasterPage(int pag) {
        int group = pag % this.getNGroups();
        for (int i = 0; i < this.getPagsPerGroup(); ++i) {
            if (this.pageNumberInCache[group + i] != pag) continue;
            return group * this.getPagsPerGroup() + i;
        }
        return -1;
    }

    public int[] getNumberGroupFromNumberRasterPage(int pag) {
        int group = pag % this.getNGroups();
        for (int i = 0; i < this.getPagsPerGroup(); ++i) {
            if (this.pageNumberInCache[group * this.getPagsPerGroup() + i] != pag) continue;
            return new int[]{group, i};
        }
        return null;
    }

    public int[][] getLastAccess() {
        return this.lastAccess;
    }

    public void setZeroInLastAccess(int group, int posInGroup) {
        this.lastAccess[group][posInGroup] = 0;
    }

    public int getNumberInAccessPage() {
        return this.numberInAccessPage;
    }

    public int getPagsPerGroup() {
        return this.cacheStruct.getPagsPerGroup();
    }

    public PageBuffer getPageBufferFromNumberCachePage(int pag) {
        return this.page[pag];
    }

    public PageBuffer getPageBufferFromNumberRasterPage(int pag) {
        int group = pag % this.getNGroups();
        for (int i = 0; i < this.getPagsPerGroup(); ++i) {
            if (this.pageNumberInCache[group * this.getPagsPerGroup() + i] != pag) continue;
            return this.page[group * this.getPagsPerGroup() + i];
        }
        return null;
    }

    public PageBuffer getPageBuffer(int group, int posInGroup) {
        return this.page[group * this.getPagsPerGroup() + posInGroup];
    }

    public PageBuffer getAccessPage() {
        return this.accessPage;
    }

    public void setAccessPage(PageBuffer pb, int pagNumber) {
        this.accessPage = pb;
        this.numberInAccessPage = pagNumber;
    }

    public boolean isModified(int nCachePag) {
        return this.modified[nCachePag];
    }

    public boolean isModified(int group, int posInGroup) {
        return this.modified[group * this.getPagsPerGroup() + posInGroup];
    }

    public void setModify(int nCachePag) {
        this.modified[nCachePag] = true;
    }

    public void setModify(int group, int posInGroup) {
        this.modified[group * this.getPagsPerGroup() + posInGroup] = true;
    }

    public void unsetModify(int nCachePag) {
        this.modified[nCachePag] = false;
    }

    public void unsetModify(int group, int posInGroup) {
        this.modified[group * this.getPagsPerGroup() + posInGroup] = false;
    }

    public int getNPags() {
        return this.cacheStruct.getNPags();
    }

    public int getNBands() {
        return this.cacheStruct.getNBands();
    }

    public CacheStruct getCacheStruct() {
        return this.cacheStruct;
    }

    public void setCacheStruct(CacheStruct cacheStruct) {
        this.cacheStruct = cacheStruct;
    }

    public int getNGroups() {
        return this.cacheStruct.getNGroups();
    }

    public int getNTotalPags() {
        return this.cacheStruct.getNTotalPags();
    }

    public int[] getPageNumberInCache() {
        return this.pageNumberInCache;
    }

    public int getOffset() {
        return this.cacheStruct.getOffset();
    }

    public int convertPageInGroupToPageInCache(int group, int pageInGroup) {
        return group * this.cacheStruct.getPagsPerGroup() + pageInGroup;
    }

    public int updateLastAccess(int group) {
        int max = Integer.MIN_VALUE;
        int posMax = 0;
        for (int i = 0; i < this.getPagsPerGroup(); ++i) {
            if (this.getLastAccess()[group][i] >= 0) {
                int[] nArray = this.getLastAccess()[group];
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
            if (this.getLastAccess()[group][i] <= max) continue;
            max = this.getLastAccess()[group][i];
            posMax = i;
        }
        return posMax;
    }

    public int posInGroupPagToReplace(int group) {
        int max = Integer.MIN_VALUE;
        int posMax = 0;
        for (int i = 0; i < this.getPagsPerGroup(); ++i) {
            if (this.getLastAccess()[group][i] <= max) continue;
            max = this.getLastAccess()[group][i];
            posMax = i;
        }
        return posMax;
    }

    public void loadPage(int group, int posInGroupPageToReplace, int nPag) {
        this.page[group * this.getPagsPerGroup() + posInGroupPageToReplace].loadPage(nPag);
    }

    public void savePage(int group, int posInGroupPageToReplace, int nPag) throws IOException {
        this.page[group * this.getPagsPerGroup() + posInGroupPageToReplace].savePage(nPag);
    }

    public void resetCache() throws IOException {
        for (int iCachePage = 0; iCachePage < this.page.length; ++iCachePage) {
            if (!this.modified[iCachePage]) continue;
            this.page[iCachePage].savePage(this.getRasterPageNumberInPosition(iCachePage));
        }
        this.initStructs();
    }

    public void deleteBand(int nBand) throws IOException {
        this.resetCache();
        for (int iPage = 0; iPage < this.hddPage.length; ++iPage) {
            this.hddPage[iPage].deleteBand(nBand);
        }
    }

    public void assignBand(int nBand, ICacheDataSource[] cacheDataSource) throws IOException {
        this.resetCache();
        for (int iPage = 0; iPage < this.hddPage.length; ++iPage) {
            this.hddPage[iPage].assignBand(nBand, cacheDataSource[iPage]);
        }
    }

    public ICacheDataSource getHddPage(int nPage, int nBand) {
        return this.hddPage[nPage].getBandDataSource(nBand);
    }

    public boolean anyPageModified() {
        for (int iPage = 0; iPage < this.modified.length; ++iPage) {
            if (!this.modified[iPage]) continue;
            return true;
        }
        return false;
    }

    public void show() {
        int i;
        this.cacheStruct.show();
        System.out.println("Cacheada:");
        for (i = 0; i < this.cacheada.length; ++i) {
            System.out.print(i + "=" + this.cacheada[i] + " ");
        }
        System.out.println();
        System.out.println("LastAccess:");
        for (i = 0; i < this.cacheStruct.getNGroups(); ++i) {
            System.out.println("Grupo " + i + ":");
            for (int j = 0; j < this.cacheStruct.getPagsPerGroup(); ++j) {
                System.out.println("elem " + j + " : " + "Page " + this.pageNumberInCache[i * this.cacheStruct.getPagsPerGroup() + j] + " : " + this.lastAccess[i][j]);
            }
        }
    }
}

