/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.DataStructFactory;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.impl.datastruct.DefaultNoData;
import org.gvsig.raster.impl.datastruct.DefaultViewPortData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.datastruct.GeoPointImpl;
import org.gvsig.raster.impl.datastruct.TransparencyRangeImpl;
import org.gvsig.raster.impl.datastruct.persistence.DefaultColorTableLibrary;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;

public class DefaultDataStructFactory
implements DataStructFactory {
    public TransparencyRange createTransparencyRange() {
        return new TransparencyRangeImpl();
    }

    public Transparency createTransparency(int nBands) {
        return new DataStoreTransparency(new DataStoreColorInterpretation(nBands));
    }

    public ColorTableLibrary getColorTableLibrary() {
        return DefaultColorTableLibrary.getInstance();
    }

    public Extent createExtent(Point2D ul, Point2D lr) {
        return new ExtentImpl(ul, lr);
    }

    public Extent createExtent(Point2D ul, Point2D lr, Point2D ur, Point2D ll) {
        return new ExtentImpl(ul, lr, ur, ll);
    }

    public Extent createExtent(double x1, double y1, double x2, double y2) {
        return new ExtentImpl(x1, y1, x2, y2);
    }

    public Extent createExtent(Rectangle2D r) {
        return new ExtentImpl(r);
    }

    public Extent createExtent() {
        return new ExtentImpl();
    }

    public NoData createNoData(Number noData, Number nativeNoData, String fileName, int bandCount) {
        return new DefaultNoData(noData, nativeNoData, fileName, bandCount);
    }

    public NoData createNoData(Number noData, Number nativeNoData, String fileName) {
        return new DefaultNoData(noData, nativeNoData, fileName);
    }

    public NoData createDefaultNoData(int bandCount, int dataType) {
        switch (dataType) {
            case 0: {
                return new DefaultNoData(new Byte(RasterLibrary.defaultByteNoDataValue), new Byte(RasterLibrary.defaultByteNoDataValue), null);
            }
            case 2: {
                return new DefaultNoData(new Short(RasterLibrary.defaultShortNoDataValue), new Short(RasterLibrary.defaultShortNoDataValue), null);
            }
            case 3: {
                return new DefaultNoData(new Integer(RasterLibrary.defaultIntegerNoDataValue), new Integer(RasterLibrary.defaultIntegerNoDataValue), null);
            }
            case 4: {
                return new DefaultNoData(new Float(RasterLibrary.defaultFloatNoDataValue), new Float(RasterLibrary.defaultFloatNoDataValue), null);
            }
            case 5: {
                return new DefaultNoData(new Double(RasterLibrary.defaultDoubleNoDataValue), new Double(RasterLibrary.defaultDoubleNoDataValue), null);
            }
        }
        return null;
    }

    public RasterDataStore createDataStore() {
        return new DefaultRasterStore();
    }

    public GeoPoint createGeoPoint() {
        return new GeoPointImpl();
    }

    public GeoPoint createGeoPoint(Point2D p, Point2D m) {
        return new GeoPointImpl(p, m);
    }

    public ColorInterpretation createColorInterpretation(String[] colorInterp) {
        return new DataStoreColorInterpretation(colorInterp);
    }

    public ColorInterpretation createColorInterpretation(String colorInterpretationConstant) {
        return new DataStoreColorInterpretation(colorInterpretationConstant);
    }

    public ViewPortData createViewPortData(IProjection proj, Extent extent, Dimension2D size) {
        return new DefaultViewPortData(proj, extent, size);
    }

    public ViewPortData createViewPortData() {
        return new DefaultViewPortData();
    }
}

