/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct.persistence;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.datastruct.ColorItemImpl;
import org.gvsig.raster.impl.datastruct.legend.RasterLegendIO;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultColorTableLibrary
implements ColorTableLibrary {
    private static DefaultColorTableLibrary instance = null;

    public static ColorTableLibrary getInstance() {
        if (instance == null) {
            instance = new DefaultColorTableLibrary();
        }
        return instance;
    }

    public String[] getFormats() {
        return RasterLegendIO.formats;
    }

    public ColorItem createColorItem() {
        return new ColorItemImpl();
    }

    public ColorTable createColorTable() {
        return new DataStoreColorTable();
    }

    private ArrayList<String> getPaletteFileListDisc(String palettesBasePath) throws FilePaletteException {
        this.updateVersion(palettesBasePath);
        File paletteFiles = new File(palettesBasePath);
        ArrayList<String> fileList = new ArrayList<String>();
        if (paletteFiles.exists()) {
            File[] list = paletteFiles.listFiles();
            for (int i = 0; i < list.length; ++i) {
                fileList.add(list[i].getName());
            }
        }
        return fileList;
    }

    public ArrayList<String> getPaletteFileList(String palettesBasePath) throws FilePaletteException {
        return this.getPaletteFileList(palettesBasePath, true);
    }

    public ArrayList<String> getPaletteFileList(String palettesBasePath, boolean forceCreate) throws FilePaletteException {
        ArrayList<String> fileList = this.getPaletteFileListDisc(palettesBasePath);
        if (forceCreate && fileList.size() == 0) {
            DefaultColorTableLibrary persistence = new DefaultColorTableLibrary();
            this.createVersionFromXML(palettesBasePath, persistence.getDefaultPaletteXML());
            fileList = this.getPaletteFileListDisc(palettesBasePath);
        }
        return fileList;
    }

    public String getDefaultPaletteXML() throws FilePaletteException {
        URL url = this.getClass().getResource("xml/palettes.xml");
        StringBuffer contents = new StringBuffer();
        try {
            int i;
            if (url == null) {
                throw new FilePaletteException(FilePaletteException.MESSAGE_FILENOTFOUND);
            }
            InputStream inputStream = url.openStream();
            while ((i = inputStream.read()) != -1) {
                char c = (char)i;
                contents.append(c);
            }
            inputStream.close();
        }
        catch (IOException e) {
            throw new FilePaletteException(FilePaletteException.MESSAGE_FILEFORMATERROR);
        }
        return contents.toString();
    }

    private void createVersionFromXML(String palettesBasePath, String xml) {
        new File(palettesBasePath).mkdir();
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
            int tag = parser.nextTag();
            parser.require(2, null, "palettes");
            tag = parser.nextTag();
            parser.require(2, null, "palette_list");
            parser.skipSubTree();
            parser.require(3, null, "palette_list");
            tag = parser.nextTag();
            while (tag == 2) {
                parser.require(2, null, "palette");
                if (parser.getAttributeCount() == 2) {
                    int i;
                    KXmlSerializer parserOutput = new KXmlSerializer();
                    FileOutputStream fileOutputStream = new FileOutputStream(palettesBasePath + File.separator + parser.getAttributeValue(0) + ".xml");
                    parserOutput.setOutput((OutputStream)fileOutputStream, null);
                    parserOutput.startDocument("UTF-8", null);
                    parserOutput.startTag(null, "ColorTable");
                    parserOutput.attribute(null, "name", parser.getAttributeValue(0));
                    parserOutput.attribute(null, "version", "1.1");
                    tag = parser.nextTag();
                    parser.require(2, null, "table");
                    tag = parser.nextTag();
                    parserOutput.text("\n");
                    List<ColorItemImpl> items = new ArrayList();
                    while (tag == 2) {
                        parser.require(2, null, "entry");
                        if (parser.getAttributeCount() == 3) {
                            String rgb = parser.getAttributeValue(1).substring(parser.getAttributeValue(1).indexOf(",") + 1, parser.getAttributeValue(1).length());
                            int a = Integer.valueOf(parser.getAttributeValue(1).substring(0, parser.getAttributeValue(1).indexOf(",")));
                            int r = Integer.valueOf(rgb.substring(0, rgb.indexOf(",")));
                            int g = Integer.valueOf(rgb.substring(rgb.indexOf(",") + 1, rgb.lastIndexOf(",")));
                            int b = Integer.valueOf(rgb.substring(rgb.lastIndexOf(",") + 1, rgb.length()));
                            ColorItemImpl colorItem = new ColorItemImpl();
                            colorItem.setColor(new Color(r, g, b, a));
                            colorItem.setInterpolated(50.0);
                            colorItem.setNameClass(parser.getAttributeValue(0));
                            colorItem.setValue(Double.parseDouble(parser.getAttributeValue(2)));
                            items.add(colorItem);
                        }
                        tag = parser.nextTag();
                        parser.require(3, null, "entry");
                        tag = parser.nextTag();
                    }
                    parser.require(3, null, "table");
                    tag = parser.nextTag();
                    DataStoreColorTable colorTable = new DataStoreColorTable();
                    colorTable.createPaletteFromColorItems(items, true);
                    items = colorTable.getColorItems();
                    for (i = 0; i < items.size(); ++i) {
                        ColorItem colorItem = (ColorItem)items.get(i);
                        parserOutput.startTag(null, "Color");
                        parserOutput.attribute(null, "value", String.valueOf(colorItem.getValue()));
                        parserOutput.attribute(null, "name", String.valueOf(colorItem.getNameClass()));
                        Color color = colorItem.getColor();
                        parserOutput.attribute(null, "rgb", String.valueOf(color.getRed() + "," + color.getGreen() + "," + color.getBlue()));
                        parserOutput.attribute(null, "interpolated", String.valueOf(colorItem.getInterpolated()));
                        parserOutput.endTag(null, "Color");
                        parserOutput.text("\n");
                    }
                    for (i = 0; i < items.size(); ++i) {
                        ColorItem colorItem = (ColorItem)items.get(i);
                        parserOutput.startTag(null, "Alpha");
                        parserOutput.attribute(null, "value", String.valueOf(colorItem.getValue()));
                        parserOutput.attribute(null, "alpha", String.valueOf(colorItem.getColor().getAlpha()));
                        parserOutput.attribute(null, "interpolated", String.valueOf(colorItem.getInterpolated()));
                        parserOutput.endTag(null, "Alpha");
                        parserOutput.text("\n");
                    }
                    parserOutput.endTag(null, "ColorTable");
                    parserOutput.text("\n");
                    parserOutput.endDocument();
                    fileOutputStream.close();
                }
                parser.require(3, null, "palette");
                tag = parser.nextTag();
            }
            parser.require(3, null, "palettes");
        }
        catch (XmlPullParserException xmlEx) {
            System.out.println("El fichero de paletas predeterminadas no tiene la estructura correcta:\n\t" + xmlEx.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateVersion_1_0_to_1_1(String palettesBasePath) throws FilePaletteException {
        File directoryFile;
        File palettesFile = new File(new File(palettesBasePath).getParent().toString() + File.separator + "palettes.xml");
        if (!palettesFile.exists()) {
            File oldFile = new File(new File(palettesBasePath).getParent().toString() + File.separator + "palettes.xml~");
            if (oldFile.exists()) {
                oldFile.renameTo(new File(new File(palettesBasePath).getParent().toString() + File.separator + "palettes.xml"));
            } else {
                DefaultColorTableLibrary ctlp = new DefaultColorTableLibrary();
                String text = ctlp.getDefaultPaletteXML();
                palettesFile = new File(new File(palettesBasePath).getParent().toString() + File.separator + "palettes.xml");
                try {
                    FileWriter writer = new FileWriter(palettesFile);
                    writer.write(text);
                    writer.close();
                }
                catch (IOException writer) {
                    // empty catch block
                }
            }
        }
        if ((directoryFile = new File(palettesBasePath)).exists()) {
            return;
        }
        palettesFile = new File(new File(palettesBasePath).getParent().toString() + File.separator + "palettes.xml");
        if (!palettesFile.exists()) {
            return;
        }
        try {
            FileInputStream inputStream = new FileInputStream(palettesFile);
            StringBuffer contents = new StringBuffer();
            try {
                int i;
                while ((i = inputStream.read()) != -1) {
                    char c = (char)i;
                    contents.append(c);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.createVersionFromXML(palettesBasePath, contents.toString());
            inputStream.close();
        }
        catch (FileNotFoundException fnfEx) {
            fnfEx.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save_to_1_1(String palettesBasePath, ColorTable colorTable) {
        try {
            ColorItem colorItem;
            int i;
            KXmlSerializer parserOutput = new KXmlSerializer();
            FileOutputStream out = new FileOutputStream(palettesBasePath + File.separator + colorTable.getName() + ".xml");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF8");
            parserOutput.setOutput((Writer)writer);
            parserOutput.startDocument("UTF-8", null);
            parserOutput.startTag(null, "ColorTable");
            parserOutput.attribute(null, "name", colorTable.getName());
            parserOutput.attribute(null, "version", "1.1");
            parserOutput.text("\n");
            List items = colorTable.getColorItems();
            for (i = 0; i < items.size(); ++i) {
                colorItem = (ColorItem)items.get(i);
                parserOutput.startTag(null, "Color");
                parserOutput.attribute(null, "value", String.valueOf(colorItem.getValue()));
                if (colorItem.getNameClass() != null) {
                    parserOutput.attribute(null, "name", String.valueOf(colorItem.getNameClass()));
                } else {
                    parserOutput.attribute(null, "name", "");
                }
                Color color = colorItem.getColor();
                parserOutput.attribute(null, "rgb", String.valueOf(color.getRed() + "," + color.getGreen() + "," + color.getBlue()));
                parserOutput.attribute(null, "interpolated", String.valueOf(colorItem.getInterpolated()));
                parserOutput.endTag(null, "Color");
                parserOutput.text("\n");
            }
            for (i = 0; i < items.size(); ++i) {
                colorItem = (ColorItem)items.get(i);
                parserOutput.startTag(null, "Alpha");
                parserOutput.attribute(null, "value", String.valueOf(colorItem.getValue()));
                parserOutput.attribute(null, "alpha", String.valueOf(colorItem.getColor().getAlpha()));
                parserOutput.attribute(null, "interpolated", String.valueOf(colorItem.getInterpolated()));
                parserOutput.endTag(null, "Alpha");
                parserOutput.text("\n");
            }
            parserOutput.endTag(null, "ColorTable");
            parserOutput.text("\n");
            parserOutput.endDocument();
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateVersion(String palettesBasePath) throws FilePaletteException {
        this.updateVersion_1_0_to_1_1(palettesBasePath);
    }

    public ColorItem getColorItem(ArrayList<ColorItem> list, double value) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getValue() != value) continue;
            return list.remove(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadPalette(String palettesBasePath, String paletteFileName, ArrayList<ColorItem> items) throws FilePaletteException {
        this.updateVersion(palettesBasePath);
        items.clear();
        File palettesFile = new File(palettesBasePath + File.separator + paletteFileName);
        if (!palettesFile.exists()) {
            return null;
        }
        try {
            int i;
            String paletteName = "";
            ArrayList<ColorItem> rows = new ArrayList<ColorItem>();
            KXmlParser parser = new KXmlParser();
            FileInputStream in = new FileInputStream(palettesBasePath + File.separator + paletteFileName);
            InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF8");
            parser.setInput((Reader)reader);
            int tag = parser.nextTag();
            parser.require(2, null, "ColorTable");
            for (i = 0; i < parser.getAttributeCount(); ++i) {
                if (!parser.getAttributeName(i).equals("name")) continue;
                paletteName = parser.getAttributeValue(i);
            }
            tag = parser.nextTag();
            while (tag != 3 || !parser.getName().equals("ColorTable")) {
                try {
                    if (tag != 2) continue;
                    if (parser.getName().equals("Color")) {
                        ColorItemImpl colorItem = new ColorItemImpl();
                        int a = 255;
                        for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                            if (parser.getAttributeName(i2).equals("value")) {
                                colorItem.setValue(Double.parseDouble(parser.getAttributeValue(i2)));
                                ColorItem aux = this.getColorItem(rows, Double.parseDouble(parser.getAttributeValue(i2)));
                                if (aux != null) {
                                    a = aux.getColor().getAlpha();
                                }
                            }
                            if (parser.getAttributeName(i2).equals("name")) {
                                colorItem.setNameClass(parser.getAttributeValue(i2));
                            }
                            if (parser.getAttributeName(i2).equals("rgb")) {
                                String rgb = parser.getAttributeValue(i2);
                                int r = Integer.valueOf(rgb.substring(0, rgb.indexOf(",")));
                                int g = Integer.valueOf(rgb.substring(rgb.indexOf(",") + 1, rgb.lastIndexOf(",")));
                                int b = Integer.valueOf(rgb.substring(rgb.lastIndexOf(",") + 1, rgb.length()));
                                colorItem.setColor(new Color(r, g, b, a));
                            }
                            if (!parser.getAttributeName(i2).equals("interpolated")) continue;
                            colorItem.setInterpolated(Double.parseDouble(parser.getAttributeValue(i2)));
                        }
                        rows.add(colorItem);
                        continue;
                    }
                    if (!parser.getName().equals("Alpha")) continue;
                    ColorItemImpl colorItem = new ColorItemImpl();
                    for (int i3 = 0; i3 < parser.getAttributeCount(); ++i3) {
                        if (parser.getAttributeName(i3).equals("value")) {
                            colorItem.setValue(Double.parseDouble(parser.getAttributeValue(i3)));
                            ColorItem aux = this.getColorItem(rows, Double.parseDouble(parser.getAttributeValue(i3)));
                            if (aux != null) {
                                colorItem.setNameClass(aux.getNameClass());
                                colorItem.setInterpolated(aux.getInterpolated());
                                colorItem.setColor(new Color(aux.getColor().getRed(), aux.getColor().getGreen(), aux.getColor().getBlue(), colorItem.getColor().getAlpha()));
                            }
                        }
                        if (parser.getAttributeName(i3).equals("alpha")) {
                            int a = Integer.parseInt(parser.getAttributeValue(i3));
                            colorItem.setColor(new Color(colorItem.getColor().getRed(), colorItem.getColor().getGreen(), colorItem.getColor().getBlue(), a));
                        }
                        if (!parser.getAttributeName(i3).equals("interpolated")) continue;
                        colorItem.setInterpolated(Double.parseDouble(parser.getAttributeValue(i3)));
                    }
                    rows.add(colorItem);
                }
                finally {
                    tag = parser.nextTag();
                }
            }
            for (i = 0; i < rows.size(); ++i) {
                items.add((ColorItem)rows.get(i));
            }
            reader.close();
            return paletteName;
        }
        catch (FileNotFoundException fnfEx) {
            fnfEx.printStackTrace();
        }
        catch (XmlPullParserException xmlEx) {
            System.out.println("El fichero de paletas predeterminadas no tiene la estructura correcta:\n\t" + xmlEx.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

