/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.datastruct.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.datastruct.DefaultNoData;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class NoDataRmfSerializer
extends ClassSerializer {
    private final String MAIN_TAG = "NoDataValue";
    private DefaultNoData noData = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append("NoDataValue", "", NoDataRmfSerializer.class);
    }

    public NoDataRmfSerializer(DefaultNoData noData) {
        this.noData = noData;
    }

    public NoDataRmfSerializer() {
    }

    @Override
    public String getMainTag() {
        return "NoDataValue";
    }

    private DefaultNoData getNoData() {
        if (this.noData == null) {
            this.noData = new DefaultNoData();
        }
        return this.noData;
    }

    @Override
    public Object getResult() {
        return this.noData;
    }

    @Override
    public void read(String xml) throws ParsingException {
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        this.getNoData().delete();
        int bands = 0;
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                int i;
                parser.require(2, null, "NoDataValue");
                for (i = 0; i < parser.getAttributeCount(); ++i) {
                    if (parser.getAttributeName(i).equals("transparent")) {
                        this.getNoData().setNoDataTransparent(new Boolean(parser.getAttributeValue(i)));
                    }
                    if (!parser.getAttributeName(i).equals("datatype")) continue;
                    this.getNoData().setDataType(new Integer(parser.getAttributeValue(i)));
                }
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (!parser.getName().equals("Band")) break;
                            ++bands;
                            for (i = 0; i < parser.getAttributeCount(); ++i) {
                                if (!parser.getAttributeName(i).equals("value")) continue;
                                String str = parser.getAttributeValue(i);
                                if (str.compareTo("null") == 0) {
                                    this.getNoData().setValue(null);
                                    continue;
                                }
                                this.getNoData().setValue(Double.parseDouble(str));
                            }
                            break;
                        }
                    }
                    tag = parser.next();
                }
            }
            ((Reader)reader).close();
            this.getNoData().setBandCount(bands);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
    }

    @Override
    public String write() throws IOException {
        if (this.noData == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        b.append("<NoDataValue datatype=\"" + this.getNoData().getDataType() + "\" transparent=\"" + this.getNoData().isNoDataTransparent() + "\">\n");
        for (int i = 0; i < this.getNoData().getBandCount(); ++i) {
            Number value = this.getNoData().getValueByBand(i);
            b.append("\t<Band");
            b.append(" number=\"" + i + "\"");
            if (value != null) {
                switch (this.getNoData().getDataType()) {
                    case 0: {
                        b.append(" value=\"" + value.byteValue() + "\"/>\n");
                        break;
                    }
                    case 2: {
                        b.append(" value=\"" + value.shortValue() + "\"/>\n");
                        break;
                    }
                    case 3: {
                        b.append(" value=\"" + value.intValue() + "\"/>\n");
                        break;
                    }
                    case 4: {
                        b.append(" value=\"" + value.floatValue() + "\"/>\n");
                        break;
                    }
                    case 5: {
                        b.append(" value=\"" + value.doubleValue() + "\"/>\n");
                    }
                }
                continue;
            }
            b.append(" value=\"null\"/>\n");
        }
        b.append("</NoDataValue>\n");
        return b.toString();
    }
}

