/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import java.awt.Rectangle;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidAccessException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.GridReader;

public class GridNotInterpolated
extends GridReader {
    int m_iOffsetX;
    int m_iOffsetY;
    int m_iWidth;
    int m_iHeight;

    public GridNotInterpolated(Buffer rb, GridExtent layerExtent, GridExtent windowExtent, int[] bands) {
        super(rb, layerExtent, windowExtent, bands);
        this.m_iWidth = rb.getWidth();
        this.m_iHeight = rb.getHeight();
    }

    public GridNotInterpolated(RasterDataStore ds, GridExtent layerExtent, GridExtent windowExtent, int[] bands) {
        super(ds, layerExtent, windowExtent, bands);
        this.init();
    }

    private void init() {
        int iWindowMinX = (int)((this.windowExtent.minX() - this.layerExtent.minX()) / this.windowExtent.getCellSizeX());
        int iWindowMinY = (int)((this.layerExtent.maxY() - this.windowExtent.maxY()) / this.windowExtent.getCellSizeY());
        double dMinX = Math.min(Math.max(this.windowExtent.minX(), this.layerExtent.minX()), this.layerExtent.maxX());
        double dMinY = Math.min(Math.max(this.windowExtent.minY(), this.layerExtent.minY()), this.layerExtent.maxY());
        double dMaxX = Math.max(Math.min(this.windowExtent.maxX(), this.layerExtent.maxX()), this.layerExtent.minX());
        double dMaxY = Math.max(Math.min(this.windowExtent.maxY(), this.layerExtent.maxY()), this.layerExtent.minY());
        int iBufMinX = (int)Math.floor((dMinX - this.windowExtent.minX()) / this.windowExtent.getCellSizeX()) + iWindowMinX;
        int iBufMinY = (int)Math.floor((dMaxY - this.windowExtent.maxY()) / this.windowExtent.getCellSizeY()) + iWindowMinY;
        int iBufMaxX = (int)Math.floor((dMaxX - this.windowExtent.minX()) / this.windowExtent.getCellSizeX()) + iWindowMinX;
        int iBufMaxY = (int)Math.floor((dMinY - this.windowExtent.maxY()) / this.windowExtent.getCellSizeY()) + iWindowMinY;
        this.m_iOffsetX = iBufMinX - iWindowMinX;
        this.m_iOffsetY = iBufMinY - iWindowMinY;
        this.m_iWidth = Math.abs(iBufMaxX - iBufMinX);
        this.m_iHeight = Math.abs(iBufMaxY - iBufMinY);
        try {
            RasterQuery query = DefaultRasterManager.getInstance().createQuery();
            query.setDrawableBands(this.bands);
            query.setAreaOfInterest(new Rectangle(iBufMinX, iBufMinY, this.m_iWidth, this.m_iHeight));
            query.storeLastBuffer(true);
            this.rasterBuf = this.dataStore.query(query);
        }
        catch (Exception e) {
            this.rasterBuf = null;
        }
    }

    private boolean isInRasterBuf(int x, int y) {
        if (this.rasterBuf != null) {
            return x >= 0 && y >= 0 && x < this.m_iWidth && y < this.m_iHeight;
        }
        return false;
    }

    @Override
    public byte getCellValueAsByte(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                return this.rasterBuf.getElemByte(y - this.m_iOffsetY, x - this.m_iOffsetX, this.bandToOperate);
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidException("Null Buffer");
        }
    }

    @Override
    public short getCellValueAsShort(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                return this.rasterBuf.getElemShort(y - this.m_iOffsetY, x - this.m_iOffsetX, this.bandToOperate);
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidException("Null Buffer");
        }
    }

    @Override
    public int getCellValueAsInt(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                return this.rasterBuf.getElemInt(y - this.m_iOffsetY, x - this.m_iOffsetX, this.bandToOperate);
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidException("Null Buffer");
        }
    }

    @Override
    public float getCellValueAsFloat(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                return this.rasterBuf.getElemFloat(y - this.m_iOffsetY, x - this.m_iOffsetX, this.bandToOperate);
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidException("Null Buffer");
        }
    }

    @Override
    public double getCellValueAsDouble(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                return this.rasterBuf.getElemDouble(y - this.m_iOffsetY, x - this.m_iOffsetX, this.bandToOperate);
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidException("Null Buffer");
        }
    }

    @Override
    public double getCellValue(int x, int y) throws RasterBufferInvalidAccessException {
        try {
            if (this.dataType == 5) {
                return this.rasterBuf.getElemDouble(x, y, 0);
            }
            if (this.dataType == 3) {
                return this.rasterBuf.getElemInt(x, y, 0);
            }
            if (this.dataType == 4) {
                return this.rasterBuf.getElemFloat(x, y, 0);
            }
            if (this.dataType == 0) {
                return this.rasterBuf.getElemByte(x, y, 0);
            }
            if (this.dataType == 2 | this.dataType == 1) {
                return this.rasterBuf.getElemShort(x, y, 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
    }

    @Override
    public byte[] getBandsValuesAsByte(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        byte[] b = new byte[this.rasterBuf.getBandCount()];
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                try {
                    this.rasterBuf.getElemByte(y - this.m_iOffsetY, x - this.m_iOffsetX, b);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
                }
                catch (NullPointerException e) {
                    throw new RasterBufferInvalidException("Null Buffer");
                }
                return b;
            }
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue;
            }
            return b;
        }
        catch (Exception e) {
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue;
            }
            return b;
        }
    }

    @Override
    public short[] getBandsValuesAsShort(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        short[] b = new short[this.rasterBuf.getBandCount()];
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                try {
                    this.rasterBuf.getElemShort(y - this.m_iOffsetY, x - this.m_iOffsetX, b);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
                }
                catch (NullPointerException e) {
                    throw new RasterBufferInvalidException("Null Buffer");
                }
                return b;
            }
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue;
            }
            return b;
        }
        catch (Exception e) {
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue;
            }
            return b;
        }
    }

    @Override
    public int[] getBandsValuesAsInt(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        int[] b = new int[this.rasterBuf.getBandCount()];
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                try {
                    this.rasterBuf.getElemInt(y - this.m_iOffsetY, x - this.m_iOffsetX, b);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
                }
                catch (NullPointerException e) {
                    throw new RasterBufferInvalidException("Null Buffer");
                }
                return b;
            }
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue;
            }
            return b;
        }
        catch (Exception e) {
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue;
            }
            return b;
        }
    }

    @Override
    public float[] getBandsValuesAsFloat(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        float[] b = new float[this.rasterBuf.getBandCount()];
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                try {
                    this.rasterBuf.getElemFloat(y - this.m_iOffsetY, x - this.m_iOffsetX, b);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
                }
                catch (NullPointerException e) {
                    throw new RasterBufferInvalidException("Null Buffer");
                }
                return b;
            }
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue;
            }
            return b;
        }
        catch (Exception e) {
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue;
            }
            return b;
        }
    }

    @Override
    public double[] getBandsValuesAsDouble(int x, int y) throws RasterBufferInvalidAccessException, RasterBufferInvalidException {
        double[] b = new double[this.rasterBuf.getBandCount()];
        try {
            if (this.isInRasterBuf(x - this.m_iOffsetX, y - this.m_iOffsetY)) {
                try {
                    this.rasterBuf.getElemDouble(y - this.m_iOffsetY, x - this.m_iOffsetX, b);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
                }
                catch (NullPointerException e) {
                    throw new RasterBufferInvalidException("Null Buffer");
                }
                return b;
            }
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
            }
            return b;
        }
        catch (Exception e) {
            for (int i = 0; i < this.rasterBuf.getBandCount(); ++i) {
                b[i] = this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
            }
            return b;
        }
    }
}

