/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.props.BasicStats;
import org.gvsig.raster.impl.grid.GridImpl;

public class GridStatistic
implements BasicStats {
    private double[] max = null;
    private double[] min = null;
    private double[] mean = null;
    private double[] variance = null;
    private boolean statisticsCalculated = false;
    private GridImpl grid = null;
    protected int bandToOperate = 0;

    public GridStatistic(GridImpl grid) {
        this.grid = grid;
    }

    private void calculateStatistics() throws GridException {
        int[] iValues = new int[this.grid.getBandCount()];
        this.mean = new double[this.grid.getBandCount()];
        this.min = new double[this.grid.getBandCount()];
        this.max = new double[this.grid.getBandCount()];
        this.variance = new double[this.grid.getBandCount()];
        for (int iBand = 0; iBand < this.grid.getBandCount(); ++iBand) {
            this.mean[iBand] = 0.0;
            this.variance[iBand] = 0.0;
            iValues[iBand] = 0;
        }
        int oldBandToOperate = this.bandToOperate;
        this.statisticsCalculated = true;
        for (int iBand = 0; iBand < this.grid.getBandCount(); ++iBand) {
            this.grid.setBandToOperate(iBand);
            for (int y = 0; y < this.grid.getNY(); ++y) {
                for (int x = 0; x < this.grid.getNX(); ++x) {
                    double z = this.getValue(x, y);
                    if (this.grid.isNoDataValue(z)) continue;
                    if (iValues[iBand] == 0) {
                        this.min[iBand] = this.max[iBand] = z;
                    } else if (this.min[iBand] > z) {
                        this.min[iBand] = z;
                    } else if (this.max[iBand] < z) {
                        this.max[iBand] = z;
                    }
                    int n = iBand;
                    this.mean[n] = this.mean[n] + z;
                    int n2 = iBand;
                    this.variance[n2] = this.variance[n2] + z * z;
                    int n3 = iBand;
                    iValues[n3] = iValues[n3] + 1;
                }
            }
            if (iValues[iBand] <= 0) continue;
            int n = iBand;
            this.mean[n] = this.mean[n] / (double)iValues[iBand];
            this.variance[iBand] = this.variance[iBand] / (double)iValues[iBand] - this.mean[iBand] * this.mean[iBand];
        }
        this.bandToOperate = oldBandToOperate;
        this.statisticsCalculated = true;
    }

    private double getValue(int x, int y) throws GridException {
        switch (this.grid.getDataType()) {
            case 0: {
                return this.grid.getCellValueAsByte(x, y) & 0xFF;
            }
            case 2: {
                return this.grid.getCellValueAsShort(x, y) & 0xFFFF;
            }
            case 3: {
                return this.grid.getCellValueAsInt(x, y) & 0xFFFFFFFF;
            }
            case 4: {
                return this.grid.getCellValueAsFloat(x, y);
            }
            case 5: {
                return this.grid.getCellValueAsDouble(x, y);
            }
        }
        return 0.0;
    }

    public void setStatisticsCalculated(boolean calc) {
        this.statisticsCalculated = calc;
    }

    public void setBandToOperate(int band) {
        this.bandToOperate = band;
    }

    public void calcFullStatistics() throws FileNotOpenException, RasterDriverException, InterruptedException {
        try {
            this.calculateStatistics();
        }
        catch (GridException e) {
            throw new RasterDriverException("");
        }
    }

    public double getMaxValue() throws BandAccessException {
        return this.max[this.bandToOperate];
    }

    public double getMeanValue() throws BandAccessException {
        return this.mean[this.bandToOperate];
    }

    public double getMinValue() throws BandAccessException {
        return this.min[this.bandToOperate];
    }

    public double getVarianceValue() throws BandAccessException {
        return this.variance[this.bandToOperate];
    }

    public boolean isCalculated() {
        return this.statisticsCalculated;
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.max = null;
        this.min = null;
        this.mean = null;
        this.variance = null;
        this.grid = null;
        super.finalize();
    }
}

