/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.OutOfGridException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidAccessException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.GridExtentImpl;

public class GridWriter {
    private Buffer rasterBuf = null;
    private GridExtent extent = null;
    private int dataType = 32;
    private int bandToOperate = 0;

    public GridWriter(GridExtent ge, int dataType, Buffer rasterBuf) {
        this.rasterBuf = rasterBuf;
        this.extent = ge;
    }

    public GridWriter(int iNX, int iNY, double dCellSize, double dMinX, double dMinY, int dataType, int[] bands) {
        this.extent = new GridExtentImpl();
        this.extent.setCellSize(dCellSize);
        this.extent.setXRange(dMinX, dMinX + (double)iNX * dCellSize);
        this.extent.setYRange(dMinY, dMinY + (double)iNY * dCellSize);
        this.rasterBuf = DefaultRasterManager.getInstance().createBuffer(dataType, iNX, iNY, bands.length, true);
    }

    public void assign(byte value) throws RasterBufferInvalidAccessException {
        try {
            this.rasterBuf.assign(this.bandToOperate, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
    }

    public void assign(short value) throws RasterBufferInvalidAccessException {
        try {
            this.rasterBuf.assign(this.bandToOperate, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
    }

    public void assign(int value) throws RasterBufferInvalidAccessException {
        try {
            this.rasterBuf.assign(this.bandToOperate, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
    }

    public void assign(float value) throws RasterBufferInvalidAccessException {
        try {
            this.rasterBuf.assign(this.bandToOperate, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
    }

    public void assign(double value) throws RasterBufferInvalidAccessException {
        try {
            this.rasterBuf.assign(this.bandToOperate, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
        catch (NullPointerException e) {
            throw new RasterBufferInvalidAccessException("Access to data type " + this.dataType + "invalid");
        }
    }

    public GridExtent getGridExtent() {
        return this.extent;
    }

    public void setCellValue(int iX, int iY, byte value) throws OutOfGridException {
        if (!this.isCellInGrid(iX, iY)) {
            throw new OutOfGridException("Point:(" + iX + "," + iY + ") out of grid.");
        }
        this.rasterBuf.setElem(iY, iX, this.bandToOperate, value);
    }

    public void setCellValue(int iX, int iY, short value) throws OutOfGridException {
        if (!this.isCellInGrid(iX, iY)) {
            throw new OutOfGridException("Point:(" + iX + "," + iY + ") out of grid.");
        }
        this.rasterBuf.setElem(iY, iX, this.bandToOperate, value);
    }

    public void setCellValue(int iX, int iY, int value) throws OutOfGridException {
        if (!this.isCellInGrid(iX, iY)) {
            throw new OutOfGridException("Point:(" + iX + "," + iY + ") out of grid.");
        }
        this.rasterBuf.setElem(iY, iX, this.bandToOperate, value);
    }

    public void setCellValue(int iX, int iY, float value) throws OutOfGridException {
        if (!this.isCellInGrid(iX, iY)) {
            throw new OutOfGridException("Point:(" + iX + "," + iY + ") out of grid.");
        }
        this.rasterBuf.setElem(iY, iX, this.bandToOperate, value);
    }

    public void setCellValue(int iX, int iY, double value) throws OutOfGridException {
        if (!this.isCellInGrid(iX, iY)) {
            throw new OutOfGridException("Point:(" + iX + "," + iY + ") out of grid.");
        }
        this.rasterBuf.setElem(iY, iX, this.bandToOperate, value);
    }

    public void setNoData(int iX, int iY) {
        if (this.isCellInGrid(iX, iY)) {
            switch (this.rasterBuf.getDataType()) {
                case 0: {
                    this.rasterBuf.setElem(iY, iX, this.bandToOperate, this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue);
                    break;
                }
                case 2: {
                    this.rasterBuf.setElem(iY, iX, this.bandToOperate, this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue);
                    break;
                }
                case 3: {
                    this.rasterBuf.setElem(iY, iX, this.bandToOperate, this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue);
                    break;
                }
                case 4: {
                    this.rasterBuf.setElem(iY, iX, this.bandToOperate, this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue);
                    break;
                }
                case 5: {
                    this.rasterBuf.setElem(iY, iX, this.bandToOperate, this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue);
                }
            }
        }
    }

    public void setNoDataValue(NoData noDataValue) {
        if (noDataValue.isDefined()) {
            this.rasterBuf.setNoDataValue(noDataValue);
        }
    }

    public boolean isCellInGrid(int iX, int iY) {
        return iX >= 0 && iX < this.extent.getNX() && iY >= 0 && iY < this.extent.getNY();
    }

    public void setBandToOperate(int band) {
        this.bandToOperate = band;
    }

    public void dispose() {
        if (this.rasterBuf != null) {
            this.rasterBuf.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.rasterBuf = null;
        this.extent = null;
        super.finalize();
    }
}

