/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.band;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;

public class ColorTableFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"colortable"};
    protected DataStoreColorTable colorTable = new DataStoreColorTable();
    protected boolean hasAlpha = false;

    public ColorTableFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.colorTable = (DataStoreColorTable)this.params.get("colorTable");
        this.hasAlpha = this.colorTable.hasAlpha();
        ColorInterpretation ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
        if (this.transparency != null) {
            this.transparency.setColorInterpretation(ci);
        } else {
            this.transparency = new DataStoreTransparency(ci);
        }
        this.transparency.activeTransparency();
        this.createARGBBufferResult();
    }

    public String getGroup() {
        return "radiometrico";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("colorTable", new DataStoreColorTable(this.colorTable), -1, null);
        return params;
    }

    public void post() {
    }

    public void process(int x, int y) {
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public boolean isVisible() {
        return false;
    }

    public boolean isToConvertToRGB() {
        return true;
    }

    public ColorTable getColorTable() {
        if (this.colorTable == null || this.colorTable.getColorItems() == null) {
            this.colorTable = (DataStoreColorTable)this.params.get("colorTable");
        }
        return this.colorTable;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public void setColorTable(ColorTable colorTable) {
        this.colorTable = (DataStoreColorTable)colorTable;
    }
}

