/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.enhancement.BrightnessByteFilter;
import org.gvsig.raster.impl.grid.filter.enhancement.BrightnessFilter;
import org.gvsig.raster.impl.grid.filter.enhancement.ContrastByteFilter;
import org.gvsig.raster.impl.grid.filter.enhancement.ContrastFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class BrightnessContrastListManager
extends AbstractRasterFilterManager {
    private static String ID = "BrightnessContrast";

    public BrightnessContrastListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, BrightnessContrastListManager.class);
    }

    public BrightnessContrastListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public void addBrightnessFilter(int incrBrillo) throws FilterTypeException {
        RasterFilter filter = BrightnessContrastListManager.createBrightnessFilter(incrBrillo);
        if (filter != null) {
            this.getFilterList().add(filter);
        }
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("brightness") == 0) {
            return BrightnessFilter.class;
        }
        if (id.compareTo("contrast") == 0) {
            return ContrastFilter.class;
        }
        return null;
    }

    public static RasterFilter createBrightnessFilter(int incrBrillo) {
        BrightnessByteFilter filter = new BrightnessByteFilter();
        if (filter != null) {
            filter.addParam("incrBrillo", new Integer(incrBrillo));
        }
        return filter;
    }

    public void addContrastFilter(int incrContraste) throws FilterTypeException {
        RasterFilter filter = BrightnessContrastListManager.createContrastFilter(incrContraste);
        if (filter != null) {
            this.getFilterList().add(filter);
        }
    }

    public static RasterFilter createContrastFilter(int incrContraste) {
        ContrastByteFilter filter = new ContrastByteFilter();
        if (filter != null) {
            filter.addParam("incrContraste", new Integer(incrContraste));
        }
        return filter;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(BrightnessFilter.class);
        filters.add(ContrastFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        int i;
        if (ContrastFilter.class.isAssignableFrom(classFilter)) {
            int contrast = 0;
            for (i = 0; i < params.getNumParams(); ++i) {
                if (!((ParamImpl)params.getParam(i)).getId().equals("Contrast")) continue;
                contrast = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addContrastFilter(contrast);
        }
        if (BrightnessFilter.class.isAssignableFrom(classFilter)) {
            int brightness = 0;
            for (i = 0; i < params.getNumParams(); ++i) {
                if (!((ParamImpl)params.getParam(i)).getId().equals("Brightness") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer)) continue;
                brightness = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addBrightnessFilter(brightness);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ContrastFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        if (params.getParamById("Brightness") != null) {
            int brightness = (Integer)params.getParamById("Brightness").getDefaultValue();
            return BrightnessContrastListManager.createBrightnessFilter(brightness);
        }
        if (params.getParamById("Contrast") != null) {
            int contrast = (Integer)params.getParamById("Contrast").getDefaultValue();
            return BrightnessContrastListManager.createContrastFilter(contrast);
        }
        return null;
    }
}

