/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.impl.store.ParamsImpl;

public class BrightnessFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{"brightness"};
    int incrBrillo = 0;

    public BrightnessFilter() {
        this.setName(names[0]);
    }

    public void pre() throws FilterAddException {
        super.pre();
        this.incrBrillo = (Integer)this.params.get("incrBrillo");
        this.createBufferResult(0, this.raster.getBandCount());
    }

    public void post() {
        this.raster = null;
    }

    public int getBrightnessIncrease() {
        return this.incrBrillo;
    }

    public String getGroup() {
        return "realces";
    }

    public Params getUIParams(String nameFilter) {
        ParamsImpl params = new ParamsImpl();
        params.setParam("Brightness", new Integer(this.incrBrillo), 3, new String[]{"-255", "255", "50", "1", "25"});
        return params;
    }

    public int getInRasterDataType() {
        return 0;
    }

    public int getOutRasterDataType() {
        return 0;
    }

    public void process(int x, int y) {
    }

    protected int calcBrightness(int px) {
        if ((px += this.incrBrillo) > 255) {
            px = 255;
        } else if (px < 0) {
            px = 0;
        }
        return px;
    }

    public String[] getNames() {
        return names;
    }
}

