/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Stretch;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.filter.LinearStretchParams;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.datastruct.DefaultStretch;

public class DefaultLinearStretchParams
implements LinearStretchParams {
    public DefaultStretch red = new DefaultStretch();
    public DefaultStretch green = new DefaultStretch();
    public DefaultStretch blue = new DefaultStretch();
    public boolean rgb = false;

    public boolean hasTailTrim() {
        return this.red.hasTailTrim() || this.green.hasTailTrim() || this.blue.hasTailTrim();
    }

    public double[] getTailTrimList() {
        return new double[]{this.red.tailTrimMin, this.green.tailTrimMin, this.blue.tailTrimMin, this.red.tailTrimMax, this.green.tailTrimMax, this.blue.tailTrimMax};
    }

    public void loadTailTrimValues(Statistics stats) {
        double[][] result = (double[][])stats.getTailTrimValue(this.red.tailTrimMin);
        if (result != null) {
            this.red.tailTrimValueMin = result[0][0];
        }
        if ((result = (double[][])stats.getTailTrimValue(this.red.tailTrimMax)) != null) {
            this.red.tailTrimValueMax = result[0][1];
        }
        if ((result = (double[][])stats.getTailTrimValue(this.green.tailTrimMin)) != null && result.length >= 2) {
            this.green.tailTrimValueMin = result[1][0];
        }
        if ((result = (double[][])stats.getTailTrimValue(this.green.tailTrimMax)) != null && result.length >= 2) {
            this.green.tailTrimValueMax = result[1][1];
        }
        if ((result = (double[][])stats.getTailTrimValue(this.blue.tailTrimMin)) != null && result.length >= 3) {
            this.blue.tailTrimValueMin = result[2][0];
        }
        if ((result = (double[][])stats.getTailTrimValue(this.blue.tailTrimMax)) != null && result.length >= 3) {
            this.blue.tailTrimValueMax = result[2][1];
        }
    }

    public void applyTrimToStretchs() {
        this.red.applyTrimToStretchs();
        this.green.applyTrimToStretchs();
        this.blue.applyTrimToStretchs();
    }

    public void calcLinearScaleAndOffset() {
        this.red.calcLinearScaleAndOffset();
        this.green.calcLinearScaleAndOffset();
        this.blue.calcLinearScaleAndOffset();
    }

    public void setMaxMin(Statistics stats, int[] renderBands) {
        if (renderBands[0] > -1) {
            this.red.setMaxMin(stats, renderBands[0], this.rgb);
        }
        if (renderBands[1] > -1) {
            this.green.setMaxMin(stats, renderBands[1], this.rgb);
        }
        if (renderBands[2] > -1) {
            this.blue.setMaxMin(stats, renderBands[2], this.rgb);
        }
    }

    public void applyRemoveEndsToStretchs(Statistics stats, int[] renderBands) {
        if (renderBands[0] > -1) {
            this.red.applyRemoveEndsToStretchs(stats, this.rgb, renderBands[0]);
        }
        if (renderBands[1] > -1) {
            this.green.applyRemoveEndsToStretchs(stats, this.rgb, renderBands[1]);
        }
        if (renderBands[2] > -1) {
            this.blue.applyRemoveEndsToStretchs(stats, this.rgb, renderBands[2]);
        }
    }

    public static DefaultLinearStretchParams createStandardParam(int[] renderBands, double tailTrim, Statistics stats, boolean rgb) throws FileNotOpenException, RasterDriverException {
        DefaultLinearStretchParams leParams = new DefaultLinearStretchParams();
        leParams.rgb = rgb;
        try {
            stats.calculate(RasterLibrary.statisticsScale);
        }
        catch (ProcessInterruptedException e) {
            return null;
        }
        if (renderBands[0] >= 0) {
            leParams.red.stretchIn = rgb ? new double[]{stats.getMinByteUnsigned()[0], stats.getMaxByteUnsigned()[0]} : new double[]{stats.getMin()[renderBands[0]], stats.getMax()[renderBands[0]]};
        }
        leParams.red.stretchOut = new int[]{0, 255};
        leParams.red.tailTrimMin = tailTrim;
        leParams.red.tailTrimMax = tailTrim;
        if (renderBands[1] >= 0) {
            leParams.green.stretchIn = rgb ? new double[]{stats.getMinByteUnsigned()[0], stats.getMaxByteUnsigned()[0]} : new double[]{stats.getMin()[renderBands[1]], stats.getMax()[renderBands[1]]};
        }
        leParams.green.stretchOut = new int[]{0, 255};
        leParams.green.tailTrimMin = tailTrim;
        leParams.green.tailTrimMax = tailTrim;
        if (renderBands[2] >= 0) {
            leParams.blue.stretchIn = rgb ? new double[]{stats.getMinByteUnsigned()[0], stats.getMaxByteUnsigned()[0]} : new double[]{stats.getMin()[renderBands[2]], stats.getMax()[renderBands[2]]};
        }
        leParams.blue.stretchOut = new int[]{0, 255};
        leParams.blue.tailTrimMin = tailTrim;
        leParams.blue.tailTrimMax = tailTrim;
        return leParams;
    }

    public Stretch getRed() {
        return this.red;
    }

    public void setRed(Stretch red) {
        this.red = (DefaultStretch)red;
    }

    public Stretch getGreen() {
        return this.green;
    }

    public void setGreen(Stretch green) {
        this.green = (DefaultStretch)green;
    }

    public Stretch getBlue() {
        return this.blue;
    }

    public void setBlue(Stretch blue) {
        this.blue = (DefaultStretch)blue;
    }

    public boolean isRgb() {
        return this.rgb;
    }

    public void setRgb(boolean rgb) {
        this.rgb = rgb;
    }
}

