/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.enhancement;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.enhancement.EqualizationByteFilter;
import org.gvsig.raster.impl.grid.filter.enhancement.EqualizationFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class EqualizationManager
extends AbstractRasterFilterManager {
    private static String ID = "Equalization";

    public EqualizationManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, EqualizationManager.class);
    }

    public EqualizationManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("equalization") == 0) {
            return EqualizationFilter.class;
        }
        return null;
    }

    public void addEqualizationFilter(int[] renderBands, int[] ecualizedBands) throws FilterTypeException {
        RasterFilter filter = EqualizationManager.createEnhancedFilter(renderBands, ecualizedBands);
        if (filter != null) {
            this.getFilterList().add(filter);
        }
    }

    public static RasterFilter createEnhancedFilter(int[] renderBands, int[] ecualizedBands) {
        EqualizationByteFilter filter = new EqualizationByteFilter();
        if (filter != null) {
            filter.addParam("renderBands", renderBands);
            filter.addParam("ecualizedBands", ecualizedBands);
        }
        return filter;
    }

    public List<String> getStringsFromFilterList(List<String> filterList, RasterFilter rf) {
        return filterList;
    }

    public int createFilterListFromStrings(List<String> filters, String fil, int filteri) throws FilterTypeException {
        return filteri;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(EqualizationFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (EqualizationFilter.class.isAssignableFrom(classFilter)) {
            int[] renderBands = new int[]{0, 1, 2, 3};
            int[] ecualizedBands = new int[]{0, 1, 2};
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (((ParamImpl)params.getParam(i)).getId().equals("RenderBands") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof String) {
                    String[] bands = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue()).split(" ");
                    renderBands[0] = new Integer(bands[0]);
                    renderBands[1] = new Integer(bands[1]);
                    renderBands[2] = new Integer(bands[2]);
                    continue;
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("alphaBand") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    renderBands[3] = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                    continue;
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("EcualizedBands") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof int[])) continue;
                ecualizedBands = (int[])((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addEqualizationFilter(renderBands, ecualizedBands);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(EqualizationFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        return null;
    }
}

