/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.roi;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.raster.roi.AbstractROI;
import org.gvsig.raster.roi.VectorialROI;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class VectorialROIImpl
extends AbstractROI
implements VectorialROI {
    private ArrayList<Geometry> geometries = new ArrayList();

    public VectorialROIImpl(RasterDataStore store) {
        super(store);
    }

    public boolean isInside(double x, double y, double w, double h) {
        if (x + w < this.getROIExtent().minX() || x > this.getROIExtent().maxX() || y - h > this.getROIExtent().maxY() || y < this.getROIExtent().minY()) {
            return false;
        }
        for (int i = 0; i < this.geometries.size(); ++i) {
            Rectangle2D.Double celda = new Rectangle2D.Double(x, y, w, h);
            if (!this.geometries.get(i).intersects((Rectangle2D)celda)) continue;
            return true;
        }
        return false;
    }

    public boolean isInsideOfPolygon(int x, int y) {
        double newX = x - this.xOffset;
        double newY = y - this.yOffset;
        if (newX < 0.0 || newX > (double)this.getROIPxWidth() || newY < 0.0 || newY > (double)this.getROIPxHeight()) {
            return false;
        }
        Point2D p = this.getStore().rasterToWorld((Point2D)new Point2D.Double(x, y));
        for (int i = 0; i < this.geometries.size(); ++i) {
            if (!this.geometries.get(i).contains(p.getX(), p.getY())) continue;
            return true;
        }
        return false;
    }

    public void addGeometry(Geometry geometry) {
        RasterManager rManager = RasterLocator.getManager();
        this.geometries.add(geometry);
        Rectangle geometryBounds = geometry.getBounds();
        this.roiExtent = this.getROIExtent() == null ? rManager.getDataStructFactory().createExtent(geometryBounds.getMinX(), geometryBounds.getMaxY(), geometryBounds.getMaxX(), geometryBounds.getMinY()) : rManager.getDataStructFactory().createExtent(Math.min(geometryBounds.getMinX(), this.getROIExtent().minX()), Math.max(geometryBounds.getMaxY(), this.getROIExtent().maxY()), Math.max(geometryBounds.getMaxX(), this.getROIExtent().maxX()), Math.min(geometryBounds.getMinY(), this.getROIExtent().minY()));
        double minX = geometryBounds.getMinX() - Math.abs(geometryBounds.getMinX() - this.getStoreExtent().getMin().getX()) % this.getCellSize();
        double minY = geometryBounds.getMinY() - Math.abs(geometryBounds.getMinY() - this.getStoreExtent().getMin().getY()) % this.getCellSize();
        double maxX = geometryBounds.getMaxX() + this.getCellSize() - Math.abs(geometryBounds.getMaxX() - this.getStoreExtent().getMin().getX()) % this.getCellSize();
        double maxY = geometryBounds.getMaxY() + this.getCellSize() - Math.abs(geometryBounds.getMaxY() - this.getStoreExtent().getMin().getY()) % this.getCellSize();
        if (this.geometries.size() > 1) {
            minX = Math.min(minX, this.getROIExtent().getMin().getX());
            minY = Math.min(minY, this.getROIExtent().getMin().getY());
            maxX = Math.max(maxX, this.getROIExtent().getMax().getX());
            maxY = Math.max(maxY, this.getROIExtent().getMax().getY());
        }
        this.xOffset = (int)((minX - this.getStoreExtent().getMin().getX()) / this.getCellSize());
        this.yOffset = (int)((this.getStoreExtent().getMax().getY() - maxY) / this.getCellSize());
        this.getStatistic().setCalculated(false);
    }

    public void deleteGeometry(int index) {
        this.geometries.remove(index);
        this.getStatistic().setCalculated(false);
    }

    public void clear() {
        this.geometries.clear();
        this.getStatistic().setCalculated(false);
    }

    public List<Geometry> getGeometries() {
        return this.geometries;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        List aux = state.getList("geometries");
        this.geometries = new ArrayList();
        this.geometries.addAll(aux);
        this.roiExtent = (Extent)state.get("extent");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("geometries", this.geometries);
        state.set("extent", (Persistent)this.getROIExtent());
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("AbstractROI_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(VectorialROIImpl.class, "AbstractROI_Persistent", "AbstractROI Persistent", null, null);
            definition.addDynFieldList("geometries").setClassOfItems(Geometry.class).setMandatory(false);
            definition.addDynFieldObject("extent").setClassOfValue(Extent.class).setMandatory(true);
        }
    }
}

