/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.roi;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.FileNotExistsException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreProvider;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.NullGeometry;
import org.gvsig.raster.impl.grid.roi.InvalidROIsShpException;
import org.gvsig.raster.impl.grid.roi.VectorialROIImpl;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roi.ROIReader;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.LoggerFactory;

public class VectorialROIsReader
implements ROIReader {
    private HashMap<String, ROI> rois = null;
    private RasterDataStore store = null;
    private Envelope bbox = null;
    private FeatureStore[] featureStore = null;

    public VectorialROIsReader(FeatureStore featureStore, RasterDataStore store, IProjection projection) {
        Rectangle2D e = store.getExtent().toRectangle2D();
        try {
            this.bbox = GeometryLocator.getGeometryManager().createEnvelope(e.getX(), e.getY(), e.getMaxX(), e.getMaxY(), 0);
        }
        catch (CreateEnvelopeException e1) {
            LoggerFactory.getLogger(VectorialROIsReader.class).error("Error creating the envelope", (Object)e);
        }
        this.store = store;
        this.featureStore = new FeatureStore[1];
        this.featureStore[0] = featureStore;
    }

    public VectorialROIsReader(String filename, RasterDataStore store, IProjection projection) throws ROIException, FileNotExistsException {
        Rectangle2D e = store.getExtent().toRectangle2D();
        try {
            Envelope env = GeometryLocator.getGeometryManager().createEnvelope(e.getX(), e.getY(), e.getMaxX(), e.getMaxY(), 0);
            this.init(filename, store, projection, env);
        }
        catch (CreateEnvelopeException e1) {
            LoggerFactory.getLogger(VectorialROIsReader.class).error("Error creating the envelope", (Object)e);
        }
    }

    public VectorialROIsReader(String filename, RasterDataStore store, IProjection projection, Envelope bbox) throws ROIException, FileNotExistsException {
        this.init(filename, store, projection, bbox);
    }

    public void init(String filename, RasterDataStore store, IProjection projection, Envelope bbox) throws ROIException, FileNotExistsException {
        this.store = store;
        this.bbox = bbox;
        File file = new File(filename);
        if (file.exists()) {
            this.featureStore = new FeatureStore[1];
            this.featureStore[0] = this.openOneROIFile(file, projection);
        } else {
            file = new File(filename + ".shp");
            if (file.exists()) {
                this.featureStore = new FeatureStore[1];
                this.featureStore[0] = this.openOneROIFile(file, projection);
            } else {
                this.featureStore = this.openThreeROIFiles(filename, projection);
            }
        }
    }

    private FeatureStore[] openThreeROIFiles(String filename, IProjection projection) throws ROIException, FileNotExistsException {
        FeatureStore[] featureStore = new FeatureStore[3];
        if (filename.endsWith(".shp")) {
            filename = filename.substring(0, filename.lastIndexOf(".shp"));
        }
        File file = new File(filename + "_polygons.shp");
        boolean existsAtLeastOne = false;
        if (file.exists()) {
            featureStore[0] = this.openOneROIFile(file, projection);
            existsAtLeastOne = true;
        }
        if ((file = new File(filename + "_points.shp")).exists()) {
            featureStore[1] = this.openOneROIFile(file, projection);
            existsAtLeastOne = true;
        }
        if ((file = new File(filename + "_polylines.shp")).exists()) {
            featureStore[2] = this.openOneROIFile(file, projection);
            existsAtLeastOne = true;
        }
        if (!existsAtLeastOne) {
            throw new FileNotExistsException("file not found");
        }
        return featureStore;
    }

    private FeatureStore openOneROIFile(File file, IProjection projection) throws ROIException {
        DataManager datamanager = DALLocator.getDataManager();
        SHPStoreParameters params = null;
        try {
            params = (SHPStoreParameters)datamanager.createStoreParameters(SHPStoreProvider.NAME);
            params.setCRS(projection);
        }
        catch (InitializeException e) {
            throw new ROIException(e.getMessage(), (Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new ROIException(e.getMessage(), (Throwable)e);
        }
        params.setFile(file);
        DataManager dataManager = DALLocator.getDataManager();
        try {
            return (FeatureStore)dataManager.openStore(params.getDataStoreName(), (DataStoreParameters)params);
        }
        catch (ValidateDataParametersException e) {
            throw new ROIException(e.getMessage(), (Throwable)e);
        }
        catch (InitializeException e) {
            throw new ROIException(e.getMessage(), (Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new ROIException(e.getMessage(), (Throwable)e);
        }
    }

    public List<ROI> read(List<ROI> existingROIs) throws ROIException {
        for (int i = 0; i < this.featureStore.length; ++i) {
            try {
                existingROIs = this.read(existingROIs, this.featureStore[i]);
                continue;
            }
            catch (InvalidROIsShpException e) {
                throw new ROIException("", (Throwable)((Object)e));
            }
            catch (DataException e) {
                throw new ROIException("", (Throwable)e);
            }
        }
        return existingROIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ROI> read(List<ROI> existingROIs, FeatureStore featureStore) throws InvalidROIsShpException, DataException {
        FeatureType featureType = featureStore.getDefaultFeatureType();
        long id = System.currentTimeMillis();
        int nameFieldIndex = featureType.getIndex("name");
        int rFiledIndex = featureType.getIndex("R");
        int gFiledIndex = featureType.getIndex("G");
        int bFiledIndex = featureType.getIndex("B");
        if (existingROIs != null) {
            this.rois = new HashMap();
            for (int i = 0; i < existingROIs.size(); ++i) {
                VectorialROIImpl roi = (VectorialROIImpl)existingROIs.get(i);
                this.rois.put(roi.getName(), (ROI)roi);
            }
        }
        int r = 255;
        int g = 0;
        int b = 0;
        FeatureSet set = null;
        DisposableIterator features = null;
        try {
            set = featureStore.getFeatureSet();
            features = set.fastIterator();
            String defaultROIName = "ROI";
            while (features.hasNext()) {
                Feature feature = (Feature)features.next();
                if (feature.getDefaultGeometry() == null || feature.getDefaultGeometry() instanceof NullGeometry || feature.getDefaultGeometry() != null && !feature.getDefaultGeometry().getEnvelope().intersects(this.bbox)) continue;
                String roiName = nameFieldIndex >= 0 ? feature.getString(nameFieldIndex).toString() : defaultROIName + "-" + id++;
                VectorialROIImpl roi = null;
                if (!this.rois.containsKey(roiName)) {
                    roi = new VectorialROIImpl(this.store);
                    roi.setName(roiName);
                    if (rFiledIndex >= 0) {
                        r = ((Number)feature.get(rFiledIndex)).intValue();
                    }
                    if (gFiledIndex >= 0) {
                        g = ((Number)feature.get(gFiledIndex)).intValue();
                    }
                    if (bFiledIndex >= 0) {
                        b = ((Number)feature.get(bFiledIndex)).intValue();
                    }
                    roi.setColor(new Color(r, g, b));
                    this.rois.put(roi.getName(), (ROI)roi);
                } else {
                    roi = (VectorialROIImpl)this.rois.get(roiName);
                }
                roi.addGeometry(feature.getDefaultGeometry());
            }
        }
        finally {
            if (features != null) {
                features.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
        return new ArrayList<ROI>(this.rois.values());
    }
}

