/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.roi;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.raster.impl.grid.roi.VectorialROIImpl;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roi.ROIWriter;

public class VectorialROIsWriter
implements ROIWriter {
    private String baseFilename = null;
    private IProjection projection = null;
    private FeatureStore surfaceFS = null;
    private FeatureStore pointFS = null;
    private FeatureStore curveFS = null;

    public VectorialROIsWriter(String baseFilename, IProjection projection) {
        this.baseFilename = baseFilename;
        this.projection = projection;
    }

    public void write(List<ROI> rois) {
        int i;
        if (rois.size() > 0 && !(rois.get(0) instanceof VectorialROIImpl)) {
            return;
        }
        boolean monoType = true;
        int geometryType = -1;
        List<Geometry> geometries = null;
        Object[] values = new Object[4];
        if (this.baseFilename.endsWith(".shp")) {
            this.baseFilename = this.baseFilename.replaceAll(".shp", "");
        }
        block2: for (i = 0; i < rois.size(); ++i) {
            geometries = ((VectorialROIImpl)rois.get(i)).getGeometries();
            Iterator<Geometry> iterator = geometries.iterator();
            while (iterator.hasNext()) {
                if (geometryType < 0) {
                    geometryType = iterator.next().getType();
                    continue;
                }
                if (geometryType == iterator.next().getType()) continue;
                monoType = false;
                continue block2;
            }
        }
        if (monoType) {
            this.create(this.baseFilename + ".shp", this.projection, geometryType);
        } else {
            this.create(this.baseFilename + "_polygons" + ".shp", this.projection, 3);
            this.create(this.baseFilename + "_points" + ".shp", this.projection, 1);
            this.create(this.baseFilename + "_polylines" + ".shp", this.projection, 2);
        }
        for (i = 0; i < rois.size(); ++i) {
            geometries = ((VectorialROIImpl)rois.get(i)).getGeometries();
            values[0] = rois.get(i).getName();
            values[1] = new Integer(rois.get(i).getColor().getRed());
            values[2] = new Integer(rois.get(i).getColor().getGreen());
            values[3] = new Integer(rois.get(i).getColor().getBlue());
            for (Geometry geometry : geometries) {
                this.addFeature(geometry, values);
            }
        }
        try {
            if (this.surfaceFS != null) {
                this.surfaceFS.finishEditing();
            }
            if (this.pointFS != null) {
                this.pointFS.finishEditing();
            }
            if (this.curveFS != null) {
                this.curveFS.finishEditing();
            }
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }

    private void addFeature(Geometry geom, Object[] values) {
        try {
            switch (geom.getType()) {
                case 3: {
                    if (this.surfaceFS != null) {
                        EditableFeature ef = this.surfaceFS.createNewFeature();
                        ef.set("name", values[0]);
                        ef.set("R", values[1]);
                        ef.set("G", values[2]);
                        ef.set("B", values[3]);
                        ef.set("GEOMETRY", (Object)geom);
                        this.surfaceFS.insert(ef);
                    }
                    break;
                }
                case 1: {
                    if (this.pointFS != null) {
                        EditableFeature ef = this.pointFS.createNewFeature();
                        ef.set("name", values[0]);
                        ef.set("R", values[1]);
                        ef.set("G", values[2]);
                        ef.set("B", values[3]);
                        ef.set("GEOMETRY", (Object)geom);
                        this.pointFS.insert(ef);
                    }
                    break;
                }
                case 2: {
                    if (this.curveFS != null) {
                        EditableFeature ef = this.curveFS.createNewFeature();
                        ef.set("name", values[0]);
                        ef.set("R", values[1]);
                        ef.set("G", values[2]);
                        ef.set("B", values[3]);
                        ef.set("GEOMETRY", (Object)geom);
                        this.curveFS.insert(ef);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void create(String filename, IProjection crs, int geometryType) {
        File newFile = new File(filename);
        try {
            DataManager datamanager = DALLocator.getDataManager();
            FilesystemServerExplorerParameters explorerParams = (FilesystemServerExplorerParameters)datamanager.createServerExplorerParameters("FilesystemExplorer");
            explorerParams.setRoot(newFile.getParent());
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)datamanager.createServerExplorer((DataServerExplorerParameters)explorerParams);
            NewFeatureStoreParameters newParams = (NewFeatureStoreParameters)explorer.getAddParameters(newFile);
            EditableFeatureType featureType = this.getFeatureType(newParams);
            EditableFeatureAttributeDescriptor efad = featureType.add("GEOMETRY", 66);
            efad.setGeometryType(geometryType);
            efad.setSRS(crs);
            featureType.setDefaultGeometryAttributeName("GEOMETRY");
            explorer.add(newParams.getDataStoreName(), (NewDataStoreParameters)newParams, true);
            switch (geometryType) {
                case 3: {
                    this.surfaceFS = (FeatureStore)datamanager.createStore((DataStoreParameters)newParams);
                    this.surfaceFS.edit(2);
                    break;
                }
                case 1: {
                    this.pointFS = (FeatureStore)datamanager.createStore((DataStoreParameters)newParams);
                    this.pointFS.edit(2);
                    break;
                }
                case 2: {
                    this.curveFS = (FeatureStore)datamanager.createStore((DataStoreParameters)newParams);
                    this.curveFS.edit(2);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private EditableFeatureType getFeatureType(NewFeatureStoreParameters newParams) {
        EditableFeatureType eft = newParams.getDefaultFeatureType();
        eft.add("name", 8, 20);
        eft.add("R", 4, 4);
        eft.add("G", 4, 4);
        eft.add("B", 4, 4);
        return eft;
    }
}

