/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.process;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.TreeMap;
import org.gvsig.raster.impl.process.RasterTask;

public class RasterTaskQueue {
    private static TreeMap<String, RasterTask> processPool = new TreeMap();
    private static ArrayList<String> processID = new ArrayList();

    public static void register(RasterTask process) {
        processPool.put(process.getID(), process);
        processID.add(process.getID());
    }

    public static void remove(RasterTask process) {
        processPool.remove(process.getID());
        for (int i = 0; i < processID.size(); ++i) {
            if (processID.get(i).compareTo(process.getID()) != 0) continue;
            processID.remove(i);
            break;
        }
    }

    public static RasterTask get(String id) {
        return processPool.get(id) == null ? new RasterTask(null) : processPool.get(id);
    }

    public static RasterTask getRasterTask(String id) {
        return processPool.get(id);
    }

    public static void sendSignal(String id, EventObject ev) {
        RasterTask obj = processPool.get(id);
        if (obj != null && obj instanceof RasterTask) {
            obj.setEvent(ev);
        }
    }

    public static void sendSignal(EventObject ev) {
        for (int i = 0; i < processID.size(); ++i) {
            String id = processID.get(i);
            RasterTaskQueue.sendSignal(id, ev);
        }
    }
}

