/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.CloneException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Metadata;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.store.props.TimeSeries;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.spi.AbstractCoverageStoreProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.DefaultNoData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.datastruct.serializer.ColorTableRmfSerializer;
import org.gvsig.raster.impl.datastruct.serializer.NoDataRmfSerializer;
import org.gvsig.raster.impl.provider.DefaultTimeSerials;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.SimpleProviderHistogramComputer;
import org.gvsig.raster.impl.store.properties.SimpleProviderStatistics;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.raster.impl.store.rmf.RmfBlocksManager;
import org.gvsig.raster.impl.store.serializer.ColorInterpretationRmfSerializer;
import org.gvsig.raster.impl.store.serializer.GeoInfoRmfSerializer;
import org.gvsig.raster.impl.store.serializer.GeoPointListRmfSerializer;
import org.gvsig.raster.impl.store.serializer.ProjectionRmfSerializer;
import org.gvsig.raster.impl.store.serializer.StatisticsRmfSerializer;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRasterProvider
extends AbstractCoverageStoreProvider
implements RasterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRasterProvider.class);
    public static final int RED_BAND = 1;
    public static final int GREEN_BAND = 2;
    public static final int BLUE_BAND = 4;
    public static final int ALPHA_BAND = 8;
    protected int bandCount = 1;
    private int[] dataType = null;
    protected NoData noData = null;
    protected Statistics stats = null;
    protected HistogramComputer histogram = null;
    protected DataStoreParameters param = null;
    protected DataStoreProviderServices storeServices = null;
    protected RmfBlocksManager rmfBlocksManager = null;
    protected ColorTable colorTable = null;
    private ColorInterpretation colorInterpretation = null;
    protected TimeSeries serialInfo = null;
    protected Transparency transparency = null;
    protected TileServer tileServer = null;
    protected GeoPointList geoPointList = null;
    protected FileUtils fileUtil = RasterLocator.getManager().getFileUtils();
    protected RasterUtils rasterUtil = RasterLocator.getManager().getRasterUtils();
    protected IProjection proj = null;
    protected long fileSize = 0L;
    protected long bytesReaded = 0L;
    protected long lineCnt = 0L;
    protected URI uri;
    protected String selectedSubdatasetID = null;
    protected AffineTransform ownTransformation = null;
    protected AffineTransform externalTransformation = null;
    private static Logger logger = LoggerFactory.getLogger((String)AbstractRasterProvider.class.getName());

    public AbstractRasterProvider(AbstractRasterDataParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        super((DataStoreParameters)params, storeServices, metadata);
        if (params.getURI() != null) {
            File f;
            this.uri = params.getURI();
            if ("FILE".equalsIgnoreCase(this.uri.getScheme()) && (f = new File(this.uri)).exists()) {
                this.setFileSize(f.length());
            }
            this.uri = this.translateURI(this.uri);
        }
        if (params != null && params.getSRS() != null) {
            try {
                this.setProjection(params.getSRS(), false);
            }
            catch (RmfSerializerException e) {
                LOG.warn("Can not persist {} parameter projection to {} provider", new Object[]{params.getSRSID(), this.getName()});
            }
        }
        this.ownTransformation = new AffineTransform();
        this.externalTransformation = new AffineTransform();
    }

    public AbstractRasterProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        super(params, storeServices, metadata);
        RasterDataParameters rasterParameters = (RasterDataParameters)params;
        URI uriParam = rasterParameters.getURI();
        if (uriParam != null) {
            File f;
            if ("FILE".equalsIgnoreCase(uriParam.getScheme()) && (f = new File(uriParam)).exists()) {
                this.setFileSize(f.length());
            }
            if (params instanceof RemoteStoreParameters) {
                this.uri = this.translateURI(uriParam);
            }
        }
        if (rasterParameters != null && rasterParameters.getSRS() != null) {
            try {
                this.setProjection(rasterParameters.getSRS(), false);
            }
            catch (RmfSerializerException e) {
                LOG.warn("Can not persist {} parameter projection to {} provider", new Object[]{rasterParameters.getSRSID(), this.getName()});
            }
        }
        this.ownTransformation = new AffineTransform();
        this.externalTransformation = new AffineTransform();
    }

    public AbstractRasterProvider(String params) {
    }

    public AbstractRasterProvider(URI uri) {
    }

    public AbstractRasterProvider() {
        super(null, null, null);
    }

    @Override
    public String[] getFormatList() {
        return null;
    }

    protected void init() {
    }

    public boolean isRGB() {
        if (this.getDataType()[0] == 0) {
            ColorInterpretation ci = this.getColorInterpretation();
            return ci.isRGB();
        }
        return false;
    }

    public boolean isARGB() {
        if (this.getDataType()[0] == 0) {
            ColorInterpretation ci = this.getColorInterpretation();
            return ci.isRGBA();
        }
        return false;
    }

    @Override
    public boolean isTiled() {
        return false;
    }

    @Override
    public boolean isTimeSupported() {
        return false;
    }

    @Override
    public RasterProvider cloneProvider() throws CloneException {
        try {
            DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
            AbstractRasterProvider provider = (AbstractRasterProvider)dataManager.createProvider(this.storeServices, this.param);
            provider.histogram = this.histogram;
            provider.stats = this.stats;
            return provider;
        }
        catch (ProviderNotRegisteredException e) {
            e.printStackTrace();
        }
        catch (InitializeException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AbstractRasterProvider singleDatasetInstance(DataStoreProviderServices storeServices, String param) throws RasterDriverException {
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        FilesystemServerExplorer serverExplorer = null;
        try {
            FilesystemServerExplorerParameters paramsExplorer = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
            paramsExplorer.setRoot(File.separator);
            serverExplorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)paramsExplorer);
        }
        catch (ValidateDataParametersException e) {
            throw new RasterDriverException("Error validating parameters", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error creating a server explorer ", (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Provider not registered", (Exception)((Object)e));
        }
        File file = new File(param);
        List provName = serverExplorer.getProviderNameList(file);
        if (provName.size() > 0) {
            for (int i = 0; i < provName.size(); ++i) {
                if (((String)provName.get(i)).compareTo("Tile Store") == 0) continue;
                try {
                    DataStoreParameters newparams = dataManager.createStoreParameters((String)provName.get(i));
                    ((FilesystemStoreParameters)newparams).setFile(file);
                    if (storeServices == null) {
                        storeServices = new DefaultRasterStore();
                    }
                    return (AbstractRasterProvider)dataManager.createProvider(storeServices, newparams);
                }
                catch (InitializeException e) {
                    throw new RasterDriverException("Error creating a server explorer ", (Exception)((Object)e));
                }
                catch (ProviderNotRegisteredException e) {
                    throw new RasterDriverException("Provider not registered", (Exception)((Object)e));
                }
            }
        }
        return null;
    }

    public abstract RasterProvider load();

    @Override
    public abstract double getWidth();

    @Override
    public abstract double getHeight();

    public abstract void setView(Extent var1);

    @Override
    public abstract Extent getView();

    @Override
    public abstract Object getData(int var1, int var2, int var3) throws InvalidSetViewException, FileNotOpenException, RasterDriverException;

    @Override
    public Buffer getDataSet(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
        SpiRasterQuery q = query;
        this.loadBuffer(q);
        return q.getBufferForProviders();
    }

    public abstract void loadBuffer(SpiRasterQuery var1) throws ProcessInterruptedException, RasterDriverException;

    public abstract int getBlockSize();

    @Override
    public abstract int getOverviewHeight(int var1, int var2) throws BandAccessException, RasterDriverException;

    @Override
    public abstract boolean isOverviewsSupported();

    @Override
    public void reload() {
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
        }
        catch (ParsingException e) {
            logger.debug("No se ha podido leer el RMF", (Throwable)e);
        }
    }

    protected void loadFromRmf(RmfBlocksManager manager) throws ParsingException {
        if (!manager.checkRmf()) {
            return;
        }
        if (!new File(manager.getPath()).exists()) {
            return;
        }
        GeoInfoRmfSerializer geoInfoSerializer = new GeoInfoRmfSerializer(this);
        ColorTableRmfSerializer colorTableSerializer = new ColorTableRmfSerializer();
        GeoPointListRmfSerializer gcpSerializer = new GeoPointListRmfSerializer();
        NoDataRmfSerializer noDataSerializer = null;
        if (this.noData == null) {
            this.noData = new DefaultNoData(null, null, manager.getPath(), this.getBandCount());
        }
        noDataSerializer = new NoDataRmfSerializer((DefaultNoData)this.noData);
        ColorInterpretationRmfSerializer colorInterpSerializer = new ColorInterpretationRmfSerializer();
        ProjectionRmfSerializer projectionRmfSerializer = new ProjectionRmfSerializer();
        StatisticsRmfSerializer statsRmfSerializer = new StatisticsRmfSerializer(this.getStatistics());
        manager.addClient(geoInfoSerializer);
        manager.addClient(colorTableSerializer);
        manager.addClient(gcpSerializer);
        manager.addClient(noDataSerializer);
        manager.addClient(colorInterpSerializer);
        manager.addClient(projectionRmfSerializer);
        manager.addClient(statsRmfSerializer);
        manager.read(null);
        manager.removeAllClients();
        if (colorTableSerializer.getResult() != null) {
            this.setColorTable((ColorTable)colorTableSerializer.getResult());
        }
        if (colorInterpSerializer.getResult() != null) {
            DataStoreColorInterpretation ci = (DataStoreColorInterpretation)colorInterpSerializer.getResult();
            this.setColorInterpretation(ci);
            this.getTransparency().setColorInterpretation((ColorInterpretation)ci);
            this.getTransparency().setTransparencyBand(ci.getBand("Alpha"));
        }
        if (projectionRmfSerializer.getResult() != null) {
            this.proj = (IProjection)projectionRmfSerializer.getResult();
        }
        if (gcpSerializer.getResult() != null && gcpSerializer.getResult() instanceof GeoPointList && ((GeoPointList)gcpSerializer.getResult()).size() > 0) {
            this.setGeoPointList((GeoPointList)gcpSerializer.getResult());
        }
    }

    @Override
    public int getBandCount() {
        return this.bandCount;
    }

    @Override
    public int[] getDataType() {
        return this.dataType;
    }

    public void setDataType(int[] dataType) {
        this.dataType = dataType;
    }

    @Override
    public double getPixelSizeX() {
        return this.externalTransformation.getScaleX();
    }

    @Override
    public double getPixelSizeY() {
        return this.externalTransformation.getScaleY();
    }

    @Override
    public NoData getNoDataValue() {
        if (this.noData == null) {
            this.noData = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.getBandCount(), this.getDataType()[0]);
            this.noData.setNoDataTransparent(false);
            File rmfFile = this.getRMFFile();
            if (rmfFile != null) {
                this.noData.setFileName(rmfFile.getName());
            }
        }
        return this.noData;
    }

    @Override
    public void setNoDataValue(NoData value) {
        this.noData = value;
    }

    @Override
    public boolean isGeoreferenced() {
        return true;
    }

    @Override
    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.externalTransformation.transform(pt, p);
        return p;
    }

    @Override
    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.externalTransformation.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    @Override
    public Extent getExtent() {
        return new ExtentImpl(this.rasterToWorld(new Point2D.Double(0.0, 0.0)), this.rasterToWorld(new Point2D.Double(this.getWidth(), this.getHeight())), this.rasterToWorld(new Point2D.Double(this.getWidth(), 0.0)), this.rasterToWorld(new Point2D.Double(0.0, this.getHeight())));
    }

    @Override
    public Extent getExtentWithoutRot() {
        AffineTransform at = new AffineTransform(this.externalTransformation.getScaleX(), 0.0, 0.0, this.externalTransformation.getScaleY(), this.externalTransformation.getTranslateX(), this.externalTransformation.getTranslateY());
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(this.getWidth(), this.getHeight());
        at.transform(p1, p1);
        at.transform(p2, p2);
        return new ExtentImpl(p1, p2);
    }

    public void setParam(DataStoreProviderServices provServices, DataStoreParameters param) {
        if (param instanceof RasterDataParameters) {
            this.uri = ((RasterDataParameters)param).getURI();
        }
        this.param = param;
        this.storeServices = provServices;
    }

    @Override
    public abstract int getOverviewWidth(int var1, int var2) throws BandAccessException, RasterDriverException;

    @Override
    public void selectSubdataset() {
    }

    protected void selectSubdataset(String subdataset) {
        this.selectedSubdatasetID = subdataset;
        this.getRmfBlocksManager().setPath(this.getRMFFile().getPath());
    }

    public RmfBlocksManager getRmfBlocksManager() {
        File fileRMF = this.getRMFFile();
        if (!(fileRMF == null || this.rmfBlocksManager != null && fileRMF.equals(this.rmfBlocksManager))) {
            this.rmfBlocksManager = new RmfBlocksManager(fileRMF.getPath());
        }
        return this.rmfBlocksManager;
    }

    @Override
    public File getRMFFile() {
        String tail = this.selectedSubdatasetID == null ? ".rmf" : "-sd" + this.selectedSubdatasetID + ".rmf";
        File rmfFolder = this.getDataParameters() != null && this.getDataParameters() instanceof RasterDataParameters ? this.getDataParameters().getRMFFolder() : null;
        URI objUri = this.getURI();
        if ("FILE".equalsIgnoreCase(objUri.getScheme())) {
            File file = new File(objUri);
            String fileName = FilenameUtils.getBaseName((String)new File(objUri).getAbsolutePath());
            if (rmfFolder == null) {
                rmfFolder = file.getParentFile();
                if (this.getDataParameters() != null && this.getDataParameters() instanceof RasterDataParameters) {
                    this.getDataParameters().setRMFFolder(rmfFolder);
                }
            }
            return new File(rmfFolder.getAbsolutePath() + File.separator + fileName + tail);
        }
        return new File(this.getRMFFileForRemoteServices(this.getName()));
    }

    protected String getRMFFileForRemoteServices(String layerName) {
        String md5 = "";
        try {
            md5 = RasterLocator.getManager().getFileUtils().convertPathToMD5(this.uri.toString());
        }
        catch (LocatorException e) {
            logger.debug("Error getting the Locator", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug("Error getting the algorithm MD5", (Throwable)e);
        }
        File path = new File(RasterLibrary.pathRMFRemote);
        if (!path.exists()) {
            path.mkdir();
        }
        return RasterLibrary.pathRMFRemote + File.separator + md5 + "-" + layerName + ".rmf";
    }

    @Override
    public boolean isInside(Point2D p) {
        Point2D.Double pt = new Point2D.Double();
        try {
            this.getAffineTransform().inverseTransform(p, pt);
            if (((Point2D)pt).getX() >= 0.0 && ((Point2D)pt).getX() < this.getWidth() && ((Point2D)pt).getY() >= 0.0 && ((Point2D)pt).getY() < this.getHeight()) {
                return true;
            }
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isRotated() {
        return this.externalTransformation.getShearX() != 0.0 || this.externalTransformation.getShearY() != 0.0;
    }

    @Override
    public boolean isMultiFile() {
        return false;
    }

    @Override
    public boolean isMosaic() {
        return false;
    }

    @Override
    public boolean isReproyectable() {
        return true;
    }

    @Override
    public String getWktProjection() {
        if (this.proj != null && RasterLocator.getManager().isCRSUtilSupported()) {
            return RasterLocator.getManager().getCRSUtils().convertIProjectionToWkt(this.proj);
        }
        return null;
    }

    @Override
    public void saveObjectToRmf(Class<?> class1, Object value) throws RmfSerializerException {
        if (this.getRmfBlocksManager() != null) {
            ((DefaultProviderServices)RasterLocator.getManager().getProviderServices()).saveObjectToRmfFile(this.getRmfBlocksManager(), class1, value);
        }
    }

    private static Object loadObjectFromRmfFile(RmfBlocksManager blocksManager, Class<?> class1, Object value) throws RmfSerializerException {
        ClassSerializer serializerObject = ((DefaultProviderServices)RasterLocator.getManager().getProviderServices()).getSerializerObject(class1, value);
        if (serializerObject == null) {
            throw new RmfSerializerException("No se ha podido encontrar el serializador para el Rmf");
        }
        if (!blocksManager.checkRmf()) {
            throw new RmfSerializerException("Error al comprobar el fichero Rmf");
        }
        blocksManager.addClient(serializerObject);
        try {
            blocksManager.read(null);
        }
        catch (ParsingException e) {
            throw new RmfSerializerException("Error al leer el fichero Rmf", (Exception)((Object)e));
        }
        blocksManager.removeAllClients();
        return serializerObject.getResult();
    }

    @Override
    public Object loadObjectFromRmf(Class<?> class1, Object value) throws RmfSerializerException {
        RmfBlocksManager blocksManager = this.getRmfBlocksManager();
        if (blocksManager != null) {
            return AbstractRasterProvider.loadObjectFromRmfFile(blocksManager, class1, value);
        }
        return null;
    }

    public static Object loadObjectFromRmfFile(String file, Class<?> class1, Object value) throws RmfSerializerException {
        String fileRMF = RasterLocator.getManager().getFileUtils().getNameWithoutExtension(file) + ".rmf";
        RmfBlocksManager blocksManager = new RmfBlocksManager(fileRMF);
        return AbstractRasterProvider.loadObjectFromRmfFile(blocksManager, class1, value);
    }

    public void saveObjectToRmf(Object value) throws RmfSerializerException {
        this.saveObjectToRmf(value.getClass(), value);
    }

    public Object loadObjectFromRmf(Object value) throws RmfSerializerException {
        return this.loadObjectFromRmf(value.getClass(), value);
    }

    @Override
    public double getCellSize() {
        try {
            Extent e = this.getExtent();
            double dCellsize = (e.getMax().getX() - e.getMin().getX()) / this.getWidth();
            return dCellsize;
        }
        catch (NullPointerException e) {
            return 1.0;
        }
    }

    public RasterProvider newProvider() {
        return null;
    }

    @Override
    public ColorTable getColorTable() {
        return this.colorTable;
    }

    @Override
    public Image getImageLegend() {
        return null;
    }

    @Override
    public void setColorTable(ColorTable value) {
        this.colorTable = value;
    }

    @Override
    public Transparency getTransparency() {
        return this.transparency;
    }

    @Override
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public ColorInterpretation getColorInterpretation() {
        return this.colorInterpretation;
    }

    @Override
    public void setColorInterpretation(ColorInterpretation colorInterpretation) {
        this.colorInterpretation = colorInterpretation;
    }

    @Override
    public Statistics getStatistics() {
        if (this.stats == null) {
            this.stats = new SimpleProviderStatistics(this);
        }
        return this.stats;
    }

    @Override
    public void setStatistics(Statistics stats) throws RmfSerializerException {
        this.stats = stats;
        this.saveObjectToRmf(Statistics.class, stats);
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogram == null) {
            this.histogram = new SimpleProviderHistogramComputer(this);
        }
        return this.histogram;
    }

    public void doDispose() {
    }

    public DataServerExplorer getExplorer() throws ReadException, ValidateDataParametersException {
        return null;
    }

    @Override
    public RasterDataParameters getDataParameters() {
        if (this.getDataStoreParameters() instanceof RasterDataParameters) {
            return (RasterDataParameters)this.getDataStoreParameters();
        }
        return null;
    }

    public Iterator<?> getChilds() {
        return null;
    }

    public ResourceProvider getResource() {
        return null;
    }

    public Object getSourceId() {
        if (this.getDataParameters() instanceof RasterFileStoreParameters) {
            return ((RasterFileStoreParameters)this.getDataParameters()).getFile();
        }
        return this.getDataParameters().getURI();
    }

    public void open() throws OpenException {
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public final String translateFileName(String fileName) {
        return fileName;
    }

    @Override
    public String getFileSuffix() {
        String path = new File(this.getURIOfFirstProvider()).getAbsolutePath();
        return FilenameUtils.getExtension((String)path);
    }

    @Override
    public URI getURIOfFirstProvider() {
        return this.getURI();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setFName(String n) {
        File file = new File(n);
        this.uri = file.toURI();
    }

    public String getName() {
        String pathName = null;
        try {
            URI x = this.getURI();
            pathName = new File(x).getAbsolutePath();
            return FilenameUtils.getBaseName((String)pathName);
        }
        catch (Throwable th1) {
            try {
                return FilenameUtils.getBaseName((String)this.uri.getPath());
            }
            catch (Throwable th2) {
                return this.uri.getPath();
            }
        }
    }

    public String getFullName() {
        if (this.uri != null && "FILE".equalsIgnoreCase(this.uri.getScheme())) {
            return new File(this.uri).getAbsolutePath();
        }
        return this.uri.toString();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long sz) {
        this.fileSize = sz;
    }

    @Override
    public IProjection getProjection() {
        return this.proj;
    }

    @Override
    public void setProjection(IProjection proj, boolean persist) throws RmfSerializerException {
        this.proj = proj;
        if (persist) {
            this.saveObjectToRmf(IProjection.class, proj);
        }
    }

    protected long getTime() {
        return new Date().getTime();
    }

    @Override
    public void setAffineTransform(AffineTransform t) {
        this.externalTransformation = (AffineTransform)t.clone();
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this.externalTransformation;
    }

    public void resetAffineTransform() {
        this.externalTransformation.setToIdentity();
    }

    @Override
    public AffineTransform getOwnAffineTransform() {
        return this.ownTransformation;
    }

    @Override
    public String getInfoByPoint(double x, double y, ICancellable cancellable) throws InfoByPointException {
        return null;
    }

    @Override
    public String getInfoByPoint(int x, int y, Extent bbox, int w, int h, ICancellable cancellable) throws InfoByPointException {
        return null;
    }

    public void setTileServer(Class<?> tileServer) throws InitializeException {
    }

    public int[] getTileSize(int level) {
        return new int[]{0, 0};
    }

    @Override
    public boolean isRasterEnclosed() {
        return false;
    }

    @Override
    public int getSourceType() {
        String scheme = this.getURI().getScheme();
        if ("PG".equalsIgnoreCase(scheme)) {
            return 1;
        }
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            return 2;
        }
        return 0;
    }

    @Override
    public void deleteLayerFromCache() {
    }

    @Override
    public TimeSeries getTimeSerials() throws RmfSerializerException {
        if (this.serialInfo == null) {
            this.serialInfo = new DefaultTimeSerials();
            this.loadObjectFromRmf(TimeSeries.class, this.serialInfo);
            this.serialInfo.selectSerial(0);
        }
        return this.serialInfo;
    }

    @Override
    public void setTimeSerials(TimeSeries serialInfo) throws RmfSerializerException {
        this.serialInfo = serialInfo;
        this.saveObjectToRmf(TimeSeries.class, serialInfo);
    }

    @Override
    public long[] getFileSizeByProvider() {
        return new long[]{this.getFileSize()};
    }

    @Override
    public URI[] getURIByProvider() {
        return new URI[]{this.getURIOfFirstProvider()};
    }

    @Override
    public int[] getBandCountByProvider() {
        return new int[]{this.getBandCount()};
    }

    @Override
    public int getInternalProviderCount() {
        return 1;
    }

    @Override
    public RasterProvider getInternalProvider(int i) {
        return this;
    }

    @Override
    public URI getURIByBand(int band) {
        return this.getURIOfFirstProvider();
    }

    @Override
    public int getBandPositionByProvider(int band) {
        return band;
    }

    @Override
    public int getSubdatasetCount() {
        return 0;
    }

    @Override
    public boolean needEnhanced() {
        return false;
    }

    public Interval getInterval() {
        return null;
    }

    public Collection<?> getTimes() {
        return null;
    }

    public Collection<?> getTimes(Interval interval) {
        return null;
    }

    @Override
    public GeoPointList getGeoPointList() {
        return this.geoPointList;
    }

    @Override
    public void setGeoPointList(GeoPointList geoPointList) {
        this.geoPointList = geoPointList;
    }

    public BandList getDefaultBandList() {
        BandListImpl bandList = new BandListImpl();
        URI[] uriByProvider = this.getURIByProvider();
        int[] nBandsByProvider = this.getBandCountByProvider();
        for (int iProvider = 0; iProvider < uriByProvider.length; ++iProvider) {
            for (int iBand = 0; iBand < nBandsByProvider[iProvider]; ++iBand) {
                try {
                    bandList.addBand(new DatasetBandImpl(new File(uriByProvider[iProvider]).getAbsolutePath(), iBand, this.getDataType()[0], nBandsByProvider[iProvider]));
                    continue;
                }
                catch (BandNotFoundInListException bandNotFoundInListException) {
                    // empty catch block
                }
            }
        }
        int[] drawableBands = new int[bandList.getBandCount()];
        for (int i = 0; i < bandList.getBandCount(); ++i) {
            drawableBands[i] = i;
        }
        bandList.setDrawableBands(drawableBands);
        return bandList;
    }

    @Override
    public void close() {
        if (this.transparency != null) {
            this.transparency.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.dataType = null;
        this.noData = null;
        this.stats = null;
        this.histogram = null;
        this.param = null;
        this.storeServices = null;
        this.rmfBlocksManager = null;
        this.colorTable = null;
        this.colorInterpretation = null;
        this.serialInfo = null;
        this.transparency = null;
        this.tileServer = null;
        this.fileUtil = null;
        this.rasterUtil = null;
        this.proj = null;
        this.uri = null;
        this.selectedSubdatasetID = null;
        this.ownTransformation = null;
        this.externalTransformation = null;
    }

    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        return null;
    }

    public StoresRepository getStoresRepository() {
        return null;
    }

    public ResourcesStorage getResourcesStorage() {
        return null;
    }
}

