/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.fusion;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;

public class PixelSquareStructure {
    public double pixelSize = 0.0;
    public int dataType = 32;
    public int bandCount = 0;
    public int width = 0;
    public int height = 0;
    public Extent bbox = null;
    public NoData nodata = null;
    public Buffer buffer = null;

    public PixelSquareStructure(Buffer buf, Extent bbox, double pixelSize) {
        this.pixelSize = pixelSize;
        this.dataType = buf.getDataType();
        this.bandCount = buf.getBandCount();
        this.width = buf.getWidth();
        this.height = buf.getHeight();
        this.nodata = buf.getNoDataValue() != null ? buf.getNoDataValue() : RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.bandCount, this.dataType);
        this.bbox = bbox;
        this.buffer = buf;
    }

    public PixelSquareStructure(double pixelSize, int bandCount, int datatype) {
        this.pixelSize = pixelSize;
        this.dataType = datatype;
        this.bandCount = bandCount;
        this.width = (int)Math.ceil(this.bbox.width() * pixelSize);
        this.height = (int)Math.ceil(this.bbox.height() * pixelSize);
        this.nodata = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(bandCount, datatype);
    }
}

