/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.tile;

import java.io.File;
import java.net.URI;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.TileCacheManager;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.Downloader;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.provider.tile.TileDownloaderForFiles;

public class FileTileServer
implements TileServer {
    protected CacheStruct struct = null;
    protected Downloader downloader = null;
    protected RasterDataStore store = null;
    protected String suffix = "tif";
    protected boolean externalStruct = false;

    public FileTileServer(RasterDataStore store) {
        this.store = store;
    }

    public Downloader getDownloader() {
        boolean firstLoad;
        boolean bl = firstLoad = this.downloader == null;
        if (firstLoad || this.externalStruct) {
            this.downloader = new TileDownloaderForFiles(this.store, this.getStruct(), this.getStruct().getTileSizeByLevel(0)[0], this.getStruct().getTileSizeByLevel(0)[1], this.getFileSuffix());
            this.externalStruct = false;
            return this.downloader;
        }
        if (((TileDownloaderForFiles)this.downloader).getTileSize()[0] != TileCacheLibrary.DEFAULT_TILEWIDTH || ((TileDownloaderForFiles)this.downloader).getTileSize()[1] != TileCacheLibrary.DEFAULT_TILEHEIGHT) {
            this.downloader = new TileDownloaderForFiles(this.store, this.getStruct(), TileCacheLibrary.DEFAULT_TILEWIDTH, TileCacheLibrary.DEFAULT_TILEHEIGHT, this.getFileSuffix());
        }
        return this.downloader;
    }

    public CacheStruct getStruct() {
        if (this.struct == null) {
            TileCacheManager manager = TileCacheLocator.getManager();
            int coordinates = 1;
            if (this.store.getProjection() != null) {
                coordinates = this.store.getProjection() != null && this.store.getProjection().isProjected() ? 1 : 0;
            } else {
                Extent e = this.store.getExtent();
                if (e.getULX() >= -180.0 && e.getULX() <= 180.0 && e.getLRX() >= -180.0 && e.getLRX() <= 180.0 && e.getULY() >= -90.0 && e.getULY() <= 90.0 && e.getLRY() >= -90.0 && e.getLRY() <= 90.0) {
                    coordinates = 0;
                }
            }
            String epsg = null;
            IProjection proj = this.store.getProjection();
            if (proj != null) {
                epsg = proj.getAbrev();
            }
            URI uri = ((RasterDataParameters)this.store.getParameters()).getURI();
            this.struct = manager.createCacheStructure(coordinates, TileCacheLibrary.DEFAULT_LEVELS, this.store.getExtent().toRectangle2D(), this.store.getCellSize(), TileCacheLibrary.DEFAULT_TILEWIDTH, TileCacheLibrary.DEFAULT_TILEHEIGHT, new File(uri).getAbsolutePath(), TileCacheLibrary.DEFAULT_STRUCTURE, RasterLibrary.pathTileCache, this.getFileSuffix(), epsg, this.store.getFileSize());
        }
        return this.struct;
    }

    public void setStruct(CacheStruct struct) {
        if (struct != null) {
            this.struct = struct;
            if (struct.getTileSizeByLevel(0) != null) {
                this.downloader = new TileDownloaderForFiles(this.store, struct, struct.getTileSizeByLevel(0)[0], struct.getTileSizeByLevel(0)[1], this.getFileSuffix());
                this.externalStruct = true;
            }
        }
    }

    public String getFileSuffix() {
        return this.suffix;
    }

    public void setFileSuffix(String extension) {
        this.suffix = extension;
    }
}

