/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.gvsig.fmap.dal.DataCache;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataQuery;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.dal.coverage.process.vector.Vectorization;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Metadata;
import org.gvsig.fmap.dal.coverage.store.props.TimeSeries;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.CoverageSelection;
import org.gvsig.fmap.dal.raster.CoverageStore;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProviderServices;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.spi.DataStoreInitializer;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.DefaultRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.grid.render.DefaultRender;
import org.gvsig.raster.impl.process.vector.PotraceVectorization;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.store.DefaultCoverageStoreNotification;
import org.gvsig.raster.impl.store.FramedBufferResampling;
import org.gvsig.raster.impl.store.QueryableRaster;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObject_v2;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.undo.command.Command;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.gvsig.tools.visitor.Visitor;

public abstract class AbstractRasterDataStore
extends AbstractDisposable
implements RasterDataStore,
CoverageStoreProviderServices,
QueryableRaster,
DataStoreInitializer {
    public static final String PERSISTENT_NAME = "AbstractRasterDataStore_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "AbstractRasterDataStore Persistent";
    protected DefaultRasterQuery currentQuery = null;
    protected BandListImpl storeBandList = null;
    protected RasterProvider provider = null;
    protected Metadata metadata = null;
    private ColorTable[] palette = null;
    protected double nWidth = 0.0;
    protected double nHeight = 0.0;
    private Buffer lastBuffer = null;
    private DataManager dataManager = null;
    protected DataStoreParameters parameters = null;
    private DelegatedDynObject dynobj = null;
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);
    private Render render = null;
    protected RasterDataServerExplorer explorer = null;

    public BandList getDefaultBandList() {
        if (this.storeBandList == null) {
            this.initializeBandList();
        }
        return this.storeBandList;
    }

    public void initializeBandList() {
        if (this.provider != null) {
            this.storeBandList = new BandListImpl();
            this.storeBandList.clear();
            for (int i = 0; i < this.provider.getBandCount(); ++i) {
                try {
                    int dataType = this.provider.getDataType()[i];
                    URI uriByBand = this.provider.getURIByBand(i);
                    String filename = "FILE".equalsIgnoreCase(uriByBand.getScheme()) ? new File(uriByBand).getAbsolutePath() : uriByBand.toString();
                    DatasetBandImpl band = new DatasetBandImpl(filename, this.provider.getBandPositionByProvider(i), dataType, this.provider.getBandCount());
                    this.storeBandList.addBand(band, i);
                    continue;
                }
                catch (BandNotFoundInListException dataType) {
                    // empty catch block
                }
            }
            int[] drawableBands = new int[this.storeBandList.getBandCount()];
            for (int i = 0; i < this.storeBandList.getBandCount(); ++i) {
                drawableBands[i] = i;
            }
            this.storeBandList.setDrawableBands(drawableBands);
        }
    }

    public Buffer query(RasterQuery query) throws ProcessInterruptedException, QueryException {
        Object[] obj = this.queryArray(query);
        if (obj != null && obj.length > 0 && obj[0] instanceof Buffer) {
            return (Buffer)obj[0];
        }
        return null;
    }

    public Object[] queryArray(RasterQuery query) throws ProcessInterruptedException, QueryException {
        Object[] result = null;
        DefaultRasterQuery q = this.currentQuery = (DefaultRasterQuery)query;
        if (this.isTiled() || this.provider instanceof RemoteRasterProvider) {
            q.dontBuildBuffer();
        }
        Buffer buf = null;
        if (q.requestHasShift()) {
            FramedBufferResampling framedBufferResampling = new FramedBufferResampling(q, this);
            buf = framedBufferResampling.query(this.provider);
        } else {
            q.calculateParameters(this);
            try {
                buf = q.isReadOnly() && !this.isTiled() ? q.getBufferForProviders() : ((AbstractRasterProvider)this.provider).getDataSet(q);
            }
            catch (RasterDriverException e) {
                throw new QueryException("Error getting data", (Exception)((Object)e));
            }
            if (q.isSupersamplingOptionActive() && q.isSupersamplingTheRequest()) {
                buf = buf.getAdjustedWindow(q.getBufWidth(), q.getBufHeight(), 1);
            }
        }
        if (buf != null) {
            buf.setDataExtent(q.getAdjustedRequestBoundingBox().toRectangle2D());
        }
        result = new Object[]{buf};
        this.lastBuffer = q.isStoredLastBuffer() ? buf : null;
        q.storeLastBuffer(false);
        if (result != null && result.length > 0 && result[0] instanceof Buffer) {
            ((Buffer)result[0]).setStore((RasterDataStore)this);
            if (this.getNoDataValue() != null && this.getNoDataValue().isDefined()) {
                ((Buffer)result[0]).setNoDataValue(this.getNoDataValue());
            }
            return result;
        }
        return null;
    }

    @Override
    public Extent adjustToExtent(Extent e) {
        Extent currentExtent = this.getExtent();
        double minx = e.getMin().getX() < currentExtent.getMin().getX() ? currentExtent.getMin().getX() : e.getMin().getX();
        double maxx = e.getMax().getX() > currentExtent.getMax().getX() ? currentExtent.getMax().getX() : e.getMax().getX();
        double miny = e.getMin().getY() < currentExtent.getMin().getY() ? currentExtent.getMin().getY() : e.getMin().getY();
        double maxy = e.getMax().getY() > currentExtent.getMax().getY() ? currentExtent.getMax().getY() : e.getMax().getY();
        return new ExtentImpl(minx, maxy, maxx, miny);
    }

    public String getFullName() {
        return this.getName();
    }

    public Buffer getLastBuffer() {
        return this.lastBuffer;
    }

    public TimeSeries getTimeSerials() throws RmfSerializerException {
        if (this.getProvider() instanceof RasterProvider) {
            return ((RasterProvider)this.getProvider()).getTimeSerials();
        }
        return null;
    }

    public void setTimeSerials(TimeSeries serialInfo) throws RmfSerializerException {
        if (this.getProvider() instanceof RasterProvider) {
            ((RasterProvider)this.getProvider()).setTimeSerials(serialInfo);
        }
    }

    public abstract void saveColorTableToRmf(ColorTable var1) throws RmfSerializerException;

    public abstract void saveGeoPointListToRmf(GeoPointList var1) throws RmfSerializerException;

    public abstract void saveROIFileListToRmf(List<File> var1) throws RmfSerializerException;

    public abstract void saveSerialInfoToRmf(TimeSeries var1) throws RmfSerializerException;

    public abstract boolean loadSerialInfoFromRmf(TimeSeries var1);

    public Vectorization createVectorizeObject() throws QueryException, ProcessInterruptedException {
        return new PotraceVectorization(this);
    }

    public Render getRender() {
        if (this.render == null) {
            this.render = new DefaultRender(this);
        }
        return this.render;
    }

    public void setRender(Render render) {
        this.render = render;
    }

    public boolean isFileSupported(String fName) {
        return RasterLocator.getManager().getProviderServices().isExtensionSupported(fName);
    }

    public static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager == null) {
            return;
        }
        if (manager.getDefinition("DataProvider") == null) {
            DynStruct defnition = manager.addDefinition("DataProvider", "DataProvider");
            defnition.extend("metadata", "DataProvider");
        }
    }

    public int getSourceType() {
        return ((RasterProvider)this.getProvider()).getSourceType();
    }

    public void intializePhase1(DataManager dataManager, DataStoreParameters parameters) throws InitializeException {
        DynObjectManager dynManager = ToolsLocator.getDynObjectManager();
        this.dynobj = (DelegatedDynObject)dynManager.createDynObject(MetadataLocator.getMetadataManager().getDefinition("SpatialProvider"));
        this.dataManager = dataManager;
        this.parameters = parameters;
    }

    public void intializePhase2(DataStoreProvider provider) throws InitializeException {
        this.setProvider((RasterProvider)provider);
    }

    public DataManager getManager() {
        return this.dataManager;
    }

    public String getProviderName() {
        return this.getProvider().getProviderName();
    }

    public void refresh() throws DataException {
    }

    public DataSet getDataSet() throws DataException {
        RasterQuery query = DefaultRasterManager.getInstance().createQuery();
        query.setSupersamplingOption(false);
        query.setAreaOfInterest();
        int[] bands = new int[this.getBandCount()];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = i;
        }
        query.setDrawableBands(bands);
        return this.getDataSet((DataQuery)query);
    }

    public DataSet getDataSet(DataQuery dataQuery) throws DataException {
        if (dataQuery instanceof RasterQuery) {
            Object[] obj = null;
            try {
                obj = this.queryArray((RasterQuery)dataQuery);
            }
            catch (ProcessInterruptedException e) {
                throw new RasterDriverException("", (Exception)((Object)e));
            }
            catch (QueryException e) {
                throw new RasterDriverException(e.getMessage(), (Exception)((Object)e));
            }
            if (obj != null && obj.length > 0 && obj[0] instanceof Buffer) {
                return (Buffer)obj[0];
            }
        }
        return null;
    }

    public void accept(Visitor visitor, DataQuery dataQuery) throws BaseException {
    }

    public void getDataSet(Observer observer) throws DataException {
        RasterQuery query = DefaultRasterManager.getInstance().createQuery();
        query.setSupersamplingOption(false);
        query.setAreaOfInterest();
        int[] bands = new int[this.getBandCount()];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = i;
        }
        query.setDrawableBands(bands);
        this.getDataSet((DataQuery)query, observer);
    }

    public void getDataSet(DataQuery dataQuery, Observer observer) throws DataException {
        if (dataQuery instanceof RasterQuery) {
            Object[] obj = null;
            try {
                obj = this.queryArray((RasterQuery)dataQuery);
            }
            catch (ProcessInterruptedException processInterruptedException) {
            }
            catch (QueryException e) {
                throw new RasterDriverException(e.getMessage(), (Exception)((Object)e));
            }
            if (obj != null && obj.length > 0 && obj[0] instanceof Buffer) {
                observer.update((Observable)this, obj[0]);
            }
        }
    }

    public DataSet getSelection() throws DataException {
        return null;
    }

    public void setSelection(DataSet selection) throws DataException {
    }

    public DataSet createSelection() throws DataException {
        return null;
    }

    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        return null;
    }

    public DataServerExplorer getExplorer() throws DataException, ValidateDataParametersException {
        return this.explorer;
    }

    public void setExplorer(RasterDataServerExplorer explorer) {
        this.explorer = explorer;
    }

    public DataQuery createQuery() {
        return new DefaultRasterQuery();
    }

    public Object getMetadataID() {
        if (this.parameters != null && this.parameters instanceof RasterFileStoreParameters) {
            return ((RasterFileStoreParameters)this.parameters).getFile();
        }
        if (this.parameters != null && this.parameters instanceof RasterDataParameters) {
            return ((RasterDataParameters)this.parameters).getURI();
        }
        return null;
    }

    public Set<?> getMetadataChildren() {
        return null;
    }

    public void doDispose() {
    }

    public void accept(Visitor visitor) throws BaseException {
    }

    public void disableNotifications() {
    }

    public void enableNotifications() {
    }

    public void beginComplexNotification() {
    }

    public void endComplexNotification() {
    }

    public void addObserver(Observer o) {
    }

    public void deleteObserver(Observer o) {
    }

    public void deleteObservers() {
    }

    public DynClass getDynClass() {
        return this.dynobj.getDynClass();
    }

    public void implement(DynClass dynClass) {
        this.dynobj.implement(dynClass);
    }

    public void delegate(DynObject dynObject) {
        this.dynobj.delegate(dynObject);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        return this.dynobj.getDynValue(name);
    }

    public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        this.dynobj.setDynValue(name, value);
    }

    public boolean hasDynValue(String name) {
        return this.dynobj.hasDynValue(name);
    }

    public boolean hasDynMethod(String name) {
        if (this.metadata instanceof DynObject_v2) {
            return ((DynObject_v2)this.metadata).hasDynMethod(name);
        }
        return false;
    }

    public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
        return this.dynobj.invokeDynMethod((Object)this, name, args);
    }

    public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
        return this.dynobj.invokeDynMethod((Object)this, code, args);
    }

    public void clear() {
        if (this.dynobj != null) {
            this.dynobj.clear();
        }
    }

    public DataStoreParameters getParameters() {
        return this.parameters;
    }

    public CoverageSelection createDefaultCoverageSelection() throws DataException {
        return null;
    }

    public CoverageStore getCoverageStore() {
        return this;
    }

    public abstract CoverageStoreProvider getProvider();

    public void notifyChange(String notification) {
        this.delegateObservable.notifyObservers((Object)new DefaultCoverageStoreNotification(this, notification));
    }

    public void notifyChange(String arg0, Resource arg1) {
    }

    public void notifyChange(String notification, Command command) {
        this.delegateObservable.notifyObservers((Object)new DefaultCoverageStoreNotification(this, notification, command));
    }

    public DataStore getStore() {
        return this;
    }

    public void close() {
        if (this.lastBuffer != null) {
            this.lastBuffer.dispose();
        }
    }

    protected void finalize() throws Throwable {
        this.currentQuery = null;
        if (this.palette != null) {
            for (int i = 0; i < this.palette.length; ++i) {
                this.palette[i] = null;
            }
            this.palette = null;
        }
        this.lastBuffer = null;
        this.dataManager = null;
        this.parameters = null;
        this.metadata = null;
        this.delegateObservable = null;
        this.render = null;
        super.finalize();
    }

    public void useCache(String providerName, DynObject parameters) throws DataException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DataCache getCache() {
        return null;
    }

    public ResourcesStorage getResourcesStorage() {
        return null;
    }

    public StoresRepository getStoresRepository() {
        return null;
    }
}

