/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.DefaultRasterQuery;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.FramedBufferResampling;

public class Supersampling {
    private DefaultRasterQuery query = null;
    private DefaultRasterQuery originalQuery = null;
    private RasterDataStore store = null;
    private FramedBufferResampling framedBufferResampling = null;
    protected byte byteNoData = 0;
    protected short shortNoData = Short.MIN_VALUE;
    protected int intNoData = Integer.MIN_VALUE;
    protected float floatNoData = -99999.0f;
    protected double doubleNoData = -99999.0;

    public Supersampling(DefaultRasterQuery q, RasterDataStore store) {
        this.query = q;
        this.store = store;
        this.setNoDataValue(store.getNoDataValue());
        this.originalQuery = (DefaultRasterQuery)this.query.clone();
    }

    public Buffer query(RasterProvider provider) throws QueryException, ProcessInterruptedException {
        this.query.calculateParameters(this.store);
        Buffer bufResult = null;
        Buffer buf = null;
        try {
            if (this.query.requestHasShift()) {
                this.framedBufferResampling = new FramedBufferResampling(this.originalQuery, this.store);
                buf = this.framedBufferResampling.query(provider);
            } else {
                buf = ((AbstractRasterProvider)provider).getDataSet(this.query);
            }
            bufResult = this.supersampleBuffer(buf);
            buf.dispose();
        }
        catch (RasterDriverException e) {
            throw new QueryException("Error getting data", (Exception)((Object)e));
        }
        return bufResult;
    }

    private Buffer supersampleBuffer(Buffer buf) {
        int col;
        int row;
        Object[] data;
        int width = this.query.getBufWidth();
        int height = this.query.getBufHeight();
        double[] step = this.query.getStep();
        Buffer result = this.buildBuffer(buf.getBandCount(), width, height, buf.getDataType());
        int[] r = new int[height];
        int[] c = new int[width];
        this.calcSupersamplingStepsArrays(r, c, step);
        if (buf.getDataType() == 0) {
            data = new byte[buf.getBandCount()];
            for (row = 0; row < height; ++row) {
                for (col = 0; col < width; ++col) {
                    buf.getElemByte(r[row], c[col], data);
                    result.setElemByte(row, col, data);
                }
            }
        }
        if (buf.getDataType() == 2) {
            data = new short[buf.getBandCount()];
            for (row = 0; row < height; ++row) {
                for (col = 0; col < width; ++col) {
                    buf.getElemShort(r[row], c[col], (short[])data);
                    result.setElemShort(row, col, (short[])data);
                }
            }
        }
        if (buf.getDataType() == 3) {
            data = new int[buf.getBandCount()];
            for (row = 0; row < height; ++row) {
                for (col = 0; col < width; ++col) {
                    buf.getElemInt(r[row], c[col], (int[])data);
                    result.setElemInt(row, col, (int[])data);
                }
            }
        }
        if (buf.getDataType() == 4) {
            data = new float[buf.getBandCount()];
            for (row = 0; row < height; ++row) {
                for (col = 0; col < width; ++col) {
                    buf.getElemFloat(r[row], c[col], (float[])data);
                    result.setElemFloat(row, col, (float[])data);
                }
            }
        }
        if (buf.getDataType() == 5) {
            data = new double[buf.getBandCount()];
            for (row = 0; row < height; ++row) {
                for (col = 0; col < width; ++col) {
                    buf.getElemDouble(r[row], c[col], (double[])data);
                    result.setElemDouble(row, col, (double[])data);
                }
            }
        }
        return result;
    }

    private void calcSupersamplingStepsArrays(int[] r, int[] c, double[] step) {
        double pos = step[1];
        for (int row = 0; row < r.length; ++row) {
            r[row] = (int)(pos / step[3]);
            pos += 1.0;
        }
        pos = step[0];
        for (int col = 0; col < c.length; ++col) {
            c[col] = (int)(pos / step[2]);
            pos += 1.0;
        }
    }

    private void setNoDataValue(NoData noData) {
        if (noData == null) {
            return;
        }
        switch (this.store.getDataType()[0]) {
            case 0: {
                this.byteNoData = noData.getValue().byteValue();
                break;
            }
            case 2: {
                this.shortNoData = noData.getValue().shortValue();
                break;
            }
            case 3: {
                this.intNoData = noData.getValue().intValue();
                break;
            }
            case 4: {
                this.floatNoData = noData.getValue().floatValue();
                break;
            }
            case 5: {
                this.doubleNoData = noData.getValue().doubleValue();
            }
        }
    }

    private Buffer buildBuffer(int nbands, int w, int h, int datatype) {
        Buffer bufResult = DefaultRasterManager.getInstance().createBuffer(datatype, w, h, nbands, true);
        for (int i = 0; i < bufResult.getBandCount(); ++i) {
            this.clearMaskBuffer(bufResult, i);
        }
        return bufResult;
    }

    protected void clearMaskBuffer(Buffer buf, int nBand) {
        if (buf.getDataType() == 0) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.byteNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 2) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.shortNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 3) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.intNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 4) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.floatNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 5) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.doubleNoData);
                }
            }
            return;
        }
    }
}

