/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.util.CRSUtils;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ProjectionRmfSerializer
extends ClassSerializer {
    private final String MAIN_TAG = "Projection";
    private IProjection projection = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append("Projection", "", ProjectionRmfSerializer.class);
    }

    public ProjectionRmfSerializer(IProjection projection) {
        this.projection = projection;
    }

    public ProjectionRmfSerializer() {
    }

    @Override
    public String getMainTag() {
        return "Projection";
    }

    @Override
    public Object getResult() {
        return this.projection;
    }

    @Override
    public void read(String xml) throws ParsingException {
        CRSUtils util = RasterLocator.getManager().getCRSUtils();
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "Projection");
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (!parser.getName().equals("WktProjection")) break;
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                if (!parser.getAttributeName(i).equals("value") || !RasterLocator.getManager().isCRSUtilSupported()) continue;
                                this.projection = util.convertWktToIProjection(parser.getAttributeValue(i));
                            }
                            break;
                        }
                    }
                    tag = parser.next();
                }
            }
            ((Reader)reader).close();
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
    }

    @Override
    public String write() throws IOException {
        CRSUtils util = RasterLocator.getManager().getCRSUtils();
        StringBuffer b = new StringBuffer();
        if (this.projection == null || !RasterLocator.getManager().isCRSUtilSupported()) {
            return null;
        }
        b.append("<Projection>\n");
        b.append("\t<WktProjection");
        String wkt = util.convertIProjectionToWkt(this.projection);
        if (wkt == null) {
            return null;
        }
        b.append(" value=\"" + this.removeQuotes(wkt) + "\"/>\n");
        b.append("</Projection>\n");
        return b.toString();
    }

    private String removeQuotes(String wkt) {
        return wkt.replace("\"", "");
    }
}

