/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.cachestruct;

import java.awt.geom.Point2D;
import org.gvsig.raster.osm.cachestruct.TileMatrix;

public class TileMatrixLimits {
    private TileMatrix tileMatrix = null;
    private int minTileRow = 0;
    private int maxTileRow = 0;
    private int minTileCol = 0;
    private int maxTileCol = 0;

    public TileMatrix getTileMatrix() {
        if (this.tileMatrix == null) {
            this.tileMatrix = new TileMatrix();
        }
        return this.tileMatrix;
    }

    public Point2D[] getTileExtent(int x, int y) {
        double sizeXTile = (double)this.getTileMatrix().getTileWidth() * this.getTileMatrix().getScaleXDenominator();
        double sizeYTile = (double)this.getTileMatrix().getTileWidth() * this.getTileMatrix().getScaleYDenominator();
        double initX = this.getTileMatrix().getTopLeftCorner()[0] + sizeXTile * (double)x;
        double initY = this.getTileMatrix().getTopLeftCorner()[1] - sizeYTile * (double)y;
        Point2D[] p = new Point2D[]{new Point2D.Double(initX, initY), new Point2D.Double(initX + sizeXTile, initY - sizeYTile)};
        return p;
    }

    public int getMinTileRow() {
        return this.minTileRow;
    }

    public void setMinTileRow(int minTileRow) {
        this.minTileRow = minTileRow;
    }

    public int getMaxTileRow() {
        return this.maxTileRow;
    }

    public void setMaxTileRow(int maxTileRow) {
        this.maxTileRow = maxTileRow;
    }

    public int getMinTileCol() {
        return this.minTileCol;
    }

    public void setMinTileCol(int minTileCol) {
        this.minTileCol = minTileCol;
    }

    public int getMaxTileCol() {
        return this.maxTileCol;
    }

    public void setMaxTileCol(int maxTileCol) {
        this.maxTileCol = maxTileCol;
    }

    public void print() {
        System.out.println("  *****TileMatrixLimits******");
        System.out.println("  MaxTileCol:" + this.getMaxTileCol());
        System.out.println("  MaxTileRow:" + this.getMaxTileRow());
        System.out.println("  MinTileCol:" + this.getMinTileCol());
        System.out.println("  MinTileRow:" + this.getMinTileRow());
        if (this.tileMatrix != null) {
            this.tileMatrix.print();
        }
    }
}

