/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.db.DBServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.geodb.AbstractWizardDBView;
import org.gvsig.geodb.TableInfo;
import org.gvsig.geodb.TableInfoController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWizardDB
extends WizardPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractWizardDB.class);
    protected WizardDBView view;
    private PickerController<JDBCServerExplorerParameters> pickerConnection;
    protected JListWithCheckbox lwcTables;
    protected Map<String, TableInfo> tablesInfo = null;
    protected FilteredListController tablesFilterController;
    protected TableInfoController tableInfoController;

    public AbstractWizardDB() {
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.view = new WizardDBView();
        toolsSwingManager.translate((JComponent)this.view.lblColumns);
        toolsSwingManager.translate((JComponent)this.view.lblConnection);
        toolsSwingManager.translate(this.view.lblFilter);
        toolsSwingManager.translate(this.view.lblGeometryField);
        toolsSwingManager.translate(this.view.lblIdField);
        toolsSwingManager.translate(this.view.lblName);
        toolsSwingManager.translate(this.view.lblProjection);
        toolsSwingManager.translate((JComponent)this.view.lblTable);
        toolsSwingManager.addClearButton((JTextComponent)this.view.txtName);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.view.txtName);
        this.lwcTables = toolsSwingManager.createJListWithCheckbox(this.view.lstTables);
        this.lwcTables.addListSelectionListener(e -> this.doChangeTableSelected());
        this.initializePickerConnection();
        this.lwcTables.addChecksListener(e -> this.doChangeTableChecked(e.getFirstIndex(), e.getLastIndex()));
        this.tablesFilterController = toolsSwingManager.createFilteredListController(this.view.lstTables, (JTextComponent)this.view.txtTablesFilter, this.view.btnTablesFilter);
        this.tableInfoController = new TableInfoController(this.view.btnDeselectAllColumns, this.view.btnSelectAllColumns, this.view.lstColumns, this.view.txtName, this.view.cboIdField, this.view.cboGeometryField, this.view.txtProjection, this.view.btnProjection, this.view.txtFilter, this.view.btnFilter, this.view.btnFilterBookmarks, this.view.btnFilterHistory, this.view.btnAdvancedProperties, this.view.lblReadOnlyNotification, this.view.pnlCfgActions, this.view.btnChangeViewProjection);
        this.view.btnChangeViewProjection.setVisible(this.requireGeometry());
        this.tableInfoController.addChangeListener(e -> this.checkFinishable());
        this.clearTables();
        this.setEditableTables(false);
        this.setLayout(new BorderLayout());
        this.add(this.view, "Center");
        ToolsSwingUtils.ensureRowsCols((JComponent)((Object)this), (int)24, (int)90, (int)25, (int)100);
    }

    private void initializePickerConnection() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.pickerConnection = dataSwingManager.createJDBCConnectionPickerController(this.view.cboConnection, this.view.btnConnection);
        this.pickerConnection.addChangeListener(e -> {
            this.doUpdateTables();
            this.setEditableTables(true);
        });
    }

    protected abstract boolean requireGeometry();

    public Collection<TableInfo> getTablesInformation() {
        this.updateTableInfoFromUI();
        if (this.tablesInfo == null) {
            this.tablesInfo = new HashMap<String, TableInfo>();
        }
        return this.tablesInfo.values();
    }

    private void clearTables() {
        this.lwcTables.setModel(new DefaultListModel());
        this.lwcTables.getCheckedModel().clearSelection();
        this.clearTableConfig();
    }

    private void clearTableConfig() {
        this.tableInfoController.put(null);
    }

    private void setEditableTables(boolean enable) {
        this.view.lstTables.setEnabled(enable);
        this.tableInfoController.setEditable(enable);
    }

    public void setConnection(JDBCServerExplorerParameters connection) {
        this.pickerConnection.set((Object)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doUpdateTables() {
        JDBCServerExplorerParameters connection = (JDBCServerExplorerParameters)this.pickerConnection.get();
        if (connection == null) {
            this.clearTables();
            return;
        }
        DataManager dataManager = DALLocator.getDataManager();
        JDBCServerExplorer explorer = null;
        try {
            JDBCStoreParameters jdbcParams;
            explorer = (JDBCServerExplorer)dataManager.openServerExplorer(connection.getProviderName(), (DataServerExplorerParameters)connection);
            ArrayList<TableInfo> parameters = new ArrayList<TableInfo>();
            for (DataStoreParameters params : explorer.list(0, 1)) {
                jdbcParams = (JDBCStoreParameters)params;
                parameters.add(new TableInfo(jdbcParams.getTable(), jdbcParams, this.requireGeometry(), false));
            }
            for (DataStoreParameters params : explorer.list(0, 2)) {
                jdbcParams = (JDBCStoreParameters)params;
                parameters.add(new TableInfo(jdbcParams.getTable(), jdbcParams, this.requireGeometry(), true));
            }
            parameters.sort((o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
            this.tablesInfo = new HashMap<String, TableInfo>();
            DefaultListModel<TableInfo> model = new DefaultListModel<TableInfo>();
            for (TableInfo x : parameters) {
                model.addElement(x);
                this.tablesInfo.put(x.getDocumentName(), x);
            }
            this.lwcTables.setModel(model);
            this.lwcTables.getCheckedModel().clearSelection();
        }
        catch (Exception exception) {
            DisposeUtils.disposeQuietly(explorer);
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(explorer);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)explorer);
    }

    private void doChangeTableSelected() {
        TableInfo tableInfo = (TableInfo)((Object)this.lwcTables.getSelectedValue());
        if (tableInfo == null) {
            this.clearTableConfig();
            this.tableInfoController.setEditable(false);
            return;
        }
        this.updateTableInfoFromUI();
        this.tableInfoController.put(tableInfo);
    }

    private void doChangeTableChecked(int firstIndex, int lastIndex) {
        ListSelectionModel checkedModel = this.lwcTables.getCheckedModel();
        for (int i = firstIndex; i <= lastIndex; ++i) {
            TableInfo tableInfo = (TableInfo)((Object)this.lwcTables.getModel().getElementAt(i));
            tableInfo.setSelected(checkedModel.isSelectedIndex(i));
        }
        this.checkFinishable();
    }

    public void selectTable(TableInfo tableInfo) {
        ListModel model = this.lwcTables.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            TableInfo currTableInfo = (TableInfo)((Object)model.getElementAt(i));
            if (currTableInfo != tableInfo) continue;
            this.lwcTables.setSelectedIndex(i);
            break;
        }
    }

    private void updateTableInfoFromUI() {
        TableInfo previousInfo;
        String previousId = this.tableInfoController.getId();
        if (previousId == null) {
            return;
        }
        if (this.tablesInfo != null && !this.tablesInfo.isEmpty() && (previousInfo = this.tablesInfo.get(previousId)) != null) {
            this.tableInfoController.fetch(previousInfo);
        }
    }

    public void initWizard() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.setTabName(i18n.getTranslation("_Database"));
    }

    public boolean areSettingsValid() {
        boolean hasInvalidValues = false;
        boolean hasSelectedTables = false;
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            hasSelectedTables = true;
            if (tableInfo.hasValidValues()) continue;
            hasInvalidValues = true;
        }
        return hasSelectedTables && !hasInvalidValues;
    }

    public DataStoreParameters[] getParameters() {
        int sz = 0;
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            ++sz;
        }
        if (sz == 0) {
            return null;
        }
        DataStoreParameters[] dbParameters = new DataStoreParameters[sz];
        int n = 0;
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            dbParameters[n++] = tableInfo.getParameters();
        }
        return dbParameters;
    }

    public void execute() {
        this.executeWizard();
    }

    public void close() {
    }

    protected void checkFinishable() {
        boolean finishable = this.areSettingsValid();
        this.callStateChanged(finishable);
    }

    public void setMapContext(MapContext mapContext) {
        super.setMapContext(mapContext);
        this.tableInfoController.setMapContext(mapContext);
    }

    public boolean addArguments(Arguments args) {
        super.addArguments(args);
        if (args == null) {
            return false;
        }
        List parameters = args.getListOf("dataParameters", OpenDataStoreParameters.class);
        if (parameters == null) {
            return false;
        }
        boolean res = false;
        List layerNames = (List)args.get("LayerNames", null);
        for (int n = 0; n < parameters.size(); ++n) {
            OpenDataStoreParameters parameter = (OpenDataStoreParameters)parameters.get(n);
            DataManager dataManager = DALLocator.getDataManager();
            if (!(parameter instanceof JDBCStoreParameters)) continue;
            try {
                JDBCStoreParameters params = (JDBCStoreParameters)parameter;
                DBServerExplorerParameters serverParameters = (DBServerExplorerParameters)dataManager.createServerExplorerParameters(params.getProviderName());
                ToolsLocator.getDynObjectManager().copy((DynObject)params, (DynObject)serverParameters);
                this.pickerConnection.setEnabled(false);
                this.pickerConnection.set((Object)((JDBCServerExplorerParameters)serverParameters));
                this.pickerConnection.setEnabled(true);
                this.doUpdateTables();
                this.setEditableTables(true);
                ListModel tablesModel = this.lwcTables.getModel();
                for (int i = 0; i < tablesModel.getSize(); ++i) {
                    TableInfo tableInfo = (TableInfo)((Object)tablesModel.getElementAt(i));
                    if (!StringUtils.equalsIgnoreCase((CharSequence)tableInfo.getTable(), (CharSequence)params.getTable()) || !StringUtils.equalsIgnoreCase((CharSequence)tableInfo.getSchema(), (CharSequence)params.getSchema())) continue;
                    tableInfo.fetch(params);
                    this.lwcTables.setSelectedIndex(i);
                    this.lwcTables.getCheckedModel().addSelectionInterval(i, i);
                    tableInfo.setSelected(true);
                    if (layerNames != null && n < layerNames.size() && StringUtils.isNotBlank((CharSequence)((CharSequence)layerNames.get(n)))) {
                        tableInfo.setDocumentName((String)layerNames.get(n));
                    }
                    this.tableInfoController.put(tableInfo);
                    this.lwcTables.ensureIndexIsVisible(this.lwcTables.getSelectedIndex());
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Can't add connection parameters", (Throwable)ex);
            }
            res = true;
        }
        return res;
    }

    protected static class WizardDBView
    extends AbstractWizardDBView {
        protected WizardDBView() {
        }

        @Override
        public ImageIcon loadImage(String imageName) {
            return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
        }
    }
}

