/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.vectorialdb.visibility;

import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.gvsig.geodb.vectorialdb.visibility.VisibilityScaleSelectorView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityScaleSelector
extends VisibilityScaleSelectorView
implements Component {
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityScaleSelector.class);
    private static final int SCALE_ABOVE_DENOMINATOR_1_1000 = 2000;
    private static final int SCALE_BELOW_DENOMINATOR_1_1000 = 1;
    private static final int SCALE_ABOVE_DENOMINATOR_1_5000 = 8000;
    private static final int SCALE_BELOW_DENOMINATOR_1_5000 = 1;
    private static final int SCALE_ABOVE_DENOMINATOR_1_25000 = 40000;
    private static final int SCALE_BELOW_DENOMINATOR_1_25000 = 1;

    public VisibilityScaleSelector() {
        this.initComponents();
        this.translate();
    }

    private void initComponents() {
        this.rdb1_1000.addActionListener(e -> {
            this.txtScaleAboveDenominator.setValue(2000);
            this.txtScaleBelowDenominator.setValue(1);
        });
        this.rdb1_5000.addActionListener(e -> {
            this.txtScaleAboveDenominator.setValue(8000);
            this.txtScaleBelowDenominator.setValue(1);
        });
        this.rdb1_25000.addActionListener(e -> {
            this.txtScaleAboveDenominator.setValue(40000);
            this.txtScaleBelowDenominator.setValue(1);
        });
        this.rdbDontAssignScale.addActionListener(e -> {
            this.txtScaleAboveDenominator.setValue(-1);
            this.txtScaleBelowDenominator.setValue(-1);
        });
        this.rdbDontAssignScale.setSelected(true);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)25, (int)80, (int)30, (int)100);
    }

    private void translate() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        String value = String.valueOf(10000);
        this.lblDescription.setText(i18n.getTranslation(this.lblDescription.getText(), new String[]{value}));
        i18nc.translate(this.lbl_1_25000_description, true);
        i18nc.translate(this.lbl_1_5000_description, true);
        i18nc.translate(this.lbl_1_1000_description, true);
        i18nc.translate((AbstractButton)this.rdbConditions, true);
        i18nc.translate((AbstractButton)this.rdbDontAssignScale);
        i18nc.translate(this.lblBelow, true);
        i18nc.translate(this.lblAbove, true);
        i18nc.translate(this.lblMaximumScale, true);
        i18nc.translate(this.lblMinimumScale, true);
        i18nc.translate((AbstractButton)this.chkRememberAnswer, true);
        i18nc.translate((AbstractButton)this.chkDoNotAskScale, true);
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public int getScaleAboveDenominator() {
        if (this.rdb1_1000.isSelected()) {
            return 2000;
        }
        if (this.rdb1_5000.isSelected()) {
            return 8000;
        }
        if (this.rdb1_25000.isSelected()) {
            return 40000;
        }
        if (this.rdbConditions.isSelected()) {
            return ((Number)this.txtScaleAboveDenominator.getValue()).intValue();
        }
        return Integer.MAX_VALUE;
    }

    public int getScaleBelowDenominator() {
        if (this.rdb1_1000.isSelected()) {
            return 1;
        }
        if (this.rdb1_5000.isSelected()) {
            return 1;
        }
        if (this.rdb1_25000.isSelected()) {
            return 1;
        }
        if (this.rdbConditions.isSelected()) {
            return ((Number)this.txtScaleBelowDenominator.getValue()).intValue();
        }
        return 1;
    }

    public boolean getRememberAnswer() {
        return this.chkRememberAnswer.isSelected();
    }

    public boolean getDoNotAskScaleAgain() {
        return this.chkDoNotAskScale.isSelected();
    }

    public JComponent asJComponent() {
        return this;
    }
}

