/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.xyshift;

import es.unex.sextante.core.Sextante;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class XYShiftOperation
extends GeometryOperation {
    private double x = 0.0;
    private double y = 0.0;
    private GeometryManager geometryManager = null;

    public XYShiftOperation(double x, double y, AbstractSextanteGeoProcess p) {
        super(p);
        this.x = x;
        this.y = y;
        this.geometryManager = GeometryLocator.getGeometryManager();
    }

    public EditableFeature invoke(Geometry g, Feature feature) {
        List geomList = feature.getGeometries();
        try {
            if (!this.persister.isCompatibleType(feature.getDefaultGeometry())) {
                return this.lastEditFeature;
            }
            if (geomList == null) {
                Geometry oldGeom = feature.getDefaultGeometry();
                Geometry newGeom = this.shiftGeometry(oldGeom);
                this.lastEditFeature = this.persister.addFeature(feature, newGeom);
            } else {
                Iterator itGeom = geomList.iterator();
                EditableFeature editFeat = null;
                int nGeom = 0;
                while (itGeom.hasNext()) {
                    Geometry oldGeom = (Geometry)itGeom.next();
                    Geometry newGeom = this.shiftGeometry(oldGeom);
                    ++nGeom;
                    if (editFeat == null) {
                        editFeat = this.persister.addFeature(feature, newGeom);
                    } else {
                        this.persister.addGeometryToExistingFeature(editFeat, newGeom);
                    }
                    this.lastEditFeature = editFeat;
                }
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (CreateGeometryException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        return this.lastEditFeature;
    }

    private Geometry shiftGeometry(Geometry oldGeom) throws CreateGeometryException {
        if (oldGeom != null) {
            Geometry cloneGeometry = oldGeom.cloneGeometry();
            cloneGeometry.move(this.x, this.y);
            return cloneGeometry;
        }
        return oldGeom;
    }

    public void invoke(Geometry g, EditableFeature feature) {
    }
}

