/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import org.gvsig.raster.lib.legend.api.TransparencyRange;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultTransparencyRange
implements TransparencyRange {
    private static final String PERSISTENCE_NAME = "transparencyRange";
    private static final String PERSISTENCE_DESCRIPTION = "transparencyRange";
    private static final String IS_AND_PERSISTENCE_FIELD = "isAnd";
    private static final String RED_PERSISTENCE_FIELD = "red";
    private static final String GREEN_PERSISTENCE_FIELD = "green";
    private static final String BLUE_PERSISTENCE_FIELD = "blue";
    private static final String ALPHA_PERSISTENCE_FIELD = "aplha";
    private boolean isAnd;
    private int[] red;
    private int[] green;
    private int[] blue;
    private int alpha;

    public DefaultTransparencyRange() {
        this.isAnd = false;
        this.red = new int[2];
        this.red[0] = -1;
        this.red[1] = -1;
        this.green = new int[2];
        this.green[0] = -1;
        this.green[1] = -1;
        this.blue = new int[2];
        this.blue[0] = -1;
        this.blue[1] = -1;
        this.alpha = -1;
    }

    public DefaultTransparencyRange(int[] redRange, int[] greenRange, int[] blueRange, int alpha, boolean isAnd) {
        this.isAnd = isAnd;
        this.setRGB(redRange, greenRange, blueRange);
        this.setAlpha(alpha);
    }

    public boolean isAnd() {
        return this.isAnd;
    }

    public void setAnd(boolean flag) {
        this.isAnd = flag;
    }

    public int[] getBlue() {
        return this.blue;
    }

    public void setRGB(int[] red, int[] green, int[] blue) {
        if (red.length != 2 || green.length != 2 || blue.length != 2) {
            throw new IllegalArgumentException("Transparency range values only accepts 2 values for each color");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setBlue(int[] blue) {
        if (blue.length != 2) {
            throw new IllegalArgumentException("Transparency range values only accepts 2 values for each color");
        }
        this.blue = blue;
    }

    public int[] getGreen() {
        return this.green;
    }

    public void setGreen(int[] green) {
        if (green.length != 2) {
            throw new IllegalArgumentException("Transparency range values only accepts 2 values for each color");
        }
        this.green = green;
    }

    public int[] getRed() {
        return this.red;
    }

    public void setRed(int[] red) {
        if (red.length != 2) {
            throw new IllegalArgumentException("Transparency range values only accepts 2 values for each color");
        }
        this.red = red;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha value has to be between 0 and 255");
        }
        this.alpha = alpha;
    }

    public static void registerPersistence() {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        DynStruct definition = persistenceManager.getDefinition("transparencyRange");
        if (definition == null) {
            definition = persistenceManager.addDefinition(DefaultTransparencyRange.class, "transparencyRange", "transparencyRange", null, null);
            definition.addDynFieldArray(RED_PERSISTENCE_FIELD).setClassOfValue(Integer.class).setMandatory(false);
            definition.addDynFieldArray(GREEN_PERSISTENCE_FIELD).setClassOfValue(Integer.class).setMandatory(false);
            definition.addDynFieldArray(BLUE_PERSISTENCE_FIELD).setClassOfValue(Integer.class).setMandatory(false);
            definition.addDynFieldBoolean(IS_AND_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldInt(ALPHA_PERSISTENCE_FIELD).setMandatory(false);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(RED_PERSISTENCE_FIELD, this.getRed());
        state.set(BLUE_PERSISTENCE_FIELD, this.getBlue());
        state.set(GREEN_PERSISTENCE_FIELD, this.getGreen());
        state.set(IS_AND_PERSISTENCE_FIELD, this.isAnd);
        state.set(ALPHA_PERSISTENCE_FIELD, this.alpha);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.red = state.getIntArray(RED_PERSISTENCE_FIELD);
        this.green = state.getIntArray(GREEN_PERSISTENCE_FIELD);
        this.blue = state.getIntArray(BLUE_PERSISTENCE_FIELD);
        this.alpha = state.getInt(ALPHA_PERSISTENCE_FIELD);
        this.isAnd = state.getBoolean(IS_AND_PERSISTENCE_FIELD);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int[] redValues = this.getRed();
        if (redValues[0] < 0) {
            builder.append("*");
        } else if (redValues[0] == redValues[1]) {
            builder.append(redValues[0]);
        } else if (redValues.length > 1) {
            builder.append("[");
            for (int i = 0; i < redValues.length; ++i) {
                builder.append(redValues[i]);
                if (i >= redValues.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        if (this.isAnd()) {
            builder.append(" & ");
        } else {
            builder.append(" | ");
        }
        int[] greenValues = this.getGreen();
        if (greenValues[0] < 0) {
            builder.append("*");
        } else if (greenValues[0] == greenValues[1]) {
            builder.append(greenValues[0]);
        } else if (greenValues.length > 1) {
            builder.append("[");
            for (int i = 0; i < greenValues.length; ++i) {
                builder.append(greenValues[i]);
                if (i >= greenValues.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        if (this.isAnd()) {
            builder.append(" & ");
        } else {
            builder.append(" | ");
        }
        int[] blueValues = this.getBlue();
        if (blueValues[0] < 0) {
            builder.append("*");
        } else if (blueValues[0] == blueValues[1]) {
            builder.append(blueValues[0]);
        } else if (blueValues.length > 1) {
            builder.append("[");
            for (int i = 0; i < blueValues.length; ++i) {
                builder.append(blueValues[i]);
                if (i >= blueValues.length - 1) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        int alpha = this.getAlpha();
        if (alpha >= 0) {
            builder.append(" (alpha = ");
            builder.append(alpha);
            builder.append(")");
        }
        return builder.toString();
    }

    public boolean isSameRange(TransparencyRange otherRange) {
        if (otherRange.getRed().length != this.getRed().length) {
            return false;
        }
        if (otherRange.getGreen().length != this.getGreen().length) {
            return false;
        }
        if (otherRange.getBlue().length != this.getBlue().length) {
            return false;
        }
        if (otherRange.getRed()[0] != this.getRed()[0]) {
            return false;
        }
        if (otherRange.getRed()[1] != this.getRed()[1]) {
            return false;
        }
        if (otherRange.getGreen()[0] != this.getGreen()[0]) {
            return false;
        }
        if (otherRange.getGreen()[1] != this.getGreen()[1]) {
            return false;
        }
        if (otherRange.getBlue()[0] != this.getBlue()[0]) {
            return false;
        }
        return otherRange.getBlue()[1] == this.getBlue()[1];
    }
}

