/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.colorbalancehsl;

import java.util.List;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.impl.ColorManager;
import org.gvsig.raster.lib.legend.impl.RasterLegendManagerServices;
import org.gvsig.raster.lib.legend.impl.operations.colorbalancergb.AbstractColorBalanceOperation;

public class ColorBalanceHSLOperation
extends AbstractColorBalanceOperation {
    public static String HUE_PARAM = "hue";
    public static String LIGHTNESS_PARAM = "lightness";
    public static String SATURATION_PARAM = "saturation";
    private double hue = 0.0;
    private double lightness = 0.0;
    private double saturation = 0.0;

    public ColorBalanceHSLOperation(OperationFactory factory) {
        super(factory);
    }

    @Override
    protected void initialiceParams() {
        this.hue = (Double)this.getParameter(HUE_PARAM, 0);
        this.lightness = (Double)this.getParameter(LIGHTNESS_PARAM, 0);
        this.saturation = (Double)this.getParameter(SATURATION_PARAM, 0);
    }

    @Override
    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    @Override
    protected void processRow(Object[] inputRows, List outputRows) {
        int i;
        ColorManager colorManager = ((RasterLegendManagerServices)RasterLegendLocator.getRasterLegendManager()).getColorManager();
        byte[][] inputByteRows = new byte[inputRows.length][((byte[])inputRows[0]).length];
        for (i = 0; i < inputRows.length; ++i) {
            inputByteRows[i] = (byte[])inputRows[i];
        }
        for (i = 0; i < inputByteRows[0].length; ++i) {
            int band;
            byte[] value = new byte[4];
            value[0] = inputByteRows[0][i];
            value[1] = inputByteRows[1][i];
            value[2] = inputByteRows[2][i];
            double[] hsl = colorManager.RGBtoHSL(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
            hsl[0] = (hsl[0] + this.hue) % 360.0;
            hsl[1] = Math.max(Math.min(hsl[1] + this.saturation / 100.0, 1.0), 0.001);
            hsl[2] = Math.max(Math.min(hsl[2] + this.lightness / 100.0, 1.0), 0.0);
            int[] rgb = colorManager.HSLtoRGB(hsl[0], hsl[1], hsl[2]);
            for (band = 0; band < 3; ++band) {
                value[band] = (byte)rgb[band];
            }
            for (band = 0; band < inputRows.length; ++band) {
                ((byte[])outputRows.get((int)band))[i] = value[band];
            }
        }
    }
}

