/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.colorbalancergb;

import java.util.List;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.impl.ColorManager;
import org.gvsig.raster.lib.legend.impl.RasterLegendManagerServices;
import org.gvsig.raster.lib.legend.impl.operations.colorbalancergb.AbstractColorBalanceOperation;

public class ColorBalanceRGBOperation
extends AbstractColorBalanceOperation {
    public static String RED_PARAM = "red";
    public static String GREEN_PARAM = "green";
    public static String BLUE_PARAM = "blue";
    public static String LUMINOSITY_PARAM = "luminosity";
    private int red;
    private int green;
    private int blue;
    private boolean luminosity;

    public ColorBalanceRGBOperation(OperationFactory factory) {
        super(factory);
    }

    @Override
    protected void initialiceParams() {
        this.red = (Integer)this.getParameter(RED_PARAM, 0);
        this.green = (Integer)this.getParameter(GREEN_PARAM, 0);
        this.blue = (Integer)this.getParameter(BLUE_PARAM, 0);
        this.luminosity = (Boolean)this.getParameter(LUMINOSITY_PARAM, true);
    }

    @Override
    protected void processRow(Object[] inputRows, List outputRows) {
        int i;
        ColorManager colorManager = ((RasterLegendManagerServices)RasterLegendLocator.getRasterLegendManager()).getColorManager();
        byte[][] inputByteRows = new byte[inputRows.length][((byte[])inputRows[0]).length];
        for (i = 0; i < inputRows.length; ++i) {
            inputByteRows[i] = (byte[])inputRows[i];
        }
        for (i = 0; i < inputByteRows[0].length; ++i) {
            byte[] value = new byte[4];
            value[0] = inputByteRows[0][i];
            value[1] = inputByteRows[1][i];
            value[2] = inputByteRows[2][i];
            double lum = colorManager.getLuminosity(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
            value[0] = (byte)Math.min((value[0] & 0xFF) + (this.red >> 1), 255);
            value[1] = (byte)Math.min((value[1] & 0xFF) + (this.green >> 1), 255);
            value[2] = (byte)Math.min((value[2] & 0xFF) + (this.blue >> 1), 255);
            if (this.luminosity) {
                double[] hsl = colorManager.RGBtoHSL(value[0] & 0xFF, value[1] & 0xFF, value[2] & 0xFF);
                hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
                hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
                hsl[2] = (int)(lum * 255.0 + 0.5);
                int[] v1 = colorManager.HSLtoRGB((int)hsl[0] & 0xFFFFFFFF, (int)hsl[1] & 0xFFFFFFFF, (int)hsl[2] & 0xFFFFFFFF);
                for (int band = 0; band < 3; ++band) {
                    value[band] = Integer.valueOf(v1[band]).byteValue();
                }
            }
            for (int band = 0; band < inputRows.length; ++band) {
                ((byte[])outputRows.get((int)band))[i] = value[band];
            }
        }
    }
}

